/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.WillClose;
import net.lenni0451.commons.asm.mappings.Mappings;
import net.lenni0451.commons.asm.mappings.loader.MappingsProvider;

public abstract class MappingsLoader
implements MappingsProvider {
    private final IOProvider ioProvider;
    private Mappings mappings;

    public MappingsLoader(@WillClose InputStream inputStream) {
        this(() -> inputStream);
    }

    public MappingsLoader(File file) {
        this(file.toPath());
    }

    public MappingsLoader(Path path) {
        this(() -> Files.newInputStream(path, new OpenOption[0]));
    }

    private MappingsLoader(IOProvider ioProvider) {
        this.ioProvider = ioProvider;
    }

    @Override
    public Mappings getMappings() {
        if (this.mappings == null) {
            try {
                this.load();
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to load mappings", t);
            }
        }
        return this.mappings;
    }

    public final synchronized Mappings load() throws Throwable {
        if (this.mappings != null) {
            return this.mappings;
        }
        List<String> lines = this.readLines();
        this.mappings = this.load(lines);
        return this.mappings;
    }

    protected abstract Mappings load(List<String> var1) throws Throwable;

    private List<String> readLines() throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.ioProvider.load()));){
            List<String> list = br.lines().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
            return list;
        }
    }

    @FunctionalInterface
    private static interface IOProvider {
        public InputStream load() throws IOException;
    }
}

