/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings;

import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.asm.info.MemberDeclaration;
import net.lenni0451.commons.asm.mappings.Mappings;

final class Reverser {
    public static Mappings init(Mappings mappings) {
        Mappings reversed = mappings.emptyCopy();
        Reverser.recalculatePackages(mappings, reversed);
        return reversed;
    }

    public static void recalculatePackages(Mappings from, Mappings to) {
        to.packageMappings.clear();
        for (Map.Entry<String, String> entry : from.packageMappings.entrySet()) {
            to.packageMappings.put(entry.getValue(), entry.getKey());
        }
        Reverser.recalculateClasses(from, to);
    }

    public static void recalculateClasses(Mappings from, Mappings to) {
        to.classMappings.clear();
        for (Map.Entry<String, String> entry : from.classMappings.entrySet()) {
            to.classMappings.put(from.map(entry.getKey()), entry.getKey());
        }
        Reverser.recalculateFields(from, to);
        Reverser.recalculateMethods(from, to);
    }

    public static void recalculateFields(Mappings from, Mappings to) {
        to.fieldMappings.clear();
        for (Map.Entry<String, String> entry : from.fieldMappings.entrySet()) {
            MemberDeclaration member = MemberDeclaration.fromFieldMapping(entry.getKey());
            to.fieldMappings.put(from.map(member.getOwner()) + "." + entry.getValue() + (member.getDescriptor() == null ? "" : ":" + from.mapDesc(member.getDescriptor())), member.getName());
        }
    }

    public static void recalculateMethods(Mappings from, Mappings to) {
        to.methodMappings.clear();
        for (Map.Entry<String, String> entry : from.methodMappings.entrySet()) {
            MemberDeclaration member = MemberDeclaration.fromMethodMapping(entry.getKey());
            to.methodMappings.put(from.map(member.getOwner()) + "." + entry.getValue() + from.mapMethodDesc(member.getDescriptor()), member.getName());
        }
    }

    @Generated
    private Reverser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

