/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.asm.io.ClassIO;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.tree.ClassNode;

public final class Remapper {
    public static Map<String, byte[]> remapJarEntries(Map<String, byte[]> entries, org.objectweb.asm.commons.Remapper remapper) {
        HashMap<String, byte[]> out = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            if (entry.getKey().toLowerCase(Locale.ROOT).endsWith(".class")) {
                ClassNode classNode = ClassIO.fromBytes(entry.getValue());
                classNode = Remapper.remap(classNode, remapper);
                out.put(classNode.name + ".class", ClassIO.toStacklessBytes(classNode));
                continue;
            }
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public static ClassNode remap(ClassNode classNode, org.objectweb.asm.commons.Remapper remapper) {
        ClassNode remappedNode = new ClassNode();
        ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)remappedNode, remapper);
        classNode.accept((ClassVisitor)classRemapper);
        return remappedNode;
    }

    @Generated
    private Remapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

