/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.lenni0451.commons.asm.Modifiers;
import net.lenni0451.commons.asm.Types;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import net.lenni0451.commons.asm.info.FieldInfo;
import net.lenni0451.commons.asm.info.MemberDeclaration;
import net.lenni0451.commons.asm.info.MethodInfo;
import net.lenni0451.commons.asm.mappings.Mappings;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class MappingsFiller {
    public static void fillAllSuperMembers(Mappings mappings, ClassInfoProvider classInfoProvider) {
        MappingsFiller.fillAllSuperMembers(mappings, classInfoProvider, MappingsFiller.getAllMentionedClasses(mappings));
    }

    public static void fillAllSuperMembers(Mappings mappings, ClassInfoProvider classInfoProvider, Set<String> classes) {
        for (String clazz : classes) {
            try {
                ClassInfo classInfo = classInfoProvider.of(clazz);
                Set<ClassInfo> resolvedSuperClasses = classInfo.getRecursiveSuperClasses();
                MappingsFiller.fillSuperMembers(classInfo, resolvedSuperClasses, mappings);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void fillSuperMembers(ClassInfo info, Set<ClassInfo> superClasses, Mappings mappings) {
        HashSet<String> mappedFields = new HashSet<String>();
        HashSet<String> mappedMethods = new HashSet<String>();
        for (ClassInfo superClass : superClasses) {
            String mappedName;
            for (FieldInfo field : superClass.getFields()) {
                if (Modifiers.has(field.getModifiers(), 2)) continue;
                mappedName = mappings.mapFieldName(superClass.getName(), field.getName(), field.getDescriptor());
                if (field.getName().equals(mappedName) || !mappedFields.add(mappedName + field.getDescriptor())) continue;
                mappings.addFieldMapping(info.getName(), field.getName(), field.getDescriptor(), mappedName, true);
            }
            for (MethodInfo method : superClass.getMethods()) {
                if (Modifiers.has(method.getModifiers(), 2) || method.getName().startsWith("<")) continue;
                mappedName = mappings.mapMethodName(superClass.getName(), method.getName(), method.getDescriptor());
                if (method.getName().equals(mappedName) || !mappedMethods.add(mappedName + method.getDescriptor())) continue;
                mappings.addMethodMapping(info.getName(), method.getName(), method.getDescriptor(), mappedName, true);
            }
        }
    }

    public static void fillSuperMembers(ClassNode node, Set<ClassNode> superClasses, Mappings mappings) {
        HashSet<String> mappedFields = new HashSet<String>();
        HashSet<String> mappedMethods = new HashSet<String>();
        for (ClassNode superClass : superClasses) {
            String mappedName;
            for (FieldNode field : superClass.fields) {
                if (Modifiers.has(field.access, 2) || field.name.equals(mappedName = mappings.mapFieldName(superClass.name, field.name, field.desc)) || !mappedFields.add(mappedName + field.desc)) continue;
                mappings.addFieldMapping(node.name, field.name, field.desc, mappedName, true);
            }
            for (MethodNode method : superClass.methods) {
                if (Modifiers.has(method.access, 2) || method.name.startsWith("<") || method.name.equals(mappedName = mappings.mapMethodName(superClass.name, method.name, method.desc)) || !mappedMethods.add(mappedName + method.desc)) continue;
                mappings.addMethodMapping(node.name, method.name, method.desc, mappedName, true);
            }
        }
    }

    private static Set<String> getAllMentionedClasses(Mappings mappings) {
        MemberDeclaration member;
        HashSet<Type> types = new HashSet<Type>();
        HashSet<String> classes = new HashSet<String>(mappings.classMappings.keySet());
        for (Map.Entry<String, String> entry : mappings.fieldMappings.entrySet()) {
            member = MemberDeclaration.fromFieldMapping(entry.getKey());
            classes.add(member.getOwner());
            if (member.getDescriptor() == null) continue;
            types.add(Types.type(member.getDescriptor()));
        }
        for (Map.Entry<String, String> entry : mappings.methodMappings.entrySet()) {
            member = MemberDeclaration.fromMethodMapping(entry.getKey());
            classes.add(member.getOwner());
            Collections.addAll(types, Types.argumentTypes(member.getDescriptor()));
            types.add(Types.returnType(member.getDescriptor()));
        }
        for (Type type : types) {
            if (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) continue;
            classes.add(type.getInternalName());
        }
        return classes;
    }

    @Generated
    private MappingsFiller() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

