/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.asm.mappings.Reverser;
import org.objectweb.asm.commons.Remapper;

public class Mappings
extends Remapper {
    protected final Supplier<Map<String, String>> mapInitializer;
    protected final Map<String, String> packageMappings;
    protected final Map<String, String> classMappings;
    protected final Map<String, String> fieldMappings;
    protected final Map<String, String> methodMappings;
    ReverseCacheMode reverseCacheMode;
    Mappings reverse;

    public Mappings() {
        this(HashMap::new);
    }

    public Mappings(Supplier<Map<String, String>> mapInitializer) {
        this.mapInitializer = mapInitializer;
        this.packageMappings = mapInitializer.get();
        this.classMappings = mapInitializer.get();
        this.fieldMappings = mapInitializer.get();
        this.methodMappings = mapInitializer.get();
    }

    public Mappings(Mappings mappings, Function<Map<String, String>, Map<String, String>> mapCopier) {
        this.mapInitializer = mappings.mapInitializer;
        this.packageMappings = mapCopier.apply(mappings.packageMappings);
        this.classMappings = mapCopier.apply(mappings.classMappings);
        this.fieldMappings = mapCopier.apply(mappings.fieldMappings);
        this.methodMappings = mapCopier.apply(mappings.methodMappings);
    }

    public Map<String, String> getPackageMappings() {
        return Collections.unmodifiableMap(this.packageMappings);
    }

    public Mappings addPackageMapping(String from, String to) {
        return this.addPackageMapping(from, to, false);
    }

    public Mappings addPackageMapping(String from, String to, boolean skipExisting) {
        if (from.length() > 1 && from.contains(".")) {
            throw new IllegalArgumentException("Package mappings must not contain '.'");
        }
        if (to.length() > 1 && to.contains(".")) {
            throw new IllegalArgumentException("Package mappings must not contain '.'");
        }
        if (!from.equals(".") && !from.endsWith("/")) {
            from = from + "/";
        }
        if (!to.equals(".") && !to.endsWith("/")) {
            to = to + "/";
        }
        if (skipExisting && this.packageMappings.containsKey(from)) {
            return this;
        }
        this.packageMappings.put(from, to);
        if (this.reverse != null) {
            if (this.reverseCacheMode.equals((Object)ReverseCacheMode.UPDATE)) {
                this.reverse.packageMappings.put(to, from);
                Reverser.recalculateClasses(this, this.reverse);
            } else if (this.reverseCacheMode.equals((Object)ReverseCacheMode.RECREATE)) {
                this.reverse.reverseCacheMode = null;
                this.reverse.reverse = null;
                this.reverseCacheMode = null;
                this.reverse = null;
            }
        }
        return this;
    }

    public String mapPackageName(String name) {
        if (name.isEmpty()) {
            return this.packageMappings.getOrDefault(".", "");
        }
        String[] parts = name.split(Pattern.quote("."));
        for (int i = parts.length - 1; i >= 0; --i) {
            String current = String.join((CharSequence)"/", Arrays.copyOfRange(parts, 0, i + 1)) + "/";
            if (!this.packageMappings.containsKey(current)) continue;
            String mapped = this.packageMappings.get(current).replace('/', '.');
            if (!(mapped = mapped.substring(0, mapped.length() - 1)).isEmpty() && i != parts.length - 1) {
                mapped = mapped + ".";
            }
            mapped = mapped + String.join((CharSequence)".", Arrays.copyOfRange(parts, i + 1, parts.length));
            if (name.endsWith(".")) {
                mapped = mapped + ".";
            }
            return mapped;
        }
        return name;
    }

    public String mapClassPackage(String internalName) {
        String packageName = internalName.substring(0, internalName.lastIndexOf(47) + 1).replace('/', '.');
        String className = internalName.substring(internalName.lastIndexOf(47) + 1);
        return this.mapPackageName(packageName).replace('.', '/') + className;
    }

    public Map<String, String> getClassMappings() {
        return Collections.unmodifiableMap(this.classMappings);
    }

    public Mappings addClassMapping(String from, String to) {
        return this.addClassMapping(from, to, false);
    }

    public Mappings addClassMapping(String from, String to, boolean skipExisting) {
        if (from.contains(".")) {
            throw new IllegalArgumentException("Class mappings must not contain '.'");
        }
        if (to.contains(".")) {
            throw new IllegalArgumentException("Class mappings must not contain '.'");
        }
        if (skipExisting && this.classMappings.containsKey(from)) {
            return this;
        }
        this.classMappings.put(from, to);
        if (this.reverse != null) {
            if (this.reverseCacheMode.equals((Object)ReverseCacheMode.UPDATE)) {
                this.reverse.classMappings.put(this.map(from), from);
                Reverser.recalculateFields(this, this.reverse);
                Reverser.recalculateMethods(this, this.reverse);
            } else if (this.reverseCacheMode.equals((Object)ReverseCacheMode.RECREATE)) {
                this.reverse.reverseCacheMode = null;
                this.reverse.reverse = null;
                this.reverseCacheMode = null;
                this.reverse = null;
            }
        }
        return this;
    }

    @Nonnull
    public String map(String internalName) {
        String mapped = this.classMappings.getOrDefault(internalName, internalName);
        if (this.packageMappings.isEmpty()) {
            return mapped;
        }
        return this.mapClassPackage(mapped);
    }

    public Map<String, String> getFieldMappings() {
        return Collections.unmodifiableMap(this.fieldMappings);
    }

    public Mappings addFieldMapping(String owner, String name, @Nullable String descriptor, String newName) {
        return this.addFieldMapping(owner, name, descriptor, newName, false);
    }

    public Mappings addFieldMapping(String owner, String name, @Nullable String descriptor, String newName, boolean skipExisting) {
        if (owner.contains(".")) {
            throw new IllegalArgumentException("Field mappings must not contain '.'");
        }
        String key = owner + "." + name + (descriptor != null ? ":" + descriptor : "");
        if (skipExisting && this.fieldMappings.containsKey(key)) {
            return this;
        }
        this.fieldMappings.put(key, newName);
        if (this.reverse != null) {
            if (this.reverseCacheMode.equals((Object)ReverseCacheMode.UPDATE)) {
                this.reverse.addFieldMapping(this.map(owner), newName, this.mapDesc(descriptor), name);
            } else if (((Object)((Object)this.reverse)).equals((Object)ReverseCacheMode.RECREATE)) {
                this.reverse.reverseCacheMode = null;
                this.reverse.reverse = null;
                this.reverseCacheMode = null;
                this.reverse = null;
            }
        }
        return this;
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        String mappedName = this.fieldMappings.get(owner + "." + name + ":" + descriptor);
        if (mappedName != null) {
            return mappedName;
        }
        return this.fieldMappings.getOrDefault(owner + "." + name, name);
    }

    public Map<String, String> getMethodMappings() {
        return Collections.unmodifiableMap(this.methodMappings);
    }

    public Mappings addMethodMapping(String owner, String name, String descriptor, String newName) {
        return this.addMethodMapping(owner, name, descriptor, newName, false);
    }

    public Mappings addMethodMapping(String owner, String name, String descriptor, String newName, boolean skipExisting) {
        if (owner.contains(".")) {
            throw new IllegalArgumentException("Method mappings must not contain '.'");
        }
        String key = owner + "." + name + descriptor;
        if (skipExisting && this.methodMappings.containsKey(key)) {
            return this;
        }
        this.methodMappings.put(key, newName);
        if (this.reverse != null) {
            if (this.reverseCacheMode.equals((Object)ReverseCacheMode.UPDATE)) {
                this.reverse.addMethodMapping(this.map(owner), newName, this.mapMethodDesc(descriptor), name);
            } else if (this.reverseCacheMode.equals((Object)ReverseCacheMode.RECREATE)) {
                this.reverse.reverseCacheMode = null;
                this.reverse.reverse = null;
                this.reverseCacheMode = null;
                this.reverse = null;
            }
        }
        return this;
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        return this.methodMappings.getOrDefault(owner + "." + name + descriptor, name);
    }

    public int size() {
        return this.packageMappings.size() + this.classMappings.size() + this.fieldMappings.size() + this.methodMappings.size();
    }

    public boolean isEmpty() {
        return this.packageMappings.isEmpty() && this.classMappings.isEmpty() && this.fieldMappings.isEmpty() && this.methodMappings.isEmpty();
    }

    public Mappings emptyCopy() {
        return this.emptyCopy(this.mapInitializer);
    }

    public Mappings emptyCopy(Supplier<Map<String, String>> mapInitializer) {
        return new Mappings(mapInitializer);
    }

    public Mappings copy() {
        return this.copy(this.mapInitializer);
    }

    public Mappings copy(Supplier<Map<String, String>> mapInitializer) {
        Mappings copy = this.emptyCopy(mapInitializer);
        copy.packageMappings.putAll(this.packageMappings);
        copy.classMappings.putAll(this.classMappings);
        copy.fieldMappings.putAll(this.fieldMappings);
        copy.methodMappings.putAll(this.methodMappings);
        return copy;
    }

    public Mappings isolate() {
        if (this.reverse != null) {
            this.reverse.reverse = null;
            this.reverse = null;
        }
        return this;
    }

    public Mappings reverse() {
        return this.reverse(ReverseCacheMode.UPDATE);
    }

    public Mappings reverse(ReverseCacheMode mode) {
        if (this.reverse != null && this.reverseCacheMode.equals((Object)mode)) {
            return this.reverse;
        }
        Mappings reverse = Reverser.init(this);
        if (mode.equals((Object)ReverseCacheMode.STANDALONE)) {
            return reverse;
        }
        this.reverseCacheMode = mode;
        this.reverse = reverse;
        reverse.reverseCacheMode = mode;
        reverse.reverse = this;
        if (mode.equals((Object)ReverseCacheMode.IMMUTABLE)) {
            this.reverse = new Mappings(this.reverse, Collections::unmodifiableMap);
        }
        return this.reverse;
    }

    public String toString() {
        return "Mappings{packageMappings=" + this.packageMappings + ", classMappings=" + this.classMappings + ", fieldMappings=" + this.fieldMappings + ", methodMappings=" + this.methodMappings + ", reverseCacheMode=" + (Object)((Object)this.reverseCacheMode) + '}';
    }

    public static enum ReverseCacheMode {
        UPDATE,
        RECREATE,
        IMMUTABLE,
        STANDALONE;

    }
}

