/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.io;

import java.util.Set;
import net.lenni0451.commons.asm.Modifiers;
import net.lenni0451.commons.asm.Types;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import org.objectweb.asm.ClassWriter;

public class InfoClassWriter
extends ClassWriter {
    private static final String OBJECT = Types.internalName(Object.class);
    private final ClassInfoProvider classInfoProvider;

    public InfoClassWriter(int flags, ClassInfoProvider classInfoProvider) {
        super(flags);
        this.classInfoProvider = classInfoProvider;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(OBJECT) || type2.equals(OBJECT)) {
            return OBJECT;
        }
        try {
            ClassInfo class1 = this.classInfoProvider.of(type1);
            Set<ClassInfo> superClasses1 = class1.getRecursiveSuperClasses();
            ClassInfo class2 = this.classInfoProvider.of(type2);
            Set<ClassInfo> superClasses2 = class2.getRecursiveSuperClasses();
            if (superClasses1.contains(class2)) {
                return type2;
            }
            if (superClasses2.contains(class1)) {
                return type1;
            }
            if (Modifiers.has(class1.getModifiers(), 512) || Modifiers.has(class2.getModifiers(), 512)) {
                return OBJECT;
            }
            do {
                if ((class1 = class1.getSuperClassInfo()) != null) continue;
                return OBJECT;
            } while (!superClasses2.contains(class1));
            return class1.getName();
        }
        catch (Throwable t) {
            throw new TypeNotPresentException(t.getMessage(), t);
        }
    }
}

