/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info.impl.jvm;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import net.lenni0451.commons.asm.info.impl.jvm.JVMClassInfo;

public class JVMClassInfoProvider
implements ClassInfoProvider {
    private final ClassLoader classLoader;
    private final Map<String, JVMClassInfo> classInfoCache;

    public JVMClassInfoProvider() {
        this(JVMClassInfoProvider.class.getClassLoader());
    }

    public JVMClassInfoProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classInfoCache = new HashMap<String, JVMClassInfo>();
    }

    @Override
    @Nonnull
    public synchronized JVMClassInfo of(String className) {
        className = ASMUtils.dot(className);
        if (this.classInfoCache.containsKey(className)) {
            return this.classInfoCache.get(className);
        }
        return this.of((Class)this.classLoader.loadClass(className));
    }

    @Override
    @Nonnull
    public synchronized JVMClassInfo of(Class<?> clazz) {
        if (this.classInfoCache.containsKey(clazz.getName())) {
            return this.classInfoCache.get(clazz.getName());
        }
        JVMClassInfo classInfo = new JVMClassInfo(this, clazz);
        this.classInfoCache.put(clazz.getName(), classInfo);
        return classInfo;
    }
}

