/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info.impl.jvm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import net.lenni0451.commons.asm.info.FieldInfo;
import net.lenni0451.commons.asm.info.MethodInfo;
import net.lenni0451.commons.asm.info.impl.ClassInfoResolver;
import net.lenni0451.commons.asm.info.impl.jvm.JVMFieldInfo;
import net.lenni0451.commons.asm.info.impl.jvm.JVMMethodInfo;

public class JVMClassInfo
implements ClassInfo {
    private final ClassInfoProvider classInfoProvider;
    private final Class<?> clazz;
    private final AtomicReference<Object> superClassInfo = new AtomicReference();
    private final AtomicReference<Object> interfaceInfos = new AtomicReference();
    private final AtomicReference<Object> recursiveSuperClasses = new AtomicReference();
    private final AtomicReference<Object> fields = new AtomicReference();
    private final AtomicReference<Object> methods = new AtomicReference();

    @Override
    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    @Override
    public String getName() {
        return ASMUtils.slash(this.clazz.getName());
    }

    @Override
    public String getSuperClass() {
        if (this.clazz.getSuperclass() == null) {
            return null;
        }
        return ASMUtils.slash(this.clazz.getSuperclass().getName());
    }

    @Override
    public String[] getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = ASMUtils.slash(interfaces[i].getName());
        }
        return interfaceNames;
    }

    private FieldInfo[] resolveFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        FieldInfo[] fieldInfos = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldInfos[i] = new JVMFieldInfo(fields[i]);
        }
        return fieldInfos;
    }

    private MethodInfo[] resolveMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        MethodInfo[] methodInfos = new MethodInfo[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodInfos[i] = new JVMMethodInfo(methods[i]);
        }
        return methodInfos;
    }

    @Generated
    public JVMClassInfo(ClassInfoProvider classInfoProvider, Class<?> clazz) {
        this.classInfoProvider = classInfoProvider;
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public ClassInfo getSuperClassInfo() {
        Object $value = this.superClassInfo.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.superClassInfo;
            synchronized (atomicReference) {
                $value = this.superClassInfo.get();
                if ($value == null) {
                    ClassInfo actualValue = ClassInfoResolver.resolveSuperClass(this.classInfoProvider, this);
                    $value = actualValue == null ? this.superClassInfo : actualValue;
                    this.superClassInfo.set($value);
                }
            }
        }
        return (ClassInfo)($value == this.superClassInfo ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public ClassInfo[] getInterfaceInfos() {
        Object $value = this.interfaceInfos.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.interfaceInfos;
            synchronized (atomicReference) {
                $value = this.interfaceInfos.get();
                if ($value == null) {
                    ClassInfo[] actualValue = ClassInfoResolver.resolveInterfaces(this.classInfoProvider, this);
                    $value = actualValue == null ? this.interfaceInfos : actualValue;
                    this.interfaceInfos.set($value);
                }
            }
        }
        return (ClassInfo[])($value == this.interfaceInfos ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public Set<ClassInfo> getRecursiveSuperClasses() {
        Object $value = this.recursiveSuperClasses.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.recursiveSuperClasses;
            synchronized (atomicReference) {
                $value = this.recursiveSuperClasses.get();
                if ($value == null) {
                    Set<ClassInfo> actualValue = ClassInfoResolver.recursiveResolveSuperClasses(this, false);
                    $value = actualValue == null ? this.recursiveSuperClasses : actualValue;
                    this.recursiveSuperClasses.set($value);
                }
            }
        }
        return (Set)($value == this.recursiveSuperClasses ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public FieldInfo[] getFields() {
        Object $value = this.fields.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.fields;
            synchronized (atomicReference) {
                $value = this.fields.get();
                if ($value == null) {
                    FieldInfo[] actualValue = this.resolveFields();
                    $value = actualValue == null ? this.fields : actualValue;
                    this.fields.set($value);
                }
            }
        }
        return (FieldInfo[])($value == this.fields ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public MethodInfo[] getMethods() {
        Object $value = this.methods.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.methods;
            synchronized (atomicReference) {
                $value = this.methods.get();
                if ($value == null) {
                    MethodInfo[] actualValue = this.resolveMethods();
                    $value = actualValue == null ? this.methods : actualValue;
                    this.methods.set($value);
                }
            }
        }
        return (MethodInfo[])($value == this.methods ? null : $value);
    }
}

