/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info.impl.asm;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import net.lenni0451.commons.asm.info.impl.asm.ASMClassInfo;
import net.lenni0451.commons.asm.provider.ClassProvider;
import org.objectweb.asm.tree.ClassNode;

public class ASMClassInfoProvider
implements ClassInfoProvider {
    private final ClassProvider classProvider;
    private final Map<String, ASMClassInfo> classInfoCache;

    public ASMClassInfoProvider(ClassProvider classProvider) {
        this.classProvider = classProvider;
        this.classInfoCache = new HashMap<String, ASMClassInfo>();
    }

    public ClassProvider getClassProvider() {
        return this.classProvider;
    }

    @Override
    @Nonnull
    public synchronized ASMClassInfo of(String className) {
        if (this.classInfoCache.containsKey(className)) {
            return this.classInfoCache.get(className);
        }
        return this.of(this.classProvider.getClassNode(className));
    }

    @Override
    @Nonnull
    public synchronized ASMClassInfo of(ClassNode classNode) {
        if (this.classInfoCache.containsKey(classNode.name)) {
            return this.classInfoCache.get(classNode.name);
        }
        ASMClassInfo classInfo = new ASMClassInfo(this, classNode);
        this.classInfoCache.put(classNode.name, classInfo);
        return classInfo;
    }
}

