/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info.impl.asm;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.ClassInfoProvider;
import net.lenni0451.commons.asm.info.FieldInfo;
import net.lenni0451.commons.asm.info.MethodInfo;
import net.lenni0451.commons.asm.info.impl.ClassInfoResolver;
import net.lenni0451.commons.asm.info.impl.asm.ASMFieldInfo;
import net.lenni0451.commons.asm.info.impl.asm.ASMMethodInfo;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMClassInfo
implements ClassInfo {
    private final ClassInfoProvider classInfoProvider;
    private final ClassNode classNode;
    private final AtomicReference<Object> superClassInfo = new AtomicReference();
    private final AtomicReference<Object> interfaceInfos = new AtomicReference();
    private final AtomicReference<Object> recursiveSuperClasses = new AtomicReference();
    private final AtomicReference<Object> fields = new AtomicReference();
    private final AtomicReference<Object> methods = new AtomicReference();

    public ClassInfoProvider getClassInfoProvider() {
        return this.classInfoProvider;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    @Override
    public int getModifiers() {
        return this.classNode.access;
    }

    @Override
    public String getName() {
        return this.classNode.name;
    }

    @Override
    public String getSuperClass() {
        return this.classNode.superName;
    }

    @Override
    public String[] getInterfaces() {
        return this.classNode.interfaces == null ? new String[]{} : this.classNode.interfaces.toArray(new String[0]);
    }

    private FieldInfo[] resolveFields() {
        List fields = this.classNode.fields;
        FieldInfo[] fieldInfos = new FieldInfo[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            fieldInfos[i] = new ASMFieldInfo((FieldNode)fields.get(i));
        }
        return fieldInfos;
    }

    private MethodInfo[] resolveMethods() {
        List methods = this.classNode.methods;
        MethodInfo[] methodInfos = new MethodInfo[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            methodInfos[i] = new ASMMethodInfo((MethodNode)methods.get(i));
        }
        return methodInfos;
    }

    @Generated
    public ASMClassInfo(ClassInfoProvider classInfoProvider, ClassNode classNode) {
        this.classInfoProvider = classInfoProvider;
        this.classNode = classNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public ClassInfo getSuperClassInfo() {
        Object $value = this.superClassInfo.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.superClassInfo;
            synchronized (atomicReference) {
                $value = this.superClassInfo.get();
                if ($value == null) {
                    ClassInfo actualValue = ClassInfoResolver.resolveSuperClass(this.classInfoProvider, this);
                    $value = actualValue == null ? this.superClassInfo : actualValue;
                    this.superClassInfo.set($value);
                }
            }
        }
        return (ClassInfo)($value == this.superClassInfo ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public ClassInfo[] getInterfaceInfos() {
        Object $value = this.interfaceInfos.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.interfaceInfos;
            synchronized (atomicReference) {
                $value = this.interfaceInfos.get();
                if ($value == null) {
                    ClassInfo[] actualValue = ClassInfoResolver.resolveInterfaces(this.classInfoProvider, this);
                    $value = actualValue == null ? this.interfaceInfos : actualValue;
                    this.interfaceInfos.set($value);
                }
            }
        }
        return (ClassInfo[])($value == this.interfaceInfos ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public Set<ClassInfo> getRecursiveSuperClasses() {
        Object $value = this.recursiveSuperClasses.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.recursiveSuperClasses;
            synchronized (atomicReference) {
                $value = this.recursiveSuperClasses.get();
                if ($value == null) {
                    Set<ClassInfo> actualValue = ClassInfoResolver.recursiveResolveSuperClasses(this, false);
                    $value = actualValue == null ? this.recursiveSuperClasses : actualValue;
                    this.recursiveSuperClasses.set($value);
                }
            }
        }
        return (Set)($value == this.recursiveSuperClasses ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public FieldInfo[] getFields() {
        Object $value = this.fields.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.fields;
            synchronized (atomicReference) {
                $value = this.fields.get();
                if ($value == null) {
                    FieldInfo[] actualValue = this.resolveFields();
                    $value = actualValue == null ? this.fields : actualValue;
                    this.fields.set($value);
                }
            }
        }
        return (FieldInfo[])($value == this.fields ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public MethodInfo[] getMethods() {
        Object $value = this.methods.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.methods;
            synchronized (atomicReference) {
                $value = this.methods.get();
                if ($value == null) {
                    MethodInfo[] actualValue = this.resolveMethods();
                    $value = actualValue == null ? this.methods : actualValue;
                    this.methods.set($value);
                }
            }
        }
        return (MethodInfo[])($value == this.methods ? null : $value);
    }
}

