/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.ClassInfoProvider;

public class ClassInfoResolver {
    public static ClassInfo resolveSuperClass(ClassInfoProvider classInfoProvider, ClassInfo classInfo) {
        String superClass = classInfo.getSuperClass();
        if (superClass == null) {
            return null;
        }
        return classInfoProvider.of(superClass);
    }

    public static ClassInfo[] resolveInterfaces(ClassInfoProvider classInfoProvider, ClassInfo classInfo) {
        String[] interfaces = classInfo.getInterfaces();
        ClassInfo[] infos = new ClassInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            infos[i] = classInfoProvider.of(interfaces[i]);
        }
        return infos;
    }

    public static Set<ClassInfo> recursiveResolveSuperClasses(ClassInfo classInfo, boolean includeSelf) {
        LinkedHashSet<ClassInfo> superClasses = new LinkedHashSet<ClassInfo>();
        LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>();
        queue.add(classInfo);
        while (!queue.isEmpty()) {
            ClassInfo current = (ClassInfo)queue.poll();
            if (!superClasses.add(current)) continue;
            ClassInfo superClass = current.getSuperClassInfo();
            if (superClass != null) {
                queue.add(superClass);
            }
            Collections.addAll(queue, current.getInterfaceInfos());
        }
        if (!includeSelf) {
            superClasses.remove(classInfo);
        }
        return superClasses;
    }
}

