/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info;

import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class MemberDeclaration {
    private final String owner;
    private final String name;
    private final String descriptor;

    public static MemberDeclaration fromFieldMapping(String mapping) {
        String owner = mapping.substring(0, mapping.indexOf(46));
        String name = mapping.substring(mapping.indexOf(46) + 1);
        String descriptor = null;
        if (name.contains(":")) {
            descriptor = name.substring(name.indexOf(58) + 1);
            name = name.substring(0, name.indexOf(58));
        }
        return new MemberDeclaration(owner, name, descriptor);
    }

    public static MemberDeclaration fromMethodMapping(String mapping) {
        String owner = mapping.substring(0, mapping.indexOf(46));
        String name = mapping.substring(mapping.indexOf(46) + 1, mapping.indexOf(40));
        String descriptor = mapping.substring(mapping.indexOf(40));
        return new MemberDeclaration(owner, name, descriptor);
    }

    public MemberDeclaration(String owner, String name, String descriptor) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isField() {
        return this.descriptor == null || !this.descriptor.startsWith("(");
    }

    public boolean isMethod() {
        return this.descriptor != null && this.descriptor.startsWith("(");
    }

    public boolean is(String owner, String name, String descriptor) {
        return this.owner.equals(owner) && this.name.equals(name) && (this.descriptor == null || this.descriptor.equals(descriptor));
    }

    public boolean is(FieldInsnNode fieldInsnNode) {
        if (!this.isField()) {
            return false;
        }
        return this.owner.equals(fieldInsnNode.owner) && this.name.equals(fieldInsnNode.name) && (this.descriptor == null || this.descriptor.equals(fieldInsnNode.desc));
    }

    public boolean is(MethodInsnNode methodInsnNode) {
        if (!this.isMethod()) {
            return false;
        }
        return this.owner.equals(methodInsnNode.owner) && this.name.equals(methodInsnNode.name) && this.descriptor.equals(methodInsnNode.desc);
    }
}

