/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.info;

import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.info.ClassInfo;
import net.lenni0451.commons.asm.info.impl.asm.ASMClassInfoProvider;
import net.lenni0451.commons.asm.info.impl.jvm.JVMClassInfoProvider;
import net.lenni0451.commons.asm.provider.ClassProvider;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public interface ClassInfoProvider {
    public static JVMClassInfoProvider create(ClassLoader classLoader) {
        return new JVMClassInfoProvider(classLoader);
    }

    public static ASMClassInfoProvider create(ClassProvider classProvider) {
        return new ASMClassInfoProvider(classProvider);
    }

    @Nonnull
    public ClassInfo of(String var1);

    @Nonnull
    default public ClassInfo of(Type type) {
        if (type.getSort() != 10) {
            throw new IllegalArgumentException("Type must be an object type");
        }
        return this.of(type.getInternalName());
    }

    @Nonnull
    default public ClassInfo of(Class<?> clazz) {
        return this.of(ASMUtils.slash(clazz.getName()));
    }

    @Nonnull
    default public ClassInfo of(ClassNode classNode) {
        return this.of(classNode.name);
    }
}

