/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.compare;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionComparator {
    private final List<Integer> ignoredInstructionTypes;

    public InstructionComparator() {
        this(14, 15);
    }

    public InstructionComparator(int ... ignoredInstructionTypes) {
        this.ignoredInstructionTypes = Arrays.stream(ignoredInstructionTypes).boxed().collect(Collectors.toList());
    }

    public boolean equals(InsnList insnList1, InsnList insnList2) {
        return this.equals(insnList1.toArray(), insnList2.toArray());
    }

    public boolean equals(List<? extends AbstractInsnNode> insnList1, List<? extends AbstractInsnNode> insnList2) {
        return this.equals(insnList1.toArray(new AbstractInsnNode[0]), insnList2.toArray(new AbstractInsnNode[0]));
    }

    public boolean equals(AbstractInsnNode[] insns1, AbstractInsnNode[] insns2) {
        if (insns1 == insns2) {
            return true;
        }
        if (insns1 == null || insns2 == null) {
            return false;
        }
        if ((insns1 = this.filterIgnoredInstructions(insns1)).length != (insns2 = this.filterIgnoredInstructions(insns2)).length) {
            return false;
        }
        for (int i = 0; i < insns1.length; ++i) {
            if (this.equals(insns1[i], insns2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(AbstractInsnNode insn1, AbstractInsnNode insn2) {
        if (insn1 == insn2) {
            return true;
        }
        if (insn1 == null || insn2 == null) {
            return false;
        }
        if (insn1.getOpcode() != insn2.getOpcode()) {
            return false;
        }
        if (insn1.getType() != insn2.getType()) {
            return false;
        }
        switch (insn1.getType()) {
            case 0: {
                return true;
            }
            case 1: {
                IntInsnNode intInsn1 = (IntInsnNode)insn1;
                IntInsnNode intInsn2 = (IntInsnNode)insn2;
                return intInsn1.operand == intInsn2.operand;
            }
            case 2: {
                VarInsnNode varInsn1 = (VarInsnNode)insn1;
                VarInsnNode varInsn2 = (VarInsnNode)insn2;
                return varInsn1.var == varInsn2.var;
            }
            case 3: {
                TypeInsnNode typeInsn1 = (TypeInsnNode)insn1;
                TypeInsnNode typeInsn2 = (TypeInsnNode)insn2;
                return Objects.equals(typeInsn1.desc, typeInsn2.desc);
            }
            case 4: {
                FieldInsnNode fieldInsn1 = (FieldInsnNode)insn1;
                FieldInsnNode fieldInsn2 = (FieldInsnNode)insn2;
                return Objects.equals(fieldInsn1.owner, fieldInsn2.owner) && Objects.equals(fieldInsn1.name, fieldInsn2.name) && Objects.equals(fieldInsn1.desc, fieldInsn2.desc);
            }
            case 5: {
                MethodInsnNode methodInsn1 = (MethodInsnNode)insn1;
                MethodInsnNode methodInsn2 = (MethodInsnNode)insn2;
                return Objects.equals(methodInsn1.owner, methodInsn2.owner) && Objects.equals(methodInsn1.name, methodInsn2.name) && Objects.equals(methodInsn1.desc, methodInsn2.desc) && methodInsn1.itf == methodInsn2.itf;
            }
            case 6: {
                InvokeDynamicInsnNode invokeDynamicInsn1 = (InvokeDynamicInsnNode)insn1;
                InvokeDynamicInsnNode invokeDynamicInsn2 = (InvokeDynamicInsnNode)insn2;
                return Objects.equals(invokeDynamicInsn1.name, invokeDynamicInsn2.name) && Objects.equals(invokeDynamicInsn1.desc, invokeDynamicInsn2.desc) && Objects.equals(invokeDynamicInsn1.bsm, invokeDynamicInsn2.bsm) && this.listEquals(Arrays.asList(invokeDynamicInsn1.bsmArgs), Arrays.asList(invokeDynamicInsn2.bsmArgs));
            }
            case 7: {
                JumpInsnNode jumpInsn1 = (JumpInsnNode)insn1;
                JumpInsnNode jumpInsn2 = (JumpInsnNode)insn2;
                return this.equals((AbstractInsnNode)jumpInsn1.label, (AbstractInsnNode)jumpInsn2.label);
            }
            case 8: {
                return true;
            }
            case 9: {
                LdcInsnNode ldcInsn1 = (LdcInsnNode)insn1;
                LdcInsnNode ldcInsn2 = (LdcInsnNode)insn2;
                return Objects.equals(ldcInsn1.cst, ldcInsn2.cst);
            }
            case 10: {
                IincInsnNode iincInsn1 = (IincInsnNode)insn1;
                IincInsnNode iincInsn2 = (IincInsnNode)insn2;
                return iincInsn1.var == iincInsn2.var && iincInsn1.incr == iincInsn2.incr;
            }
            case 11: {
                TableSwitchInsnNode tableSwitchInsn1 = (TableSwitchInsnNode)insn1;
                TableSwitchInsnNode tableSwitchInsn2 = (TableSwitchInsnNode)insn2;
                return tableSwitchInsn1.min == tableSwitchInsn2.min && tableSwitchInsn1.max == tableSwitchInsn2.max && this.equals((AbstractInsnNode)tableSwitchInsn1.dflt, (AbstractInsnNode)tableSwitchInsn2.dflt) && this.equals(tableSwitchInsn1.labels, tableSwitchInsn2.labels);
            }
            case 12: {
                LookupSwitchInsnNode lookupSwitchInsn1 = (LookupSwitchInsnNode)insn1;
                LookupSwitchInsnNode lookupSwitchInsn2 = (LookupSwitchInsnNode)insn2;
                return this.equals((AbstractInsnNode)lookupSwitchInsn1.dflt, (AbstractInsnNode)lookupSwitchInsn2.dflt) && Objects.equals(lookupSwitchInsn1.keys, lookupSwitchInsn2.keys) && this.equals(lookupSwitchInsn1.labels, lookupSwitchInsn2.labels);
            }
            case 13: {
                MultiANewArrayInsnNode multiANewArrayInsn1 = (MultiANewArrayInsnNode)insn1;
                MultiANewArrayInsnNode multiANewArrayInsn2 = (MultiANewArrayInsnNode)insn2;
                return Objects.equals(multiANewArrayInsn1.desc, multiANewArrayInsn2.desc) && multiANewArrayInsn1.dims == multiANewArrayInsn2.dims;
            }
            case 14: {
                FrameNode frameNode1 = (FrameNode)insn1;
                FrameNode frameNode2 = (FrameNode)insn2;
                return frameNode1.type == frameNode2.type && this.listEquals(frameNode1.local, frameNode2.local) && this.listEquals(frameNode1.stack, frameNode2.stack);
            }
            case 15: {
                LineNumberNode lineNumberNode1 = (LineNumberNode)insn1;
                LineNumberNode lineNumberNode2 = (LineNumberNode)insn2;
                return lineNumberNode1.line == lineNumberNode2.line && this.equals((AbstractInsnNode)lineNumberNode1.start, (AbstractInsnNode)lineNumberNode2.start);
            }
        }
        throw new UnsupportedOperationException("Unknown AbstractInsnNode type: " + insn1.getType());
    }

    private boolean listEquals(List<Object> list1, List<Object> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Object obj2;
            Object obj1 = list1.get(i);
            if (obj1 == (obj2 = list2.get(i))) continue;
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (!(obj1 instanceof AbstractInsnNode && obj2 instanceof AbstractInsnNode ? !this.equals((AbstractInsnNode)obj1, (AbstractInsnNode)obj2) : !Objects.equals(obj1, obj2))) continue;
            return false;
        }
        return true;
    }

    private AbstractInsnNode[] filterIgnoredInstructions(AbstractInsnNode[] insns) {
        return (AbstractInsnNode[])Arrays.stream(insns).filter(insn -> !this.ignoredInstructionTypes.contains(insn.getType())).toArray(AbstractInsnNode[]::new);
    }
}

