/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.annotations.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.asm.Types;
import net.lenni0451.commons.asm.annotations.AnnotationUtils;
import net.lenni0451.commons.asm.annotations.parser.ParsedAnnotation;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public final class AnnotationParser {
    public static <T extends Annotation> T parse(AnnotationNode annotationNode) throws ClassNotFoundException {
        return AnnotationParser.parse(AnnotationParser.class.getClassLoader(), annotationNode);
    }

    public static <T extends Annotation> T parse(ClassLoader loader, AnnotationNode annotationNode) throws ClassNotFoundException {
        Type type = Types.type(annotationNode.desc);
        Class<?> clazz = loader.loadClass(type.getClassName());
        return (T)AnnotationParser.parse(loader, clazz, annotationNode);
    }

    public static <T extends Annotation> T parse(Class<T> type, AnnotationNode annotationNode) {
        return AnnotationParser.parse(type.getClassLoader(), type, annotationNode);
    }

    public static <T extends Annotation> T parse(ClassLoader loader, Class<T> type, AnnotationNode annotationNode) {
        Map<String, Object> values = AnnotationUtils.listToMap(annotationNode.values);
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            if (AnnotationParser.isMethod(method, Object.class, "toString", String.class, new Class[0])) {
                return type.getName() + "#Proxy@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            if (AnnotationParser.isMethod(method, Object.class, "hashCode", Integer.TYPE, new Class[0])) {
                return System.identityHashCode(proxy);
            }
            if (AnnotationParser.isMethod(method, Object.class, "equals", Boolean.TYPE, Object.class)) {
                return proxy == args[0];
            }
            if (AnnotationParser.isMethod(method, Annotation.class, "annotationType", Class.class, new Class[0])) {
                return type;
            }
            if (AnnotationParser.isMethod(method, ParsedAnnotation.class, "isSet", Boolean.TYPE, String.class)) {
                return values.containsKey((String)args[0]);
            }
            if (AnnotationParser.isMethod(method, ParsedAnnotation.class, "getValues", Map.class, new Class[0])) {
                return values;
            }
            if (AnnotationParser.isMethod(method, ParsedAnnotation.class, "getValue", Object.class, String.class)) {
                return values.get((String)args[0]);
            }
            if (values.containsKey(method.getName())) {
                return AnnotationParser.parseValue(loader, method.getReturnType(), values.get(method.getName()));
            }
            Object defaultValue = method.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new NoSuchMethodException(method.getName());
        };
        return (T)((Annotation)Proxy.newProxyInstance(loader, new Class[]{type, ParsedAnnotation.class}, invocationHandler));
    }

    private static Object parseValue(ClassLoader loader, Class<?> type, Object value) throws ClassNotFoundException {
        if (value instanceof Type) {
            return loader.loadClass(((Type)value).getClassName());
        }
        if (value instanceof String[]) {
            ?[] constants;
            String[] array = (String[])value;
            Type enumType = Types.type(array[0]);
            Class<?> enumClass = loader.loadClass(enumType.getClassName());
            for (Object constant : constants = enumClass.getEnumConstants()) {
                Enum enumConstant = (Enum)constant;
                if (!enumConstant.name().equals(array[1])) continue;
                return enumConstant;
            }
            throw new IllegalArgumentException("Unknown enum constant: " + array[1]);
        }
        if (value instanceof AnnotationNode) {
            return AnnotationParser.parse(loader, type, (AnnotationNode)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            Object array = Array.newInstance(type.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, AnnotationParser.parseValue(loader, type.getComponentType(), list.get(i)));
            }
            return array;
        }
        return value;
    }

    private static boolean isMethod(Method method, Class<?> owner, String name, Class<?> returnValue, Class<?> ... parameters) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (!method.getReturnType().equals(returnValue)) {
            return false;
        }
        if (method.getParameterCount() != parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (method.getParameterTypes()[i].equals(parameters[i])) continue;
            return false;
        }
        return true;
    }

    @Generated
    private AnnotationParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

