/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ModuleHashesAttribute;
import org.objectweb.asm.commons.ModuleResolutionAttribute;
import org.objectweb.asm.commons.ModuleTargetAttribute;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public final class Cloner {
    public static ClassNode clone(ClassNode classNode) {
        ClassNode clone = new ClassNode();
        classNode.accept((ClassVisitor)clone);
        return clone;
    }

    public static FieldNode clone(FieldNode fieldNode) {
        FieldNode clone = new FieldNode(fieldNode.access, fieldNode.name, fieldNode.desc, fieldNode.signature, fieldNode.value);
        if (fieldNode.visibleAnnotations != null) {
            clone.visibleAnnotations = new ArrayList();
            fieldNode.visibleAnnotations.forEach(annotationNode -> clone.visibleAnnotations.add(Cloner.clone(annotationNode)));
        }
        if (fieldNode.invisibleAnnotations != null) {
            clone.invisibleAnnotations = new ArrayList();
            fieldNode.invisibleAnnotations.forEach(annotationNode -> clone.invisibleAnnotations.add(Cloner.clone(annotationNode)));
        }
        if (fieldNode.visibleTypeAnnotations != null) {
            clone.visibleTypeAnnotations = new ArrayList();
            fieldNode.visibleTypeAnnotations.forEach(typeAnnotationNode -> clone.visibleTypeAnnotations.add(Cloner.clone(typeAnnotationNode)));
        }
        if (fieldNode.invisibleTypeAnnotations != null) {
            clone.invisibleTypeAnnotations = new ArrayList();
            fieldNode.invisibleTypeAnnotations.forEach(typeAnnotationNode -> clone.invisibleTypeAnnotations.add(Cloner.clone(typeAnnotationNode)));
        }
        if (fieldNode.attrs != null) {
            clone.attrs = new ArrayList();
            fieldNode.attrs.forEach(attribute -> clone.attrs.add(Cloner.clone(attribute)));
        }
        return clone;
    }

    public static MethodNode clone(MethodNode methodNode) {
        MethodNode clone = new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions == null ? new String[]{} : methodNode.exceptions.toArray(new String[0]));
        methodNode.accept((MethodVisitor)clone);
        return clone;
    }

    public static InsnList clone(InsnList insnList) {
        InsnList clone = new InsnList();
        Map<LabelNode, LabelNode> labels = Cloner.cloneLabels(insnList);
        for (AbstractInsnNode insnNode : insnList) {
            clone.add(insnNode.clone(labels));
        }
        return clone;
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> clone = new HashMap<LabelNode, LabelNode>();
        for (AbstractInsnNode insnNode : insnList) {
            if (!(insnNode instanceof LabelNode)) continue;
            clone.put((LabelNode)insnNode, new LabelNode());
        }
        return clone;
    }

    public static AnnotationNode clone(AnnotationNode annotationNode) {
        AnnotationNode clone = new AnnotationNode(annotationNode.desc);
        annotationNode.accept((AnnotationVisitor)clone);
        return clone;
    }

    public static TypeAnnotationNode clone(TypeAnnotationNode typeAnnotationNode) {
        TypeAnnotationNode clone = new TypeAnnotationNode(typeAnnotationNode.typeRef, typeAnnotationNode.typePath, typeAnnotationNode.desc);
        typeAnnotationNode.accept((AnnotationVisitor)clone);
        return clone;
    }

    public static Attribute clone(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            ArrayList modules = null;
            ArrayList hashes = null;
            if (moduleHashesAttribute.modules != null) {
                modules = new ArrayList(moduleHashesAttribute.modules);
            }
            if (moduleHashesAttribute.hashes != null) {
                hashes = new ArrayList(moduleHashesAttribute.hashes);
            }
            return new ModuleHashesAttribute(moduleHashesAttribute.algorithm, modules, hashes);
        }
        if (attribute instanceof ModuleResolutionAttribute) {
            ModuleResolutionAttribute moduleResolutionAttribute = (ModuleResolutionAttribute)attribute;
            return new ModuleResolutionAttribute(moduleResolutionAttribute.resolution);
        }
        if (attribute instanceof ModuleTargetAttribute) {
            ModuleTargetAttribute moduleTargetAttribute = (ModuleTargetAttribute)attribute;
            return new ModuleTargetAttribute(moduleTargetAttribute.platform);
        }
        return attribute;
    }

    @Generated
    private Cloner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

