/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm;

import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import lombok.Generated;
import net.lenni0451.commons.asm.Modifiers;
import net.lenni0451.commons.asm.Types;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ASMUtils {
    public static String dot(String s) {
        return s.replace('/', '.');
    }

    public static String slash(String s) {
        return s.replace('.', '/');
    }

    public static FieldNode getField(ClassNode classNode, String name, @Nullable String desc) {
        for (FieldNode fieldNode : classNode.fields) {
            if (!fieldNode.name.equals(name) || desc != null && !fieldNode.desc.equals(desc)) continue;
            return fieldNode;
        }
        return null;
    }

    public static MethodNode getMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(name) || !methodNode.desc.equals(desc)) continue;
            return methodNode;
        }
        return null;
    }

    public static int freeVarIndex(MethodNode methodNode) {
        int index = Modifiers.has(methodNode.access, 8) ? 0 : 1;
        for (Type type : Types.argumentTypes(methodNode)) {
            index += type.getSize();
        }
        for (AbstractInsnNode instruction : methodNode.instructions) {
            if (instruction instanceof VarInsnNode) {
                VarInsnNode varInsnNode = (VarInsnNode)instruction;
                if (varInsnNode.var < index) continue;
                index = varInsnNode.var;
                if (varInsnNode.getOpcode() == 22 || varInsnNode.getOpcode() == 24) {
                    ++index;
                }
                if (varInsnNode.getOpcode() == 55 || varInsnNode.getOpcode() == 57) {
                    ++index;
                }
                ++index;
                continue;
            }
            if (!(instruction instanceof IincInsnNode)) continue;
            IincInsnNode iincInsnNode = (IincInsnNode)instruction;
            if (iincInsnNode.var < index) continue;
            index = iincInsnNode.var + 1;
        }
        return index;
    }

    public static InsnList castObjectTo(Type targetType) {
        InsnList list = new InsnList();
        if (targetType.equals((Object)Type.BOOLEAN_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Boolean.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Boolean.class), "booleanValue", Types.methodDescriptor(Type.BOOLEAN_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.BYTE_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Byte.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Byte.class), "byteValue", Types.methodDescriptor(Type.BYTE_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.SHORT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Short.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Short.class), "shortValue", Types.methodDescriptor(Type.SHORT_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.CHAR_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Character.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Character.class), "charValue", Types.methodDescriptor(Type.CHAR_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.INT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Integer.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Integer.class), "intValue", Types.methodDescriptor(Type.INT_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.FLOAT_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Float.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Float.class), "floatValue", Types.methodDescriptor(Type.FLOAT_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.LONG_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Long.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Long.class), "longValue", Types.methodDescriptor(Type.LONG_TYPE, new Object[0]), false));
        } else if (targetType.equals((Object)Type.DOUBLE_TYPE)) {
            list.add((AbstractInsnNode)new TypeInsnNode(192, Types.internalName(Double.class)));
            list.add((AbstractInsnNode)new MethodInsnNode(182, Types.internalName(Double.class), "doubleValue", Types.methodDescriptor(Type.DOUBLE_TYPE, new Object[0]), false));
        } else {
            list.add((AbstractInsnNode)new TypeInsnNode(192, targetType.getInternalName()));
        }
        return list;
    }

    @Nullable
    public static AbstractInsnNode boxPrimitive(Type primitive) {
        if (primitive.equals((Object)Type.BOOLEAN_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Boolean.class), "valueOf", Types.methodDescriptor(Boolean.class, Boolean.TYPE), false);
        }
        if (primitive.equals((Object)Type.BYTE_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Byte.class), "valueOf", Types.methodDescriptor(Byte.class, Byte.TYPE), false);
        }
        if (primitive.equals((Object)Type.SHORT_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Short.class), "valueOf", Types.methodDescriptor(Short.class, Short.TYPE), false);
        }
        if (primitive.equals((Object)Type.CHAR_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Character.class), "valueOf", Types.methodDescriptor(Character.class, Character.TYPE), false);
        }
        if (primitive.equals((Object)Type.INT_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Integer.class), "valueOf", Types.methodDescriptor(Integer.class, Integer.TYPE), false);
        }
        if (primitive.equals((Object)Type.LONG_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Long.class), "valueOf", Types.methodDescriptor(Long.class, Long.TYPE), false);
        }
        if (primitive.equals((Object)Type.FLOAT_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Float.class), "valueOf", Types.methodDescriptor(Float.class, Float.TYPE), false);
        }
        if (primitive.equals((Object)Type.DOUBLE_TYPE)) {
            return new MethodInsnNode(184, Types.internalName(Double.class), "valueOf", Types.methodDescriptor(Double.class, Double.TYPE), false);
        }
        return null;
    }

    @Nullable
    public static Number toNumber(@Nullable AbstractInsnNode instruction) {
        if (instruction == null) {
            return null;
        }
        if (instruction.getOpcode() >= 2 && instruction.getOpcode() <= 8) {
            return instruction.getOpcode() - 3;
        }
        if (instruction.getOpcode() >= 9 && instruction.getOpcode() <= 10) {
            return (long)(instruction.getOpcode() - 9);
        }
        if (instruction.getOpcode() >= 11 && instruction.getOpcode() <= 13) {
            return Float.valueOf(instruction.getOpcode() - 11);
        }
        if (instruction.getOpcode() >= 14 && instruction.getOpcode() <= 15) {
            return (double)(instruction.getOpcode() - 14);
        }
        if (instruction.getOpcode() == 16) {
            return (byte)((IntInsnNode)instruction).operand;
        }
        if (instruction.getOpcode() == 17) {
            return (short)((IntInsnNode)instruction).operand;
        }
        if (instruction.getOpcode() == 18 && ((LdcInsnNode)instruction).cst instanceof Number) {
            return (Number)((LdcInsnNode)instruction).cst;
        }
        return null;
    }

    public static AbstractInsnNode intPush(int i) {
        if (i >= -1 && i <= 5) {
            return new InsnNode(3 + i);
        }
        if (i >= -128 && i <= 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    public static AbstractInsnNode longPush(long l) {
        if (l == 0L) {
            return new InsnNode(9);
        }
        if (l == 1L) {
            return new InsnNode(10);
        }
        return new LdcInsnNode((Object)l);
    }

    public static AbstractInsnNode floatPush(float f) {
        if (f == 0.0f) {
            return new InsnNode(11);
        }
        if (f == 1.0f) {
            return new InsnNode(12);
        }
        if (f == 2.0f) {
            return new InsnNode(13);
        }
        return new LdcInsnNode((Object)Float.valueOf(f));
    }

    public static AbstractInsnNode doublePush(double d) {
        if (d == 0.0) {
            return new InsnNode(14);
        }
        if (d == 1.0) {
            return new InsnNode(15);
        }
        return new LdcInsnNode((Object)d);
    }

    public static ClassNode createEmptyClass(String name) {
        ClassNode classNode = new ClassNode();
        classNode.visit(52, 1, ASMUtils.slash(name), null, Types.internalName(Object.class), null);
        MethodNode constructor = new MethodNode(1, "<init>", Types.methodDescriptor(Type.VOID_TYPE, new Object[0]), null, null);
        constructor.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, Types.internalName(Object.class), "<init>", Types.methodDescriptor(Type.VOID_TYPE, new Object[0]), false));
        constructor.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(constructor);
        return classNode;
    }

    public static int[] parameterIndices(MethodNode methodNode) {
        Type[] types = Types.argumentTypes(methodNode);
        int[] indices = new int[types.length];
        int current = Modifiers.has(methodNode.access, 8) ? 0 : 1;
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            indices[i] = current;
            current += type.getSize();
        }
        return indices;
    }

    public static InsnList swap(Type top, Type bottom) {
        InsnList insns = new InsnList();
        if (top.getSize() == 1 && bottom.getSize() == 1) {
            insns.add((AbstractInsnNode)new InsnNode(95));
        } else if (top.getSize() == 2 && bottom.getSize() == 2) {
            insns.add((AbstractInsnNode)new InsnNode(94));
            insns.add((AbstractInsnNode)new InsnNode(88));
        } else if (top.getSize() == 2) {
            insns.add((AbstractInsnNode)new InsnNode(91));
            insns.add((AbstractInsnNode)new InsnNode(87));
        } else {
            insns.add((AbstractInsnNode)new InsnNode(93));
            insns.add((AbstractInsnNode)new InsnNode(88));
        }
        return insns;
    }

    public static InsnList loadMethodArgs(MethodNode method) {
        Type[] args = Type.getArgumentTypes((String)method.desc);
        InsnList insns = new InsnList();
        int index = Modifiers.has(method.access, 8) ? 0 : 1;
        for (Type arg : args) {
            insns.add((AbstractInsnNode)new VarInsnNode(arg.getOpcode(21), index));
            index += arg.getSize();
        }
        return insns;
    }

    public static String generateVariableName(Type type, Predicate<String> doesExist) {
        String newName;
        if (type.getSort() == 9) {
            newName = type.getElementType().getClassName();
            for (int j = 0; j < type.getDimensions(); ++j) {
                newName = newName + "Array";
            }
        } else {
            newName = type.getClassName();
        }
        if (type.getDescriptor().length() == 1) {
            newName = type.getDescriptor().toLowerCase(Locale.ROOT);
        } else {
            newName = newName.substring(newName.lastIndexOf(46) + 1);
            newName = (newName = newName.substring(newName.lastIndexOf(36) + 1)).toUpperCase(Locale.ROOT).equals(newName) ? newName.toLowerCase(Locale.ROOT) : newName.substring(0, 1).toLowerCase(Locale.ROOT) + newName.substring(1);
        }
        if (SourceVersion.isKeyword(newName)) {
            newName = "_" + newName;
        }
        int index = 2;
        String name = newName;
        while (doesExist.test(name)) {
            name = newName + index++;
        }
        return name;
    }

    @Generated
    private ASMUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

