/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mysql;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

public class MySqlSchemaDialect
extends RelationalDatabaseSchemaDialect {
    public Object convertToDataBase(Object value, RelationalPersistentProperty property) {
        ColumnDefinition def;
        if (value instanceof OffsetTime || value instanceof ZonedDateTime) {
            return value.toString();
        }
        if (value instanceof String && (def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class)) != null && def.min() > 0L && (long)((String)value).length() < def.min()) {
            value = StringUtils.rightPad((String)((String)value), (int)((int)def.min()), (char)' ');
        }
        if (value instanceof UUID) {
            value = ((UUID)value).toString();
        }
        return super.convertToDataBase(value, property);
    }

    public Object convertFromDataBase(Object value, Class<?> targetType) {
        if (OffsetTime.class.equals(targetType)) {
            return OffsetTime.parse((CharSequence)value);
        }
        if (ZonedDateTime.class.equals(targetType)) {
            return ZonedDateTime.parse((CharSequence)value);
        }
        if (UUID.class.equals(targetType)) {
            return UUID.fromString((String)value);
        }
        if (value instanceof Long) {
            if (Byte.class.equals(targetType) || Byte.TYPE.equals(targetType)) {
                value = ((Long)value).byteValue();
            } else if (Short.class.equals(targetType) || Short.TYPE.equals(targetType)) {
                value = ((Long)value).shortValue();
            } else if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
                value = ((Long)value).intValue();
            }
        }
        return super.convertFromDataBase(value, targetType);
    }

    protected String getColumnTypeString(Column col, Class<?> type, ColumnDefinition def) {
        if (def != null) {
            if (def.max() > 255L) {
                return "LONGTEXT";
            }
            if (def.max() > 0L) {
                return "VARCHAR(" + def.max() + ")";
            }
        }
        return "VARCHAR(255)";
    }

    protected String getColumnTypeTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        return "VARCHAR(24)";
    }

    protected String getColumnTypeDateTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        return "VARCHAR(100)";
    }

    protected String getColumnTypeUUID(Column col, Class<?> type, ColumnDefinition def) {
        return "VARCHAR(36)";
    }

    public boolean supportsUuidGeneration() {
        return false;
    }

    protected boolean canCreateIndexInTableDefinition(Index index) {
        return true;
    }

    protected void addIndexDefinitionInTable(Table table, Index index, StringBuilder sql) {
        if (index.isUnique()) {
            sql.append("CONSTRAINT UNIQUE INDEX ");
        } else {
            sql.append("INDEX ");
        }
        sql.append(index.getName());
        sql.append('(');
        boolean first = true;
        for (String col : index.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append(col);
        }
        sql.append(')');
    }

    protected boolean canDoConcurrentAlterTable() {
        return false;
    }

    protected boolean canAddMultipleConstraintsInSingleAlterTable() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }
}

