/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, Predicate<T> predicate) {
        return () -> Iterables.filter(iterable.iterator(), predicate);
    }

    public static <T> Iterator<T> filter(final Iterator<T> iterator, final Predicate<T> predicate) {
        return new Iterator<T>(){
            private boolean hasNext = true;
            private T next;
            {
                this.goNext();
            }

            private void goNext() {
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (!predicate.test(element)) continue;
                    this.next = element;
                    return;
                }
                this.hasNext = false;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object element = this.next;
                this.goNext();
                return element;
            }
        };
    }

    public static <T, U> Iterable<U> map(Iterable<T> iterable, Function<T, U> mapper) {
        return () -> Iterables.map(iterable.iterator(), mapper);
    }

    public static <T, U> Iterator<U> map(final Iterator<T> iterator, final Function<T, U> mapper) {
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iterator.next());
            }
        };
    }
}

