/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema.dialect;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SchemaStatements {
    private static final Log LOGGER = LogFactory.getLog(SchemaStatements.class);
    private List<SchemaStatement> statements = new LinkedList<SchemaStatement>();

    public void add(SchemaStatement statement) {
        this.statements.add(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SchemaStatement> peekReadyStatements() {
        LinkedList<SchemaStatement> ready = new LinkedList<SchemaStatement>();
        List<SchemaStatement> list = this.statements;
        synchronized (list) {
            Iterator<SchemaStatement> it = this.statements.iterator();
            while (it.hasNext()) {
                SchemaStatement s = it.next();
                if (s.hasDependency() || !s.canExecuteWith(ready)) continue;
                ready.add(s);
                it.remove();
            }
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(SchemaStatement done) {
        List<SchemaStatement> list = this.statements;
        synchronized (list) {
            for (SchemaStatement s : this.statements) {
                s.removeDependency(done);
            }
        }
    }

    public Mono<Void> execute(LcReactiveDataRelationalClient client) {
        return Flux.just((Object)"").expand(s -> this.execute(client, this.peekReadyStatements())).then();
    }

    private Flux<String> execute(LcReactiveDataRelationalClient client, List<SchemaStatement> statements) {
        return Flux.fromIterable(statements).subscribeOn(Schedulers.parallel()).publishOn(Schedulers.parallel()).parallel().runOn(Schedulers.parallel()).flatMap(s -> client.getSpringClient().sql(SchemaStatements.log(s.getSql())).fetch().rowsUpdated().doOnError(e -> SchemaStatements.log(s, e)).thenReturn(s)).sequential(1).doOnNext(this::done).map(s -> "");
    }

    public void print(PrintStream target) {
        while (!this.statements.isEmpty()) {
            for (SchemaStatement statement : this.peekReadyStatements()) {
                target.print(statement.getSql());
                target.println(";");
                this.done(statement);
            }
        }
    }

    private static String log(String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)sql);
        }
        return sql;
    }

    private static void log(SchemaStatement s, Throwable error) {
        LOGGER.error((Object)("Error executing " + s.getSql()), error);
    }
}

