/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.mapping.LcEntityWriter;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import net.lecousin.reactive.data.relational.query.InsertMultiple;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractInstanceProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SaveProcessor
extends AbstractInstanceProcessor<SaveRequest> {
    SaveProcessor() {
    }

    @Override
    protected <T> SaveRequest createRequest(EntityInstance<T> instance) {
        return new SaveRequest(instance);
    }

    @Override
    protected boolean doProcess(Operation op, SaveRequest request) {
        return true;
    }

    @Override
    protected void processForeignKey(Operation op, SaveRequest request, PropertyMetadata fkProperty, @Nullable PropertyStaticMetadata foreignTableInfo) {
        Object value = request.entity.getValue(fkProperty);
        Object originalValue = request.entity.getState().getPersistedValue(fkProperty.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            EntityInstance<Object> originalInstance = op.lcClient.getInstance(originalValue);
            if (foreignTableInfo != null) {
                SaveProcessor.removeForeignTableLink(request, foreignTableInfo, originalInstance);
            }
            if (foreignTableInfo != null && !foreignTableInfo.getForeignTableAnnotation().optional() || fkProperty.getForeignKeyAnnotation().cascadeDelete()) {
                op.addToDelete(originalInstance);
            }
        }
        if (value != null) {
            SaveRequest save = op.addToSave(op.lcClient.getInstance(value));
            if (!save.entity.getState().isPersisted()) {
                request.dependsOn(save);
            }
        }
    }

    private static void removeForeignTableLink(SaveRequest request, PropertyStaticMetadata foreignTableInfo, EntityInstance<?> originalInstance) {
        try {
            if (foreignTableInfo.isCollection()) {
                ModelUtils.removeFromCollectionField(foreignTableInfo.getField(), originalInstance.getEntity(), request.entity.getEntity());
            } else {
                originalInstance.getState().setForeignTableField(originalInstance.getEntity(), foreignTableInfo, null);
            }
        }
        catch (Exception e) {
            throw new ModelAccessException("Unable to remove link for removed entity", e);
        }
    }

    @Override
    protected void processForeignTableField(Operation op, SaveRequest request, PropertyStaticMetadata foreignTableInfo, @Nullable MutableObject<?> foreignFieldValue, PropertyMetadata fkProperty) {
        if (foreignFieldValue == null) {
            return;
        }
        if (foreignTableInfo.isCollection()) {
            SaveProcessor.processForeignTableFieldCollection(op, request, foreignTableInfo.getField(), foreignFieldValue, fkProperty);
        } else {
            SaveProcessor.processForeignTableFieldSimple(op, request, foreignTableInfo.getField(), foreignFieldValue, fkProperty);
        }
    }

    private static void processForeignTableFieldCollection(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, PropertyMetadata fkProperty) {
        ArrayList value = foreignFieldValue.getValue();
        Object originalValue = request.entity.getState().getPersistedValue(foreignTableField.getName());
        if (value == null) {
            if (originalValue == null) {
                return;
            }
            value = new ArrayList(0);
        }
        LinkedList<Object> deletedElements = new LinkedList<Object>();
        if (originalValue != null) {
            deletedElements.addAll(ModelUtils.getAsCollection(originalValue));
        }
        deletedElements.removeAll(ModelUtils.getAsCollection(value));
        if (!deletedElements.isEmpty()) {
            SaveProcessor.deletedElements(op, deletedElements, fkProperty);
        }
        for (Object element : ModelUtils.getAsCollection(value)) {
            op.addToSave(op.lcClient.getInstance(element));
            ModelUtils.setFieldValue(element, fkProperty.getStaticMetadata().getField(), request.entity.getEntity());
        }
    }

    private static void deletedElements(Operation op, List<Object> deletedElements, PropertyMetadata fkProperty) {
        ForeignKey fkAnnotation = fkProperty.getForeignKeyAnnotation();
        if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
            for (Object element : deletedElements) {
                op.addToDelete(op.lcClient.getInstance(element));
            }
        } else {
            for (Object element : deletedElements) {
                EntityInstance<Object> instance = op.lcClient.getInstance(element);
                op.addToSave(instance);
                instance.setValue(fkProperty, null);
            }
        }
    }

    private static void processForeignTableFieldSimple(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, PropertyMetadata fkProperty) {
        Object value = foreignFieldValue.getValue();
        Object originalValue = request.entity.getState().getPersistedValue(foreignTableField.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            EntityInstance<Object> originalInstance = op.lcClient.getInstance(originalValue);
            ForeignKey fkAnnotation = fkProperty.getForeignKeyAnnotation();
            if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
                op.addToDelete(originalInstance);
            } else {
                op.addToSave(originalInstance);
                ModelUtils.setFieldValue(originalValue, fkProperty.getStaticMetadata().getField(), null);
            }
        }
        if (value != null) {
            op.addToSave(op.lcClient.getInstance(value));
            ModelUtils.setFieldValue(value, fkProperty.getStaticMetadata().getField(), request.entity.getEntity());
        }
    }

    @Override
    protected Mono<Void> doRequests(Operation op, EntityMetadata entityType, List<SaveRequest> requests) {
        LinkedList<Mono<Void>> statements = new LinkedList<Mono<Void>>();
        boolean multipleInsertSupported = op.lcClient.getSchemaDialect().isMultipleInsertSupported();
        LinkedList<SaveRequest> toInsert = new LinkedList<SaveRequest>();
        for (SaveRequest request : requests) {
            if (!request.entity.getState().isPersisted()) {
                if (!multipleInsertSupported) {
                    statements.add(SaveProcessor.doInsertSingle(op, request));
                    continue;
                }
                toInsert.add(request);
                continue;
            }
            statements.add(SaveProcessor.doUpdate(op, request));
        }
        SaveProcessor.doInsert(op, entityType, toInsert, statements);
        return Operation.executeParallel(statements);
    }

    private static void doInsert(Operation op, EntityMetadata entityType, List<SaveRequest> requests, List<Mono<Void>> statements) {
        if (requests.isEmpty()) {
            return;
        }
        List<SaveRequest> remaining = requests;
        while (true) {
            if (remaining.size() == 1) {
                statements.add(SaveProcessor.doInsertSingle(op, remaining.get(0)));
                return;
            }
            if (remaining.size() <= 1000) {
                statements.add(SaveProcessor.doInsertMultiple(op, entityType, remaining));
                return;
            }
            statements.add(SaveProcessor.doInsertMultiple(op, entityType, remaining.subList(0, 1000)));
            remaining = remaining.subList(1000, remaining.size());
        }
    }

    private static Mono<Void> doInsertMultiple(Operation op, EntityMetadata entityType, List<SaveRequest> requests) {
        return Flux.defer(() -> {
            SqlQuery<InsertMultiple> query = new SqlQuery<InsertMultiple>(op.lcClient);
            Table table = Table.create((SqlIdentifier)entityType.getTableName());
            LinkedList<Column> columns = new LinkedList<Column>();
            LinkedList<PropertyMetadata> generated = new LinkedList<PropertyMetadata>();
            for (PropertyMetadata propertyMetadata : entityType.getPersistentProperties()) {
                if (propertyMetadata.isGeneratedValue()) {
                    GeneratedValue.Strategy strategy = propertyMetadata.getGeneratedValueStrategy();
                    if (GeneratedValue.Strategy.SEQUENCE.equals((Object)strategy)) {
                        columns.add(Column.create((SqlIdentifier)propertyMetadata.getColumnName(), (Table)table));
                        generated.add(propertyMetadata);
                        continue;
                    }
                    if (GeneratedValue.Strategy.RANDOM_UUID.equals((Object)strategy) && !op.lcClient.getSchemaDialect().supportsUuidGeneration()) {
                        columns.add(Column.create((SqlIdentifier)propertyMetadata.getColumnName(), (Table)table));
                        continue;
                    }
                    generated.add(propertyMetadata);
                    continue;
                }
                columns.add(Column.create((SqlIdentifier)propertyMetadata.getColumnName(), (Table)table));
            }
            LinkedList<List<Expression>> rows = new LinkedList<List<Expression>>();
            for (SaveRequest request : requests) {
                HashMap<SqlIdentifier, SimpleFunction> generatedValues = new HashMap<SqlIdentifier, SimpleFunction>();
                OutboundRow row = new OutboundRow();
                LcEntityWriter writer = new LcEntityWriter(op.lcClient.getMapper());
                long currentDate = System.currentTimeMillis();
                for (PropertyMetadata property : request.entity.getMetadata().getPersistentProperties()) {
                    if (property.isGeneratedValue()) {
                        GeneratedValue.Strategy strategy = property.getGeneratedValueStrategy();
                        if (GeneratedValue.Strategy.SEQUENCE.equals((Object)strategy)) {
                            generatedValues.put(property.getColumnName(), SimpleFunction.create((String)op.lcClient.getSchemaDialect().sequenceNextValueFunctionName(), Arrays.asList(SQL.literalOf((CharSequence)property.getRequiredGeneratedValueAnnotation().sequence()))));
                            continue;
                        }
                        if (!GeneratedValue.Strategy.RANDOM_UUID.equals((Object)strategy) || op.lcClient.getSchemaDialect().supportsUuidGeneration()) continue;
                        UUID uuid = UUID.randomUUID();
                        request.entity.setValue(property, uuid);
                        writer.writeProperty(row, property, request.entity.getPropertyAccessor());
                        continue;
                    }
                    if (property.isVersion()) {
                        request.entity.setValue(property, op.lcClient.getMapper().getConversionService().convert((Object)1L, property.getType()));
                    } else if (property.isCreatedDate() || property.isLastModifiedDate()) {
                        request.entity.setValue(property, SaveProcessor.getDateValue(currentDate, property.getType()));
                    }
                    writer.writeProperty(row, property, request.entity.getPropertyAccessor());
                }
                ArrayList<Object> values = new ArrayList<Object>(columns.size());
                for (Column col : columns) {
                    Expression value = (Expression)generatedValues.get(col.getReferenceName());
                    if (value != null) {
                        values.add(value);
                        continue;
                    }
                    Parameter val = row.get((Object)col.getReferenceName());
                    if (val.getValue() == null) {
                        values.add(SQL.nullLiteral());
                        continue;
                    }
                    values.add(query.marker(val.getValue()));
                }
                rows.add(values);
            }
            query.setQuery(new InsertMultiple(table, columns, rows));
            LinkedList linkedList = new LinkedList(requests);
            return query.execute().filter(statement -> statement.returnGeneratedValues(new String[0])).map((r, meta) -> {
                SaveRequest request = (SaveRequest)queue.removeFirst();
                SaveProcessor.mapGeneratedValues(r, meta, request.entity, generated);
                return request.entity.getEntity();
            }).all();
        }).then();
    }

    private static Mono<Void> doInsertSingle(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> {
            SqlQuery<Insert> query = new SqlQuery<Insert>(op.lcClient);
            LinkedList<PropertyMetadata> generated = new LinkedList<PropertyMetadata>();
            OutboundRow row = new OutboundRow();
            LcEntityWriter writer = new LcEntityWriter(op.lcClient.getMapper());
            long currentDate = System.currentTimeMillis();
            for (PropertyMetadata property : request.entity.getMetadata().getPersistentProperties()) {
                if (property.isGeneratedValue()) {
                    if (GeneratedValue.Strategy.RANDOM_UUID.equals((Object)property.getGeneratedValueStrategy()) && !op.lcClient.getSchemaDialect().supportsUuidGeneration()) {
                        UUID uuid = UUID.randomUUID();
                        request.entity.setValue(property, uuid);
                        writer.writeProperty(row, property, request.entity.getPropertyAccessor());
                        continue;
                    }
                    generated.add(property);
                    continue;
                }
                if (property.isVersion()) {
                    request.entity.setValue(property, op.lcClient.getMapper().getConversionService().convert((Object)1L, property.getType()));
                } else if (property.isCreatedDate() || property.isLastModifiedDate()) {
                    request.entity.setValue(property, SaveProcessor.getDateValue(currentDate, property.getType()));
                }
                writer.writeProperty(row, property, request.entity.getPropertyAccessor());
            }
            query.setQuery(SaveProcessor.createInsertQuery(query, row, request.entity.getMetadata().getTableName(), generated));
            return query.execute().filter(statement -> statement.returnGeneratedValues(new String[0])).map((r, meta) -> {
                SaveProcessor.mapGeneratedValues(r, meta, request.entity, generated);
                return request.entity.getEntity();
            });
        }).flatMap(RowsFetchSpec::first).then();
    }

    private static Insert createInsertQuery(SqlQuery<Insert> query, OutboundRow row, SqlIdentifier tableName, List<PropertyMetadata> generated) {
        Table table = Table.create((SqlIdentifier)tableName);
        ArrayList<Column> columns = new ArrayList<Column>(row.size());
        ArrayList<Object> values = new ArrayList<Object>(row.size());
        for (PropertyMetadata property : generated) {
            if (!GeneratedValue.Strategy.SEQUENCE.equals((Object)property.getGeneratedValueStrategy())) continue;
            columns.add(Column.create((SqlIdentifier)property.getColumnName(), (Table)table));
            values.add(SimpleFunction.create((String)query.getClient().getSchemaDialect().sequenceNextValueFunctionName(), Arrays.asList(SQL.literalOf((CharSequence)property.getRequiredGeneratedValueAnnotation().sequence()))));
        }
        for (Map.Entry entry : row.entrySet()) {
            columns.add(Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table));
            if (((Parameter)entry.getValue()).getValue() == null) {
                values.add(SQL.nullLiteral());
                continue;
            }
            values.add(query.marker(((Parameter)entry.getValue()).getValue()));
        }
        return Insert.builder().into(table).columns(columns).values(values).build();
    }

    private static void mapGeneratedValues(Row row, RowMetadata meta, EntityInstance<?> entity, List<PropertyMetadata> generated) {
        if (!generated.isEmpty()) {
            Collection names = meta.getColumnNames();
            if (names.size() == generated.size()) {
                int index = 0;
                for (PropertyMetadata property : generated) {
                    entity.setValue(property, entity.getMetadata().getClient().getSchemaDialect().convertFromDataBase(row.get(index++), property.getType()));
                }
            } else {
                IdentifierProcessing idp = entity.getMetadata().getClient().getDialect().getIdentifierProcessing();
                for (PropertyMetadata property : generated) {
                    entity.setValue(property, entity.getMetadata().getClient().getSchemaDialect().convertFromDataBase(row.get(property.getColumnName().toSql(idp)), property.getType()));
                }
            }
        }
        entity.getState().loaded(entity.getEntity());
    }

    private static Mono<Void> doUpdate(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> SaveProcessor.createUpdateRequest(op, request)).flatMap(updatedRows -> updatedRows != null ? updatedRows.doOnSuccess(nb -> SaveProcessor.entityUpdated(op, request)).then() : Mono.empty());
    }

    private static Mono<Integer> createUpdateRequest(Operation op, SaveRequest request) {
        LcEntityWriter writer;
        OutboundRow row;
        LinkedList<AssignValue> assignments;
        SqlQuery<Update> query = new SqlQuery<Update>(op.lcClient);
        Table table = Table.create((SqlIdentifier)request.entity.getMetadata().getTableName());
        if (!SaveProcessor.prepareUpdate(request, table, assignments = new LinkedList<AssignValue>(), row = new OutboundRow(), writer = new LcEntityWriter(op.lcClient.getMapper()), query)) {
            return null;
        }
        for (Map.Entry entry : row.entrySet()) {
            assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table), (Expression)(((Parameter)entry.getValue()).getValue() != null ? query.marker(((Parameter)entry.getValue()).getValue()) : SQL.nullLiteral())));
        }
        Condition criteria = request.entity.getConditionOnId(query);
        if (request.entity.getMetadata().hasVersionProperty()) {
            PropertyMetadata property = request.entity.getMetadata().getRequiredVersionProperty();
            Object value = request.entity.getValue(property);
            Assert.notNull((Object)value, (String)"Version must not be null");
            long currentVersion = ((Number)value).longValue();
            criteria = criteria.and((Condition)Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(currentVersion)));
        }
        query.setQuery(Update.builder().table(table).set(assignments).where(criteria).build());
        Mono rowsUpdated = query.execute().fetch().rowsUpdated();
        if (request.entity.getMetadata().hasVersionProperty()) {
            rowsUpdated = rowsUpdated.flatMap(updatedRows -> {
                if (updatedRows == 0) {
                    return Mono.error((Throwable)new OptimisticLockingFailureException("Version does not match"));
                }
                return Mono.just((Object)updatedRows);
            });
        }
        return rowsUpdated;
    }

    private static boolean prepareUpdate(SaveRequest request, Table table, List<AssignValue> assignments, OutboundRow row, LcEntityWriter writer, SqlQuery<Update> query) {
        boolean hasUpdate = false;
        HashMap propertiesToSetIfUpdate = new HashMap();
        long currentDate = System.currentTimeMillis();
        for (PropertyMetadata propertyMetadata : request.entity.getMetadata().getPersistentProperties()) {
            if (propertyMetadata.isVersion()) {
                Object value = request.entity.getValue(propertyMetadata);
                Assert.notNull((Object)value, (String)("Version must not be null (property " + propertyMetadata.getName() + " on " + request.entity.getType().getSimpleName() + ")"));
                long currentVersion = ((Number)value).longValue();
                assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)propertyMetadata.getColumnName(), (Table)table), (Expression)query.marker(currentVersion + 1L)));
                continue;
            }
            if (propertyMetadata.isLastModifiedDate()) {
                propertiesToSetIfUpdate.put(propertyMetadata, SaveProcessor.getDateValue(currentDate, propertyMetadata.getType()));
                continue;
            }
            if (!SaveProcessor.needsUpdate(request, propertyMetadata)) continue;
            if (propertyMetadata.isUpdatable()) {
                writer.writeProperty(row, propertyMetadata, request.entity.getPropertyAccessor());
                hasUpdate = true;
                continue;
            }
            request.entity.getState().restorePersistedValue(request.entity.getEntity(), propertyMetadata.getStaticMetadata());
        }
        if (hasUpdate) {
            for (Map.Entry entry : propertiesToSetIfUpdate.entrySet()) {
                request.entity.setValue((PropertyMetadata)entry.getKey(), entry.getValue());
                writer.writeProperty(row, (PropertyMetadata)entry.getKey(), request.entity.getPropertyAccessor());
            }
        }
        return hasUpdate;
    }

    private static boolean needsUpdate(SaveRequest request, PropertyMetadata property) {
        Object actual;
        Object persisted = request.entity.getState().getPersistedValue(property.getName());
        if (persisted != (actual = request.entity.getValue(property))) {
            return true;
        }
        if (persisted == null) {
            return false;
        }
        return !Objects.deepEquals(persisted, actual);
    }

    private static void entityUpdated(Operation op, SaveRequest request) {
        request.entity.getState().load(request.entity.getEntity());
        if (request.entity.getMetadata().hasVersionProperty()) {
            PropertyMetadata property = request.entity.getMetadata().getRequiredVersionProperty();
            Object version = request.entity.getValue(property);
            Assert.notNull((Object)version, (String)"Version must not be null");
            request.entity.setValue(property, op.lcClient.getMapper().getConversionService().convert((Object)(((Number)version).longValue() + 1L), property.getType()));
        }
    }

    private static <T> T getDateValue(long timestamp, Class<T> type) {
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (T)Long.valueOf(timestamp);
        }
        if (type.isAssignableFrom(Instant.class)) {
            return (T)Instant.ofEpochMilli(timestamp);
        }
        if (type.isAssignableFrom(LocalDate.class)) {
            return (T)LocalDate.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(LocalTime.class)) {
            return (T)LocalTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(OffsetTime.class)) {
            return (T)OffsetTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(LocalDateTime.class)) {
            return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(ZonedDateTime.class)) {
            return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        return null;
    }

    static class SaveRequest
    extends AbstractInstanceProcessor.Request {
        <T> SaveRequest(EntityInstance<T> instance) {
            super(instance);
            if (!instance.getState().isLoaded() && instance.getState().isPersisted()) {
                this.toProcess = false;
            }
        }
    }
}

