/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import net.lecousin.reactive.data.relational.query.operation.SaveProcessor;
import net.lecousin.reactive.data.relational.sql.ColumnIncrement;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

class PropertyUpdater
extends AbstractProcessor<Request> {
    private Map<PropertyMetadata, Map<Object, Request>> requests = new HashMap<PropertyMetadata, Map<Object, Request>>();

    PropertyUpdater() {
    }

    Request update(PropertyMetadata property, Object whereValueIs, Object newValue) {
        Map map = this.requests.computeIfAbsent(property, p -> new HashMap());
        return map.computeIfAbsent(whereValueIs, w -> new Request(property, whereValueIs, newValue));
    }

    @Override
    protected Mono<Void> executeRequests(Operation op) {
        LinkedList<Mono<Void>> calls = new LinkedList<Mono<Void>>();
        for (Map.Entry<PropertyMetadata, Map<Object, Request>> property : this.requests.entrySet()) {
            PropertyMetadata versionProperty = property.getKey().getEntity().getVersionProperty();
            HashMap<Object, Set<Object>> reverseMap = new HashMap<Object, Set<Object>>();
            LinkedList<Request> ready = new LinkedList<Request>();
            for (Map.Entry<Object, Request> entry : property.getValue().entrySet()) {
                if (!this.canExecuteRequest(entry.getValue())) continue;
                Set set = reverseMap.computeIfAbsent(entry.getValue().newValue, e -> new HashSet());
                set.add(entry.getKey());
                ready.add(entry.getValue());
            }
            if (reverseMap.isEmpty()) continue;
            PropertyUpdater.executeUpdates(op, reverseMap, property.getKey(), versionProperty, ready, calls);
        }
        return Operation.executeParallel(calls);
    }

    private static void executeUpdates(Operation op, Map<Object, Set<Object>> reverseMap, PropertyMetadata property, @Nullable PropertyMetadata versionProperty, List<Request> ready, List<Mono<Void>> calls) {
        Table table = Table.create((SqlIdentifier)property.getEntity().getTableName());
        for (Map.Entry<Object, Set<Object>> update : reverseMap.entrySet()) {
            SqlQuery<Update> query = new SqlQuery<Update>(op.lcClient);
            ArrayList<Expression> values = new ArrayList<Expression>(update.getValue().size());
            for (Object value : update.getValue()) {
                values.add(query.marker(value));
            }
            LinkedList<AssignValue> assignments = new LinkedList<AssignValue>();
            assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)(update.getKey() != null ? query.marker(update.getKey()) : SQL.nullLiteral())));
            if (versionProperty != null) {
                assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)versionProperty.getColumnName(), (Table)table), (Expression)SQL.literalOf((Object)new ColumnIncrement(Column.create((SqlIdentifier)versionProperty.getColumnName(), (Table)table), op.lcClient))));
            }
            Condition where = Conditions.in((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), values);
            for (SaveProcessor.SaveRequest save : op.save.getPendingRequests(property.getEntity(), s -> ((Set)update.getValue()).contains(ModelUtils.getPersistedDatabaseValue(s.entity.getState(), property)))) {
                if (save.entity.getState().isPersisted()) {
                    where = where.and(save.entity.getConditionOnId(query).not());
                }
                save.entity.setValue(property, update.getKey());
            }
            query.setQuery(Update.builder().table(table).set(assignments).where(where).build());
            calls.add((Mono<Void>)query.execute().then().doOnSuccess(v -> ready.forEach(r -> {
                r.executed = true;
            })));
        }
    }

    static class Request
    extends AbstractProcessor.Request {
        PropertyMetadata property;
        Object whereValueIs;
        Object newValue;

        Request(PropertyMetadata property, Object whereValueIs, Object newValue) {
            this.property = property;
            this.whereValueIs = whereValueIs;
            this.newValue = newValue;
        }
    }
}

