/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.springframework.data.mapping.MappingException;
import reactor.core.publisher.Mono;

class EntityLoader {
    private Map<EntityMetadata, Map<EntityInstance<?>, List<Consumer<EntityInstance<?>>>>> toLoad = new HashMap();
    private Map<EntityMetadata, Map<PropertyMetadata, Map<Object, List<Consumer<EntityInstance<?>>>>>> toRetrieve = new HashMap();

    EntityLoader() {
    }

    Mono<Void> doOperations(Operation op) {
        LinkedList<Mono<Void>> loads = new LinkedList<Mono<Void>>();
        this.doLoad(op, loads);
        this.doRetrieve(op, loads);
        return Operation.executeParallel(loads);
    }

    <T> void load(EntityInstance<T> instance, Consumer<EntityInstance<T>> onLoaded) {
        Map map = this.toLoad.computeIfAbsent(instance.getMetadata(), e -> new HashMap());
        List consumers = map.computeIfAbsent(instance, v -> new LinkedList());
        consumers.add(onLoaded);
    }

    private void doLoad(Operation op, List<Mono<Void>> loads) {
        Map<EntityMetadata, Map<EntityInstance<?>, List<Consumer<EntityInstance<?>>>>> map = this.toLoad;
        this.toLoad = new HashMap();
        for (Map.Entry<EntityMetadata, Map<EntityInstance<?>, List<Consumer<EntityInstance<?>>>>> entity : map.entrySet()) {
            loads.add((Mono<Void>)op.lcClient.lazyLoadInstances(entity.getValue().keySet()).doOnNext(loaded -> {
                for (Consumer consumer : (List)((Map)entity.getValue()).get(loaded)) {
                    op.toCall(() -> consumer.accept(loaded));
                }
            }).then());
        }
    }

    <T> void retrieve(PropertyMetadata property, Object propertyValue, Consumer<EntityInstance<T>> consumer) {
        EntityMetadata type = property.getEntity();
        Map map = this.toRetrieve.computeIfAbsent(type, e -> new HashMap());
        Map byValue = map.computeIfAbsent(property, p -> new HashMap());
        List list = byValue.computeIfAbsent(propertyValue, v -> new LinkedList());
        list.add(consumer);
    }

    private void doRetrieve(Operation op, List<Mono<Void>> loads) {
        Map<EntityMetadata, Map<PropertyMetadata, Map<Object, List<Consumer<EntityInstance<?>>>>>> map = this.toRetrieve;
        this.toRetrieve = new HashMap();
        for (Map.Entry<EntityMetadata, Map<PropertyMetadata, Map<Object, List<Consumer<EntityInstance<?>>>>>> entity : map.entrySet()) {
            for (Map.Entry<PropertyMetadata, Map<Object, List<Consumer<EntityInstance<?>>>>> property : entity.getValue().entrySet()) {
                loads.add((Mono<Void>)op.lcClient.execute(SelectQuery.from(entity.getKey().getType(), "e").where(Criteria.property("e", property.getKey().getName()).in(property.getValue().keySet())), null).map(e -> EntityLoader.retrieved(e, op, (PropertyMetadata)property.getKey(), (Map)property.getValue())).then());
            }
        }
    }

    private static <T> T retrieved(T entity, Operation op, PropertyMetadata property, Map<Object, List<Consumer<EntityInstance<?>>>> consumersMap) {
        try {
            EntityInstance instance = op.lcClient.getInstance(entity);
            List<Consumer<EntityInstance<?>>> consumers = consumersMap.get(instance.getDatabaseValue(property));
            if (consumers != null) {
                for (Consumer<EntityInstance<?>> c : consumers) {
                    op.toCall(() -> c.accept(instance));
                }
            }
            return entity;
        }
        catch (Exception e) {
            throw new MappingException("Error analyzing data from retrieved entity", (Throwable)e);
        }
    }
}

