/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractInstanceProcessor;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

class DeleteProcessor
extends AbstractInstanceProcessor<DeleteRequest> {
    DeleteProcessor() {
    }

    @Override
    protected <T> DeleteRequest createRequest(EntityInstance<T> instance) {
        return new DeleteRequest(instance);
    }

    @Override
    protected boolean doProcess(Operation op, DeleteRequest request) {
        if (!request.entity.getState().isPersisted()) {
            return false;
        }
        EntityMetadata type = request.entity.getMetadata();
        for (EntityMetadata entity : op.lcClient.getEntities()) {
            if (entity.equals(type)) continue;
            for (PropertyMetadata fkProperty : entity.getForeignKeys()) {
                PropertyStaticMetadata ft;
                if (!fkProperty.getType().equals(type.getType()) || (ft = type.getStaticMetadata().getForeignTableForJoinKey(fkProperty.getName(), entity.getType())) != null) continue;
                this.processForeignTableField(op, request, ft, (MutableObject<?>)null, fkProperty);
            }
        }
        return true;
    }

    @Override
    protected void processForeignKey(Operation op, DeleteRequest request, PropertyMetadata fkProperty, @Nullable PropertyStaticMetadata foreignTableInfo) {
        Object foreignInstance;
        if (!request.entity.getMetadata().hasIdProperty()) {
            foreignInstance = request.entity.getValue(fkProperty);
            if (foreignInstance != null) {
                foreignInstance = request.entity.getForeignKeyValue(fkProperty, foreignInstance);
            }
            request.saveForeignKeyValue(fkProperty.getName(), foreignInstance);
        }
        if (foreignTableInfo != null) {
            if (foreignTableInfo.isCollection()) {
                DeleteProcessor.removeFromForeignTableCollection(request, fkProperty, foreignTableInfo);
                return;
            }
            if (foreignTableInfo.getForeignTableAnnotation().optional() && !fkProperty.getForeignKeyAnnotation().cascadeDelete()) {
                if (request.entity.getState().isLoaded() && (foreignInstance = request.entity.getValue(fkProperty)) != null && request.entity.isPersistedForeignKey(fkProperty, foreignInstance)) {
                    ModelUtils.setFieldValue(foreignInstance, foreignTableInfo.getField(), null);
                }
                return;
            }
        } else if (!fkProperty.getForeignKeyAnnotation().cascadeDelete()) {
            return;
        }
        if (request.entity.getState().isLoaded()) {
            this.deleteForeignKeyInstance(op, request, request.entity.getState().getPersistedValue(fkProperty.getName()));
            return;
        }
        op.loader.load(request.entity, loaded -> this.deleteForeignKeyInstance(op, request, request.entity.getValue(fkProperty)));
    }

    private static void removeFromForeignTableCollection(DeleteRequest request, PropertyMetadata fkProperty, PropertyStaticMetadata foreignTableInfo) {
        Object foreignInstance;
        if (request.entity.getState().isLoaded() && (foreignInstance = request.entity.getValue(fkProperty)) != null && request.entity.isPersistedForeignKey(fkProperty, foreignInstance)) {
            try {
                ModelUtils.removeFromCollectionField(foreignTableInfo.getField(), foreignInstance, request.entity.getEntity());
            }
            catch (Exception e) {
                throw new ModelAccessException("Cannot remove instance from collection field", e);
            }
        }
    }

    private void deleteForeignKeyInstance(Operation op, DeleteRequest request, Object foreignInstance) {
        if (foreignInstance == null) {
            return;
        }
        DeleteRequest deleteForeign = (DeleteRequest)this.addToProcess(op, op.lcClient.getInstance(foreignInstance));
        deleteForeign.dependsOn(request);
    }

    @Override
    protected void processForeignTableField(Operation op, DeleteRequest request, PropertyStaticMetadata foreignTableInfo, @Nullable MutableObject<?> foreignFieldValue, PropertyMetadata fkProperty) {
        if (fkProperty.getForeignKeyAnnotation().onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.SET_TO_NULL)) {
            Object foreignInstance;
            Object instId = request.entity.getRequiredPrimaryKey();
            request.dependsOn(op.updater.update(fkProperty, instId, null));
            if (foreignFieldValue != null && (foreignInstance = foreignFieldValue.getValue()) != null) {
                ModelUtils.setFieldValue(foreignInstance, fkProperty.getStaticMetadata().getField(), null);
            }
            return;
        }
        if (foreignFieldValue != null && foreignTableInfo != null && request.entity.getState().getPersistedValue(foreignTableInfo.getField().getName()) == foreignFieldValue.getValue()) {
            Object foreignInstance = foreignFieldValue.getValue();
            if (foreignInstance == null) {
                return;
            }
            if (foreignTableInfo.isCollection()) {
                for (Object o : ModelUtils.getAsCollection(foreignFieldValue.getValue())) {
                    request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, op.lcClient.getInstance(o)));
                }
            } else {
                request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, op.lcClient.getInstance(foreignFieldValue.getValue())));
            }
        } else {
            Object instId = request.entity.getRequiredPrimaryKey();
            if (!DeleteProcessor.hasOtherLinks(fkProperty.getEntity(), fkProperty.getName())) {
                request.dependsOn(op.deleteWithoutLoading.addRequest(fkProperty, instId));
            } else {
                op.loader.retrieve(fkProperty, instId, loaded -> request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, loaded)));
            }
        }
    }

    private static boolean hasOtherLinks(EntityMetadata entityType, String otherThanField) {
        for (PropertyStaticMetadata ft : entityType.getStaticMetadata().getForeignTables()) {
            if (ft.getField().getName().equals(otherThanField)) continue;
            return true;
        }
        for (PropertyMetadata prop : entityType.getProperties()) {
            if (prop.getName().equals(otherThanField) || !prop.isForeignKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Mono<Void> doRequests(Operation op, EntityMetadata entityType, List<DeleteRequest> requests) {
        Condition criteria;
        Iterator<DeleteRequest> it = requests.iterator();
        while (it.hasNext()) {
            DeleteRequest r = it.next();
            if (r.entity.getState().isPersisted()) continue;
            r.executed = true;
            it.remove();
        }
        if (requests.isEmpty()) {
            return Mono.empty();
        }
        SqlQuery<Delete> delete = new SqlQuery<Delete>(op.lcClient);
        Table table = Table.create((SqlIdentifier)entityType.getTableName());
        Condition condition = criteria = entityType.hasIdProperty() ? DeleteProcessor.createCriteriaOnIds(entityType, requests, delete, table) : DeleteProcessor.createCriteriaOnProperties(entityType, requests, delete, table);
        if (LcReactiveDataRelationalClient.logger.isDebugEnabled()) {
            LcReactiveDataRelationalClient.logger.debug((Object)("Delete " + entityType.getType().getName() + " where " + criteria));
        }
        delete.setQuery(StatementBuilder.delete().from(table).where(criteria).build());
        return delete.execute().then().doOnSuccess(v -> op.toCall(() -> DeleteProcessor.deleteDone(entityType, requests)));
    }

    private static Condition createCriteriaOnIds(EntityMetadata entityType, List<DeleteRequest> requests, SqlQuery<Delete> query, Table table) {
        ArrayList<Expression> ids = new ArrayList<Expression>(requests.size());
        for (DeleteRequest request : requests) {
            PropertyMetadata idProperty = entityType.getRequiredIdProperty();
            Object id = request.entity.getValue(idProperty);
            ids.add(query.marker(query.getClient().getSchemaDialect().convertToDataBase(id, idProperty)));
        }
        return Conditions.in((Expression)Column.create((SqlIdentifier)entityType.getRequiredIdProperty().getColumnName(), (Table)table), ids);
    }

    private static Condition createCriteriaOnProperties(EntityMetadata entityType, List<DeleteRequest> requests, SqlQuery<Delete> query, Table table) {
        Condition criteria = null;
        Iterator<DeleteRequest> it = requests.iterator();
        do {
            DeleteRequest request = it.next();
            Condition c = null;
            Iterator<PropertyMetadata> itProperty = entityType.getPersistentProperties().iterator();
            do {
                PropertyMetadata property = itProperty.next();
                Condition propertyCondition = DeleteProcessor.createConditionOnProperty(table, property, request, query);
                Condition condition = c = c != null ? c.and(propertyCondition) : propertyCondition;
            } while (itProperty.hasNext());
            Condition condition = criteria = criteria != null ? criteria.or(c) : c;
        } while (it.hasNext());
        return criteria;
    }

    private static Condition createConditionOnProperty(Table table, PropertyMetadata property, DeleteRequest request, SqlQuery<Delete> query) {
        Object value = request.entity.getDatabaseValue(property);
        if (value == null) {
            return Conditions.isNull((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table));
        }
        if (property.isForeignKey()) {
            value = request.getSavedForeignKeyValue(property.getName());
        }
        value = query.getClient().getSchemaDialect().convertToDataBase(value, property);
        return Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(value));
    }

    private static void deleteDone(EntityMetadata entityType, List<DeleteRequest> done) {
        for (DeleteRequest request : done) {
            request.entity.getState().deleted();
            PropertyMetadata idProperty = entityType.getIdProperty();
            if (idProperty == null || idProperty.getType().isPrimitive()) continue;
            request.entity.setValue(idProperty, null);
        }
    }

    static class DeleteRequest
    extends AbstractInstanceProcessor.Request {
        private Map<String, Object> savedForeignKeys = new HashMap<String, Object>();

        <T> DeleteRequest(EntityInstance<T> instance) {
            super(instance);
        }

        private void saveForeignKeyValue(String foreignKey, Object value) {
            this.savedForeignKeys.put(foreignKey, value);
        }

        private Object getSavedForeignKeyValue(String foreignKey) {
            return this.savedForeignKeys.get(foreignKey);
        }
    }
}

