/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.EntityStaticMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

abstract class AbstractInstanceProcessor<R extends Request>
extends AbstractProcessor<R> {
    private Map<EntityMetadata, Map<Object, R>> requests = new HashMap<EntityMetadata, Map<Object, R>>();

    AbstractInstanceProcessor() {
    }

    public <T> R addToProcess(Operation op, EntityInstance<T> instance) {
        return this.addRequest(op, instance);
    }

    public <T> R addToNotProcess(Operation op, EntityInstance<T> instance) {
        R request = this.addRequest(op, instance);
        ((Request)request).toProcess = false;
        return request;
    }

    List<R> getPendingRequests(EntityMetadata type, Predicate<R> predicate) {
        LinkedList<Request> list = new LinkedList<Request>();
        Map<Object, R> map = this.requests.get(type);
        if (map == null) {
            return list;
        }
        for (Request request : map.values()) {
            if (!request.toProcess || request.executed || !request.entity.getState().isPersisted() || !request.entity.getState().isLoaded() || !predicate.test(request)) continue;
            list.add(request);
        }
        return list;
    }

    boolean processRequests(Operation op) {
        boolean somethingProcessed = false;
        for (Map<Object, R> map : new ArrayList<Map<Object, R>>(this.requests.values())) {
            for (Request request : new ArrayList<R>(map.values())) {
                somethingProcessed |= this.process(op, request);
            }
        }
        return somethingProcessed;
    }

    private boolean process(Operation op, R request) {
        if (((Request)request).processed || !((Request)request).toProcess) {
            return false;
        }
        ((Request)request).processed = true;
        if (!this.doProcess(op, request)) {
            return false;
        }
        this.processForeignKeys(op, request);
        this.processForeignTables(op, request);
        return true;
    }

    private void processForeignKeys(Operation op, R request) {
        for (PropertyMetadata property : ((Request)request).entity.getMetadata().getForeignKeys()) {
            PropertyStaticMetadata foreignTable = EntityStaticMetadata.get(property.getType()).getForeignTableForJoinKey(property.getName(), ((Request)request).entity.getType());
            this.processForeignKey(op, request, property, foreignTable);
        }
    }

    private void processForeignTables(Operation op, R request) {
        for (PropertyStaticMetadata foreignTable : EntityStaticMetadata.get(((Request)request).entity.getType()).getForeignTables()) {
            MutableObject foreignFieldValue;
            EntityMetadata foreignEntityType = op.lcClient.getRequiredEntity(foreignTable.getTypeOrCollectionElementType());
            PropertyMetadata fkProperty = foreignEntityType.getRequiredPersistentProperty(foreignTable.getForeignTableAnnotation().joinKey());
            try {
                foreignFieldValue = ((Request)request).entity.getState().getForeignTableField(((Request)request).entity.getEntity(), foreignTable);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to get foreign table field", e);
            }
            this.processForeignTableField(op, request, foreignTable, foreignFieldValue, fkProperty);
        }
    }

    protected abstract <T> R createRequest(EntityInstance<T> var1);

    protected abstract boolean doProcess(Operation var1, R var2);

    protected abstract void processForeignKey(Operation var1, R var2, PropertyMetadata var3, @Nullable PropertyStaticMetadata var4);

    protected abstract void processForeignTableField(Operation var1, R var2, PropertyStaticMetadata var3, @Nullable MutableObject<?> var4, PropertyMetadata var5);

    private <T> R addRequest(Operation op, EntityInstance<T> instance) {
        Map map = this.requests.computeIfAbsent((instance = op.cache.getOrSetInstance(instance)).getMetadata(), e -> new HashMap());
        Request r = (Request)map.get(instance.getEntity());
        if (r == null) {
            r = this.createRequest(instance);
            map.put(instance.getEntity(), r);
        }
        return (R)r;
    }

    @Override
    protected Mono<Void> executeRequests(Operation op) {
        LinkedList<Mono<Void>> executions = new LinkedList<Mono<Void>>();
        for (Map.Entry<EntityMetadata, Map<Object, R>> entity : this.requests.entrySet()) {
            LinkedList<Request> ready = new LinkedList<Request>();
            for (Request request : entity.getValue().values()) {
                if (!this.canExecuteRequest(request)) continue;
                ready.add(request);
            }
            if (ready.isEmpty()) continue;
            Mono<Void> execution = this.doRequests(op, entity.getKey(), ready);
            if (execution != null) {
                executions.add((Mono<Void>)execution.doOnSuccess(v -> ready.forEach(r -> {
                    r.executed = true;
                })));
                continue;
            }
            ready.forEach(r -> {
                r.executed = true;
            });
        }
        return Operation.executeParallel(executions);
    }

    protected abstract Mono<Void> doRequests(Operation var1, EntityMetadata var2, List<R> var3);

    static abstract class Request
    extends AbstractProcessor.Request {
        EntityInstance<?> entity;
        boolean processed = false;
        boolean toProcess = true;

        <T> Request(EntityInstance<T> entity) {
            this.entity = entity;
        }

        @Override
        protected boolean canExecute() {
            return this.processed && super.canExecute();
        }

        @Override
        protected boolean isDone() {
            return !this.toProcess || super.isDone();
        }
    }
}

