/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.JoinTable;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PropertyStaticMetadata {
    private static final String ATTRIBUTE1 = "entity1";
    private static final String ATTRIBUTE2 = "entity2";
    private Field field;
    private ForeignKey foreignKeyAnnotation;
    private ForeignTable foreignTableAnnotation;
    private JoinTable joinTableAnnotation;
    private PropertyStaticMetadata joinForeignTable;
    private String joinSourceFieldName;
    private String joinTargetFieldName;
    private boolean isCollection;
    private Class<?> collectionElementType;

    PropertyStaticMetadata(Field field) {
        this.field = field;
        field.setAccessible(true);
        this.foreignKeyAnnotation = field.getAnnotation(ForeignKey.class);
        this.foreignTableAnnotation = field.getAnnotation(ForeignTable.class);
        this.joinTableAnnotation = field.getAnnotation(JoinTable.class);
        this.isCollection = ModelUtils.isCollection(field);
        if (this.isCollection) {
            this.collectionElementType = ModelUtils.getRequiredCollectionType(field);
        }
    }

    void setJoinForeignTable(PropertyStaticMetadata joinForeignTable) {
        this.joinForeignTable = joinForeignTable;
        if (joinForeignTable.getForeignTableAnnotation().joinKey().equals(ATTRIBUTE1)) {
            this.joinSourceFieldName = ATTRIBUTE1;
            this.joinTargetFieldName = ATTRIBUTE2;
        } else {
            this.joinSourceFieldName = ATTRIBUTE2;
            this.joinTargetFieldName = ATTRIBUTE1;
        }
    }

    @NonNull
    public String getName() {
        return this.field.getName();
    }

    @NonNull
    public Field getField() {
        return this.field;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    @NonNull
    public Class<?> getType() {
        return this.field.getType();
    }

    @NonNull
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Nullable
    public Class<?> getCollectionElementType() {
        return this.collectionElementType;
    }

    @NonNull
    public Class<?> getTypeOrCollectionElementType() {
        return this.isCollection ? this.collectionElementType : this.getType();
    }

    public boolean isForeignKey() {
        return this.foreignKeyAnnotation != null;
    }

    public ForeignKey getForeignKeyAnnotation() {
        return this.foreignKeyAnnotation;
    }

    public boolean isForeignTable() {
        return this.foreignTableAnnotation != null;
    }

    public ForeignTable getForeignTableAnnotation() {
        return this.foreignTableAnnotation;
    }

    public boolean isJoinTable() {
        return this.joinTableAnnotation != null;
    }

    public JoinTable getJoinTableAnnotation() {
        return this.joinTableAnnotation;
    }

    public PropertyStaticMetadata getJoinTableForeignTable() {
        return this.joinForeignTable;
    }

    public String getJoinTableSourceFieldName() {
        return this.joinSourceFieldName;
    }

    public String getJoinTableTargetFieldName() {
        return this.joinTargetFieldName;
    }
}

