/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model.metadata;

import java.lang.reflect.Type;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PropertyMetadata {
    private EntityMetadata entity;
    private PropertyStaticMetadata meta;
    private RelationalPersistentProperty property;

    PropertyMetadata(EntityMetadata entity, PropertyStaticMetadata meta) {
        this.entity = entity;
        this.meta = meta;
        this.property = (RelationalPersistentProperty)entity.getSpringMetadata().getPersistentProperty(meta.getName());
    }

    @NonNull
    public String getName() {
        return this.meta.getName();
    }

    @NonNull
    public Class<?> getType() {
        return this.meta.getType();
    }

    @NonNull
    public Type getGenericType() {
        return this.meta.getGenericType();
    }

    @NonNull
    public EntityMetadata getEntity() {
        return this.entity;
    }

    @NonNull
    public PropertyStaticMetadata getStaticMetadata() {
        return this.meta;
    }

    @Nullable
    public RelationalPersistentProperty getSpringProperty() {
        return this.property;
    }

    @NonNull
    public RelationalPersistentProperty getRequiredSpringProperty() {
        if (this.property != null) {
            return this.property;
        }
        throw new ModelAccessException("Property " + this.getName() + " is not a persistent property");
    }

    @NonNull
    public LcReactiveDataRelationalClient getClient() {
        return this.entity.getClient();
    }

    public boolean isPersistent() {
        return this.property != null && !this.property.isTransient();
    }

    public boolean isWritable() {
        return this.property != null && this.property.isWritable();
    }

    public boolean isForeignKey() {
        return this.meta.isForeignKey();
    }

    public ForeignKey getForeignKeyAnnotation() {
        return this.meta.getForeignKeyAnnotation();
    }

    public EntityMetadata getForeignKeyEntityMetadata() {
        return this.entity.getClient().getRequiredEntity(this.getType());
    }

    public boolean isForeignTable() {
        return this.meta.isForeignTable();
    }

    public ForeignTable getForeignTableAnnotation() {
        return this.meta.getForeignTableAnnotation();
    }

    public boolean isCollection() {
        return this.meta.isCollection();
    }

    public boolean isGeneratedValue() {
        return this.property != null && this.property.isAnnotationPresent(GeneratedValue.class);
    }

    @NonNull
    public GeneratedValue.Strategy getGeneratedValueStrategy() {
        return ((GeneratedValue)this.property.getRequiredAnnotation(GeneratedValue.class)).strategy();
    }

    @Nullable
    public GeneratedValue getGeneratedValueAnnotation() {
        if (this.property == null) {
            return null;
        }
        return (GeneratedValue)this.property.findAnnotation(GeneratedValue.class);
    }

    @NonNull
    public GeneratedValue getRequiredGeneratedValueAnnotation() {
        return (GeneratedValue)this.property.getRequiredAnnotation(GeneratedValue.class);
    }

    public boolean isId() {
        return this.property != null && this.property.isIdProperty();
    }

    public boolean isVersion() {
        return this.property != null && this.property.isVersionProperty();
    }

    public boolean isCreatedDate() {
        return this.property != null && this.property.isAnnotationPresent(CreatedDate.class);
    }

    public boolean isLastModifiedDate() {
        return this.property != null && this.property.isAnnotationPresent(LastModifiedDate.class);
    }

    public SqlIdentifier getColumnName() {
        return this.property.getColumnName();
    }

    public boolean isUpdatable() {
        if (this.property == null) {
            return false;
        }
        if (!this.property.isWritable()) {
            return false;
        }
        if (this.property.isIdProperty()) {
            return false;
        }
        ColumnDefinition def = (ColumnDefinition)this.property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            return def.updatable();
        }
        return true;
    }

    public boolean isNullable() {
        if (this.property.getRawType().isPrimitive()) {
            return false;
        }
        if (this.property.isIdProperty()) {
            return false;
        }
        ForeignKey fk = (ForeignKey)this.property.findAnnotation(ForeignKey.class);
        if (fk != null) {
            return fk.optional();
        }
        ColumnDefinition def = (ColumnDefinition)this.property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            return def.nullable();
        }
        return true;
    }
}

