/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model.metadata;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Transient;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class EntityStaticMetadata {
    private static final Map<Class<?>, EntityStaticMetadata> cache = new HashMap();
    private Class<?> type;
    private Field stateField;
    private CompositeId compositeId;
    private Map<String, PropertyStaticMetadata> properties = new HashMap<String, PropertyStaticMetadata>();
    private List<PropertyStaticMetadata> foreignKeys = new LinkedList<PropertyStaticMetadata>();
    private List<PropertyStaticMetadata> foreignTables = new LinkedList<PropertyStaticMetadata>();
    private List<PropertyStaticMetadata> joinTables = new LinkedList<PropertyStaticMetadata>();

    public static void setClasses(Collection<Class<?>> classes) throws ModelException {
        for (Class<?> cl : classes) {
            cache.put(cl, new EntityStaticMetadata(cl));
        }
    }

    public static EntityStaticMetadata get(Class<?> clazz) {
        EntityStaticMetadata info = cache.get(clazz);
        if (info == null) {
            throw new ModelAccessException("Unknown entity class " + clazz.getName() + ", known classes are: " + cache.keySet());
        }
        return info;
    }

    public static Collection<Class<?>> getClasses() {
        return cache.keySet();
    }

    public static Collection<Class<?>> addGeneratedJoinTables(Collection<Class<?>> classes) {
        HashSet result = new HashSet(classes);
        for (Class<?> c : classes) {
            EntityStaticMetadata info = EntityStaticMetadata.get(c);
            for (PropertyStaticMetadata joinTable : info.joinTables) {
                Class<?> type = joinTable.getJoinTableForeignTable().getTypeOrCollectionElementType();
                result.add(type);
            }
        }
        return result;
    }

    private EntityStaticMetadata(Class<?> clazz) throws ModelException {
        this.type = clazz;
        try {
            this.stateField = clazz.getDeclaredField("_lcState");
            this.stateField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ModelException("Unable to access to state field for entity class " + clazz.getName());
        }
        this.compositeId = clazz.getAnnotation(CompositeId.class);
        List<Field> fields = ModelUtils.getAllFields(clazz);
        for (Field f : fields) {
            if (f.isAnnotationPresent(Transient.class) || f.isAnnotationPresent(Autowired.class) || f.isAnnotationPresent(Value.class)) continue;
            PropertyStaticMetadata property = new PropertyStaticMetadata(f);
            this.properties.put(f.getName(), property);
            if (property.isForeignTable()) {
                this.foreignTables.add(property);
                continue;
            }
            if (!property.isForeignKey()) continue;
            this.foreignKeys.add(property);
        }
        for (PropertyStaticMetadata p : this.properties.values()) {
            if (!p.isJoinTable()) continue;
            PropertyStaticMetadata joinForeignTable = this.properties.get(p.getName() + "_join");
            if (joinForeignTable == null) {
                throw new ModelAccessException("@JoinTable without corresponding @ForeignTable");
            }
            p.setJoinForeignTable(joinForeignTable);
            this.joinTables.add(p);
        }
        if (this.compositeId != null) {
            for (Iterator<Object> iterator : this.compositeId.properties()) {
                if (this.properties.containsKey(iterator)) continue;
                throw new ModelAccessException("CompositeId property " + iterator + " does not exist on class " + clazz.getName());
            }
        }
    }

    @NonNull
    public Field getStateField() {
        return this.stateField;
    }

    @NonNull
    public Collection<PropertyStaticMetadata> getProperties() {
        return this.properties.values();
    }

    @Nullable
    public PropertyStaticMetadata getProperty(String name) {
        return this.properties.get(name);
    }

    @NonNull
    public PropertyStaticMetadata getRequiredProperty(String name) {
        PropertyStaticMetadata p = this.properties.get(name);
        if (p != null) {
            return p;
        }
        throw new ModelAccessException("Unknown property " + name + " in " + this.type.getName());
    }

    public boolean hasCompositeId() {
        return this.compositeId != null;
    }

    @Nullable
    public CompositeId getCompositeId() {
        return this.compositeId;
    }

    @NonNull
    public CompositeId getRequiredCompositeId() {
        if (this.compositeId == null) {
            throw new ModelAccessException("Entity " + this.type.getName() + " doesn't have a @CompositeId");
        }
        return this.compositeId;
    }

    public boolean hasForeignTable() {
        return !this.foreignTables.isEmpty();
    }

    public boolean hasJoinTable() {
        return !this.joinTables.isEmpty();
    }

    public List<PropertyStaticMetadata> getForeignKeys() {
        return Collections.unmodifiableList(this.foreignKeys);
    }

    public List<PropertyStaticMetadata> getForeignTables() {
        return Collections.unmodifiableList(this.foreignTables);
    }

    @Nullable
    public PropertyStaticMetadata getForeignTableForJoinKey(String joinKey, Class<?> targetType) {
        for (PropertyStaticMetadata p : this.foreignTables) {
            if (!p.getForeignTableAnnotation().joinKey().equals(joinKey) || !p.getTypeOrCollectionElementType().equals(targetType)) continue;
            return p;
        }
        return null;
    }

    public <T> Collection<T> getJoinTableElementsForJoinTableClass(Object instance, Class<T> joinTableClass) {
        for (PropertyStaticMetadata jt : this.joinTables) {
            Field field = jt.getJoinTableForeignTable().getField();
            if (!ModelUtils.getCollectionType(field).equals(joinTableClass)) continue;
            try {
                return (Collection)field.get(instance);
            }
            catch (Exception e) {
                throw new ModelAccessException("Error accessing join table elements " + joinTableClass.getName() + " from " + instance, e);
            }
        }
        return null;
    }
}

