/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.metadata.EntityStaticMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import net.lecousin.reactive.data.relational.util.Iterables;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class EntityMetadata {
    @NonNull
    private LcReactiveDataRelationalClient client;
    @NonNull
    private EntityStaticMetadata meta;
    @NonNull
    private RelationalPersistentEntity<?> entity;
    private Map<String, PropertyMetadata> properties = new HashMap<String, PropertyMetadata>();
    private PropertyMetadata idProperty;
    private PropertyMetadata versionProperty;

    public EntityMetadata(@NonNull LcReactiveDataRelationalClient client, @NonNull RelationalPersistentEntity<?> entity) {
        this.client = client;
        this.entity = entity;
        this.meta = EntityStaticMetadata.get(entity.getType());
        for (PropertyStaticMetadata property : this.meta.getProperties()) {
            this.properties.put(property.getName(), new PropertyMetadata(this, property));
        }
        if (entity.hasIdProperty()) {
            this.idProperty = this.properties.get(((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName());
        }
        if (entity.hasVersionProperty()) {
            this.versionProperty = this.properties.get(((RelationalPersistentProperty)entity.getRequiredVersionProperty()).getName());
        }
    }

    @NonNull
    public String getName() {
        return this.entity.getName();
    }

    @NonNull
    public LcReactiveDataRelationalClient getClient() {
        return this.client;
    }

    @NonNull
    public EntityStaticMetadata getStaticMetadata() {
        return this.meta;
    }

    @NonNull
    public RelationalPersistentEntity<?> getSpringMetadata() {
        return this.entity;
    }

    @NonNull
    public Class<?> getType() {
        return this.entity.getType();
    }

    @Nullable
    public PropertyMetadata getProperty(String name) {
        return this.properties.get(name);
    }

    @NonNull
    public PropertyMetadata getRequiredProperty(String name) {
        PropertyMetadata p = this.properties.get(name);
        if (p != null) {
            return p;
        }
        throw new ModelAccessException("Unknown property " + name + " in " + this.getName());
    }

    @NonNull
    public Collection<PropertyMetadata> getProperties() {
        return this.properties.values();
    }

    @NonNull
    public Iterable<PropertyMetadata> getPersistentProperties() {
        return Iterables.filter(this.properties.values(), PropertyMetadata::isPersistent);
    }

    @NonNull
    public PropertyMetadata getRequiredPersistentProperty(String name) {
        PropertyMetadata p = this.getRequiredProperty(name);
        if (!p.isPersistent()) {
            throw new ModelAccessException("Property " + name + " is not persistent (no corresponding column in the table) on class " + this.getType().getName());
        }
        return p;
    }

    public Iterable<PropertyMetadata> getForeignKeys() {
        return Iterables.filter(this.properties.values(), PropertyMetadata::isForeignKey);
    }

    @NonNull
    public PropertyMetadata getRequiredForeignTableProperty(String name) {
        PropertyMetadata p = this.getRequiredProperty(name);
        if (!p.isForeignTable()) {
            throw new ModelAccessException("Property " + name + " is not a @ForeignTable on class " + this.getType().getName());
        }
        return p;
    }

    public Iterable<PropertyMetadata> getGeneratedValues() {
        return Iterables.filter(this.properties.values(), PropertyMetadata::isGeneratedValue);
    }

    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    @Nullable
    public PropertyMetadata getIdProperty() {
        return this.idProperty;
    }

    @NonNull
    public PropertyMetadata getRequiredIdProperty() {
        if (this.idProperty != null) {
            return this.idProperty;
        }
        throw new ModelAccessException("Entity " + this.getName() + " does not have an @Id property");
    }

    public boolean hasCompositeId() {
        return this.meta.hasCompositeId();
    }

    @Nullable
    public CompositeId getCompositeIdAnnotation() {
        return (CompositeId)this.entity.findAnnotation(CompositeId.class);
    }

    @NonNull
    public CompositeId getRequiredCompositeId() {
        return this.meta.getRequiredCompositeId();
    }

    public List<PropertyMetadata> getCompositeIdProperties() {
        String[] names = this.meta.getRequiredCompositeId().properties();
        ArrayList<PropertyMetadata> list = new ArrayList<PropertyMetadata>(names.length);
        for (String name : names) {
            list.add(this.properties.get(name));
        }
        return list;
    }

    @NonNull
    public SqlIdentifier getTableName() {
        return this.entity.getTableName();
    }

    public boolean hasVersionProperty() {
        return this.versionProperty != null;
    }

    @Nullable
    public PropertyMetadata getVersionProperty() {
        return this.versionProperty;
    }

    @NonNull
    public PropertyMetadata getRequiredVersionProperty() {
        if (this.versionProperty != null) {
            return this.versionProperty;
        }
        throw new ModelAccessException("Entity " + this.getName() + " does not have a @Version property");
    }
}

