/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model.metadata;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.CompositeIdValue;
import net.lecousin.reactive.data.relational.model.InvalidEntityStateException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.util.Iterables;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class EntityInstance<T> {
    private T instance;
    private EntityState state;
    private PersistentPropertyAccessor<T> accessor;
    private EntityMetadata meta;

    public EntityInstance(@NonNull T instance, @NonNull EntityState state) {
        this.instance = instance;
        this.state = state;
        this.meta = state.getMetadata();
    }

    @NonNull
    public T getEntity() {
        return this.instance;
    }

    @NonNull
    public EntityState getState() {
        return this.state;
    }

    @NonNull
    public PersistentPropertyAccessor<T> getPropertyAccessor() {
        if (this.accessor == null) {
            this.accessor = this.meta.getSpringMetadata().getPropertyAccessor(this.instance);
        }
        return this.accessor;
    }

    @NonNull
    public Class<?> getType() {
        return this.meta.getType();
    }

    @NonNull
    public EntityMetadata getMetadata() {
        return this.meta;
    }

    public Object getValue(PropertyMetadata property) {
        if (property.isPersistent()) {
            return this.getPropertyAccessor().getProperty((PersistentProperty)property.getRequiredSpringProperty());
        }
        return ModelUtils.getFieldValue(this.instance, property.getStaticMetadata().getField());
    }

    public Object getDatabaseValue(String propertyName) {
        return this.getDatabaseValue(this.meta.getRequiredProperty(propertyName));
    }

    public Object getDatabaseValue(PropertyMetadata property) {
        Object value = ModelUtils.getFieldValue(this.instance, property.getStaticMetadata().getField());
        if (value == null) {
            return null;
        }
        if (property.isForeignKey()) {
            return this.getForeignKeyValue(property, value);
        }
        value = this.state.getClient().getSchemaDialect().convertToDataBase(value, property);
        return value;
    }

    public void setValue(PropertyMetadata property, Object value) {
        if (property.isPersistent()) {
            this.getPropertyAccessor().setProperty((PersistentProperty)property.getRequiredSpringProperty(), value);
        } else {
            ModelUtils.setFieldValue(this.instance, property.getStaticMetadata().getField(), value);
        }
    }

    @Nullable
    public Object getId() {
        if (this.meta.hasIdProperty()) {
            return this.getIdPropertyValue();
        }
        if (this.meta.hasCompositeId()) {
            return this.getIdFromProperties(this.meta.getCompositeIdProperties());
        }
        return this.getIdFromProperties(this.meta.getPersistentProperties());
    }

    @Nullable
    public Object getIdPropertyValue() {
        return this.getPropertyAccessor().getProperty((PersistentProperty)this.meta.getRequiredIdProperty().getRequiredSpringProperty());
    }

    private CompositeIdValue getIdFromProperties(Iterable<PropertyMetadata> properties) {
        CompositeIdValue id = new CompositeIdValue();
        for (PropertyMetadata property : properties) {
            id.add(property.getName(), this.getDatabaseValue(property));
        }
        return id;
    }

    @NonNull
    public Object getRequiredPrimaryKey() {
        Object id = this.getValue(this.meta.getRequiredIdProperty());
        if (id == null) {
            throw new InvalidEntityStateException("Entity is supposed to be persisted to database, but it's Id property is null");
        }
        return id;
    }

    public boolean isPersistedForeignKey(PropertyMetadata fkProperty, Object foreignInstance) {
        Object persisted = this.state.getPersistedValue(fkProperty.getName());
        if (foreignInstance == null) {
            return persisted == null;
        }
        if (persisted == null) {
            return false;
        }
        return Objects.equals(this.getForeignKeyValue(fkProperty, persisted), this.getForeignKeyValue(fkProperty, foreignInstance));
    }

    public Object getForeignKeyValue(PropertyMetadata fkProperty, Object foreignInstance) {
        if (foreignInstance == null) {
            return null;
        }
        EntityMetadata fkType = fkProperty.getForeignKeyEntityMetadata();
        return ModelUtils.getFieldValue(foreignInstance, fkType.getRequiredIdProperty().getStaticMetadata().getField());
    }

    public Criteria getCriteriaOnId(String entityName) {
        if (this.meta.hasIdProperty()) {
            return this.getCriteriaOnProperties(entityName, Arrays.asList(this.meta.getRequiredIdProperty().getName()));
        }
        if (this.meta.hasCompositeId()) {
            return this.getCriteriaOnProperties(entityName, Arrays.asList(this.meta.getRequiredCompositeId().properties()));
        }
        return this.getCriteriaOnProperties(entityName, Iterables.map(this.meta.getPersistentProperties(), PropertyMetadata::getName));
    }

    private Criteria getCriteriaOnProperties(String entityName, Iterable<String> properties) {
        Iterator<String> it = properties.iterator();
        Criteria condition = null;
        do {
            String propertyName;
            Object value;
            Criteria propertyCondition = (value = this.getDatabaseValue(propertyName = it.next())) != null ? Criteria.property(entityName, propertyName).is(value) : Criteria.property(entityName, propertyName).isNull();
            Criteria criteria = condition = condition != null ? condition.and(propertyCondition) : propertyCondition;
        } while (it.hasNext());
        return condition;
    }

    public Condition getConditionOnId(SqlQuery<?> query) {
        if (this.meta.hasIdProperty()) {
            return this.getConditionOnProperties(query, Arrays.asList(this.meta.getRequiredIdProperty()));
        }
        if (this.meta.hasCompositeId()) {
            return this.getConditionOnProperties(query, this.meta.getCompositeIdProperties());
        }
        return this.getConditionOnProperties(query, this.meta.getPersistentProperties());
    }

    private Condition getConditionOnProperties(SqlQuery<?> query, Iterable<PropertyMetadata> properties) {
        Iterator<PropertyMetadata> it = properties.iterator();
        Comparison condition = null;
        Table table = Table.create((SqlIdentifier)this.meta.getTableName());
        do {
            PropertyMetadata property = it.next();
            Object value = this.getDatabaseValue(property);
            Comparison propertyCondition = Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)(value != null ? query.marker(value) : SQL.nullLiteral()));
            Object object = condition = condition != null ? condition.and((Condition)propertyCondition) : propertyCondition;
        } while (it.hasNext());
        return condition;
    }
}

