/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import net.lecousin.reactive.data.relational.model.ModelAccessException;

public class PrimitiveArraysUtil {
    private PrimitiveArraysUtil() {
    }

    public static Object primitiveArrayToObjectArray(Object primitiveArray) {
        Class<?> primitiveType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(primitiveType)) {
            boolean[] values = (boolean[])primitiveArray;
            Boolean[] nonPrimitive = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = values[i];
            }
            return nonPrimitive;
        }
        if (Short.TYPE.equals(primitiveType)) {
            short[] values = (short[])primitiveArray;
            Short[] nonPrimitive = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = values[i];
            }
            return nonPrimitive;
        }
        if (Long.TYPE.equals(primitiveType)) {
            long[] values = (long[])primitiveArray;
            Long[] nonPrimitive = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = values[i];
            }
            return nonPrimitive;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            int[] values = (int[])primitiveArray;
            Integer[] nonPrimitive = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = values[i];
            }
            return nonPrimitive;
        }
        if (Float.TYPE.equals(primitiveType)) {
            float[] values = (float[])primitiveArray;
            Float[] nonPrimitive = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = Float.valueOf(values[i]);
            }
            return nonPrimitive;
        }
        if (Double.TYPE.equals(primitiveType)) {
            double[] values = (double[])primitiveArray;
            Double[] nonPrimitive = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                nonPrimitive[i] = values[i];
            }
            return nonPrimitive;
        }
        throw new ModelAccessException("Primitive array not supported: " + primitiveArray.getClass());
    }

    public static Collection<?> primitiveArrayToCollection(Object primitiveArray) {
        Class<?> primitiveType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(primitiveType)) {
            boolean[] primitives = (boolean[])primitiveArray;
            ArrayList<Boolean> list = new ArrayList<Boolean>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            return list;
        }
        if (Short.TYPE.equals(primitiveType)) {
            short[] primitives = (short[])primitiveArray;
            ArrayList<Short> list = new ArrayList<Short>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            return list;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            int[] primitives = (int[])primitiveArray;
            ArrayList<Integer> list = new ArrayList<Integer>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            return list;
        }
        if (Long.TYPE.equals(primitiveType)) {
            long[] primitives = (long[])primitiveArray;
            ArrayList<Long> list = new ArrayList<Long>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            return list;
        }
        if (Float.TYPE.equals(primitiveType)) {
            float[] primitives = (float[])primitiveArray;
            ArrayList<Float> list = new ArrayList<Float>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(Float.valueOf(primitives[i]));
            }
            return list;
        }
        if (Double.TYPE.equals(primitiveType)) {
            double[] primitives = (double[])primitiveArray;
            ArrayList<Double> list = new ArrayList<Double>(primitives.length);
            for (int i = 0; i < primitives.length; ++i) {
                list.add(primitives[i]);
            }
            return list;
        }
        throw new ModelAccessException("Primitive array not supported: " + primitiveArray.getClass());
    }

    public static Object objectArrayToPrimitiveArray(Object array, Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            Boolean[] a = (Boolean[])array;
            boolean[] b = new boolean[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
            return b;
        }
        if (Short.TYPE.equals(primitiveType)) {
            Short[] a = (Short[])array;
            short[] b = new short[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
            return b;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            Integer[] a = (Integer[])array;
            int[] b = new int[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
            return b;
        }
        if (Long.TYPE.equals(primitiveType)) {
            Long[] a = (Long[])array;
            long[] b = new long[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
            return b;
        }
        if (Float.TYPE.equals(primitiveType)) {
            Float[] a = (Float[])array;
            float[] b = new float[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i].floatValue();
            }
            return b;
        }
        if (Double.TYPE.equals(primitiveType)) {
            Double[] a = (Double[])array;
            double[] b = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
            return b;
        }
        throw new ModelAccessException("Primitive array not supported: " + primitiveType);
    }
}

