/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.metadata.EntityStaticMetadata;

public class JoinTableCollectionFromTargetCollection<J, T>
implements Collection<J> {
    private Object sourceInstance;
    private Class<J> joinClass;
    private Set<T> targetCollection;
    private Field sourceField;
    private Field targetField;
    private Collection<J> originalCollection;

    public JoinTableCollectionFromTargetCollection(Object sourceInstance, Collection<J> originalCollection, Set<T> targetCollection, String joinClassName, int sourceAttributeLinkNumber) {
        this.sourceInstance = sourceInstance;
        this.targetCollection = targetCollection;
        this.originalCollection = originalCollection != null ? new ArrayList<J>(originalCollection) : new ArrayList(0);
        try {
            this.joinClass = this.getClass().getClassLoader().loadClass(joinClassName);
            this.sourceField = this.joinClass.getDeclaredField("entity" + sourceAttributeLinkNumber);
            this.sourceField.setAccessible(true);
            this.targetField = this.joinClass.getDeclaredField("entity" + (sourceAttributeLinkNumber == 1 ? 2 : 1));
            this.targetField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ModelAccessException("Error initializing JoinTableCollectionFromTargetCollection on " + joinClassName, e);
        }
    }

    private J getOriginalOrCreate(T target) {
        for (Object join : this.originalCollection) {
            try {
                if (!Objects.equals(this.targetField.get(join), target)) continue;
                return join;
            }
            catch (Exception exception) {
            }
        }
        Collection<J> col = EntityStaticMetadata.get(target.getClass()).getJoinTableElementsForJoinTableClass(target, this.joinClass);
        if (col != null) {
            if (col instanceof JoinTableCollectionFromTargetCollection) {
                col = ((JoinTableCollectionFromTargetCollection)col).originalCollection;
            }
            for (Object join : col) {
                try {
                    if (!Objects.equals(this.sourceField.get(join), this.sourceInstance)) continue;
                    this.originalCollection.add(join);
                    return (J)join;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            Object join;
            join = this.joinClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sourceField.set(join, this.sourceInstance);
            this.targetField.set(join, target);
            this.originalCollection.add(join);
            return join;
        }
        catch (Exception e) {
            throw new ModelAccessException("Error creating join entity " + this.joinClass.getName(), e);
        }
    }

    @Override
    public int size() {
        return this.targetCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetCollection.isEmpty();
    }

    @Override
    public void clear() {
        this.targetCollection.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || !this.joinClass.equals(o.getClass())) {
            return false;
        }
        try {
            if (this.sourceField.get(o) != this.sourceInstance) {
                return false;
            }
            return this.targetCollection.contains(this.targetField.get(o));
        }
        catch (Exception e) {
            throw new ModelAccessException("Error accessing field from " + o);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<J> iterator() {
        final Iterator<T> it = this.targetCollection.iterator();
        return new Iterator<J>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public J next() {
                return JoinTableCollectionFromTargetCollection.this.getOriginalOrCreate(it.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((R[])new Object[this.size()]);
    }

    @Override
    public <R> R[] toArray(R[] a) {
        if (a.length < this.targetCollection.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.targetCollection.size());
        }
        int i = 0;
        for (J e : this) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public boolean add(J e) {
        try {
            Object target = this.targetField.get(e);
            if (this.targetCollection.contains(target)) {
                return false;
            }
            this.originalCollection.add(e);
            this.targetCollection.add(target);
            return true;
        }
        catch (Exception err) {
            throw new ModelAccessException("Error adding join " + this.joinClass.getName(), err);
        }
    }

    @Override
    public boolean addAll(Collection<? extends J> c) {
        boolean result = false;
        for (J e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        try {
            return this.targetCollection.remove(this.targetField.get(o));
        }
        catch (Exception e) {
            throw new ModelAccessException("Error removing join " + this.joinClass.getName(), e);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object e : c) {
            result |= this.remove(e);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            try {
                list.add(this.targetField.get(o));
            }
            catch (Exception e) {
                throw new ModelAccessException("Error getting " + this.targetField.getName() + " from " + o, e);
            }
        }
        return this.targetCollection.retainAll(list);
    }
}

