/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mapping;

import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.model.EntityCache;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LcEntityReader {
    private static final Log logger = LogFactory.getLog(LcEntityReader.class);
    private CustomConversions conversions;
    private ConversionService conversionService;
    private EntityCache cache;
    private LcReactiveDataRelationalClient client;

    public LcEntityReader(@Nullable EntityCache cache, @Nullable CustomConversions conversions, LcReactiveDataRelationalClient client) {
        this.cache = cache != null ? cache : new EntityCache();
        R2dbcConverter converter = client.getDataAccess().getConverter();
        if (conversions != null) {
            this.conversions = conversions;
        } else if (converter instanceof BasicRelationalConverter) {
            this.conversions = ((BasicRelationalConverter)converter).getConversions();
        } else {
            throw new IllegalArgumentException("No conversions");
        }
        this.conversionService = converter.getConversionService();
        this.client = client;
    }

    public LcEntityReader(@Nullable EntityCache cache, LcMappingR2dbcConverter converter) {
        this(cache, converter.getConversions(), converter.getLcClient());
    }

    public EntityCache getCache() {
        return this.cache;
    }

    public <T> T read(Class<T> type, PropertiesSource source) {
        Class<?> sourceType;
        ClassTypeInformation typeInfo = ClassTypeInformation.from(type);
        Class rawType = typeInfo.getType();
        if (rawType.isAssignableFrom(sourceType = source.getSource().getClass())) {
            return (T)source.getSource();
        }
        if (this.conversions.hasCustomReadTarget(sourceType, rawType) && this.conversionService.canConvert(sourceType, rawType)) {
            return (T)this.conversionService.convert(source.getSource(), rawType);
        }
        return this.read(this.client.getRequiredEntity(type), source).getEntity();
    }

    public <T> EntityInstance<T> read(EntityMetadata entityType, PropertiesSource source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read <" + source.getSource() + "> into " + entityType.getName()));
        }
        EntityInstance<T> result = this.getOrCreateInstance(entityType, source);
        if (entityType.getSpringMetadata().requiresPropertyPopulation()) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(result.getPropertyAccessor(), this.conversionService);
            for (RelationalPersistentProperty property : entityType.getSpringMetadata()) {
                if (entityType.getSpringMetadata().isConstructorArgument((PersistentProperty)property)) continue;
                MutableObject<Object> value = this.readProperty(property, source, result.getEntity(), property.getTypeInformation().getType());
                if (value != null) {
                    propertyAccessor.setProperty((PersistentProperty)property, value.getValue());
                    continue;
                }
                if (!property.isIdProperty() && !ModelUtils.isPropertyPartOfCompositeId(property)) continue;
                throw new MappingException("Property " + entityType.getName() + "." + property.getName() + " must be returned by the query to be mapped");
            }
        }
        result.getState().loaded(result.getEntity());
        return result;
    }

    protected MutableObject<Object> readProperty(RelationalPersistentProperty property, PropertiesSource source, Object instance, Class<?> targetType) {
        if (property.isEntity()) {
            return this.readEntityProperty(property, instance, source);
        }
        if (!source.isPropertyPresent(property)) {
            return null;
        }
        Object value = source.getPropertyValue(property);
        return new MutableObject(this.readValue(value, targetType));
    }

    public Object readValue(@Nullable Object value, Class<?> type) {
        if (null == value) {
            return null;
        }
        value = this.client.getSchemaDialect().convertFromDataBase(value, type);
        if (this.conversions.hasCustomReadTarget(value.getClass(), type)) {
            return this.conversionService.convert(value, type);
        }
        if (value instanceof String && char[].class.equals(type)) {
            return ((String)value).toCharArray();
        }
        return this.getPotentiallyConvertedSimpleRead(value, type);
    }

    @Nullable
    protected Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    protected <T> MutableObject<T> readEntityProperty(RelationalPersistentProperty property, Object parentInstance, PropertiesSource source) {
        EntityMetadata entityType = this.client.getRequiredEntity(property.getActualType());
        if (property.isAnnotationPresent(ForeignKey.class)) {
            return this.readForeignKeyEntity(property, parentInstance, entityType, source);
        }
        throw new MappingException("Sub-entity without @ForeignKey is not supported: " + property.getName());
    }

    protected <T> MutableObject<T> readForeignKeyEntity(RelationalPersistentProperty property, Object parentInstance, EntityMetadata entityType, PropertiesSource source) {
        if (!source.isPropertyPresent(property)) {
            return null;
        }
        Object value = source.getPropertyValue(property);
        if (value == null) {
            return new MutableObject(null);
        }
        EntityInstance<T> instance = this.getOrCreateInstance(entityType, source, value);
        EntityState state = instance.getState();
        if (!state.isLoaded()) {
            instance.setValue(entityType.getRequiredIdProperty(), value);
        }
        if (parentInstance != null) {
            ModelUtils.setReverseLink(instance.getEntity(), parentInstance, property);
        }
        if (!state.isLoaded()) {
            state.lazyLoaded();
        }
        return new MutableObject(instance.getEntity());
    }

    protected <T> EntityInstance<T> getOrCreateInstance(EntityMetadata entityType, PropertiesSource source) {
        Object id;
        try {
            id = ModelUtils.getId(entityType.getSpringMetadata(), source);
        }
        catch (Exception e) {
            id = null;
        }
        return this.getOrCreateInstance(entityType, source, id);
    }

    protected <T> EntityInstance<T> getOrCreateInstance(EntityMetadata entityType, PropertiesSource source, Object id) {
        EntityInstance<?> instance;
        if (id != null && (instance = this.cache.getInstanceById(entityType.getType(), id)) != null) {
            return instance;
        }
        PropertiesSourceParameterValueProvider parameterValueProvider = new PropertiesSourceParameterValueProvider(entityType.getSpringMetadata(), source);
        Object entity = this.client.getMapper().createInstance((PersistentEntity)entityType.getSpringMetadata(), parameterValueProvider::getParameterValue);
        EntityInstance<Object> instance2 = this.client.getInstance(entity);
        if (id != null) {
            this.cache.setInstanceById(id, instance2);
        }
        return instance2;
    }

    public class PropertiesSourceParameterValueProvider
    implements ParameterValueProvider<RelationalPersistentProperty> {
        private final RelationalPersistentEntity<?> entityType;
        private final PropertiesSource source;

        public PropertiesSourceParameterValueProvider(RelationalPersistentEntity<?> entityType, PropertiesSource source) {
            this.entityType = entityType;
            this.source = source;
        }

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            String paramName = parameter.getName();
            Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.entityType.getPersistentProperty(paramName);
            if (property == null) {
                return null;
            }
            Class type = parameter.getType().getType();
            MutableObject<Object> value = LcEntityReader.this.readProperty(property, this.source, null, type);
            if (value == null) {
                return null;
            }
            Object v = value.getValue();
            if (type.isInstance(v)) {
                return type.cast(v);
            }
            return (T)LcEntityReader.this.conversionService.convert(v, type);
        }
    }
}

