/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.enhance;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyStaticMetadata;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EntityState {
    private EntityMetadata entityType;
    private boolean persisted = false;
    private boolean loaded = false;
    private Mono<?> loading = null;
    private Map<String, Object> persistedValues = new HashMap<String, Object>();
    private Map<String, CorePublisher<?>> foreignTablesLoaded = new HashMap();
    private static final String ENTITY_ALIAS = "entity";

    public EntityState(@NonNull EntityMetadata entityType) {
        this.entityType = entityType;
    }

    public static EntityState get(@NonNull Object entity, @NonNull LcReactiveDataRelationalClient client) {
        return EntityState.get(entity, client.getRequiredEntity(entity.getClass()));
    }

    public static EntityState get(@NonNull Object entity, @NonNull EntityMetadata entityType) {
        try {
            Field fieldInfo = entityType.getStaticMetadata().getStateField();
            EntityState state = (EntityState)fieldInfo.get(entity);
            if (state == null) {
                state = new EntityState(entityType);
                fieldInfo.set(entity, state);
            }
            return state;
        }
        catch (Exception e) {
            throw new ModelAccessException("Unexpected error accessing entity state for " + entity, e);
        }
    }

    public EntityMetadata getMetadata() {
        return this.entityType;
    }

    public LcReactiveDataRelationalClient getClient() {
        return this.entityType.getClient();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Nullable
    public Object getPersistedValue(String fieldName) {
        return this.persistedValues.get(fieldName);
    }

    public void deleted() {
        this.persisted = false;
        this.loaded = false;
        this.loading = null;
        this.persistedValues.clear();
        this.foreignTablesLoaded.clear();
    }

    public void lazyLoaded() {
        this.persisted = true;
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public synchronized <T> Mono<EntityInstance<T>> loading(EntityInstance<T> instance, Supplier<Mono<EntityInstance<T>>> doLoading) {
        if (this.loading != null) {
            return this.loading;
        }
        if (this.loaded) {
            return Mono.just(instance);
        }
        this.loading = doLoading.get().doOnSuccess(entity -> {
            if (entity == null) {
                this.deleted();
            } else {
                this.loaded(entity.getEntity());
            }
            this.loading = null;
        }).cache();
        return this.loading;
    }

    @Nullable
    public <T> Mono<T> getLoading() {
        return this.loading;
    }

    public <T> void loaded(T entity) {
        this.persisted = true;
        this.loaded = true;
        this.updatePersistedValues(entity);
    }

    private void updatePersistedValues(Object entity) {
        this.persistedValues.clear();
        for (PropertyMetadata property : this.entityType.getProperties()) {
            Field f = property.getStaticMetadata().getField();
            try {
                this.savePersistedValue(f, f.get(entity));
            }
            catch (Exception e) {
                throw new ModelAccessException("Error saving value for field " + f.getName(), e);
            }
        }
    }

    private void savePersistedValue(Field field, Object value) {
        if (value != null && ModelUtils.isCollection(field)) {
            LinkedList list = new LinkedList();
            list.addAll(ModelUtils.getAsCollection(value));
            this.persistedValues.put(field.getName(), list);
        } else {
            this.persistedValues.put(field.getName(), value);
        }
    }

    public <T> Mono<T> load(T entity) {
        return this.entityType.getClient().lazyLoad(entity);
    }

    public void restorePersistedValue(Object instance, PropertyStaticMetadata property) {
        Field field = property.getField();
        ModelUtils.setFieldValue(instance, field, this.persistedValues.get(field.getName()));
    }

    public void setForeignTableField(Object instance, PropertyStaticMetadata property, Object value) {
        Field field = property.getField();
        ModelUtils.setFieldValue(instance, field, value);
        this.foreignTablesLoaded.put(field.getName(), null);
    }

    @Nullable
    public <T> MutableObject<T> getForeignTableField(Object entity, PropertyStaticMetadata property) throws IllegalAccessException {
        Field field = property.getField();
        Object instance = field.get(entity);
        if (instance != null) {
            return new MutableObject(instance);
        }
        String name = field.getName();
        if (this.foreignTablesLoaded.containsKey(name) || this.persistedValues.containsKey(name) && this.persistedValues.get(name) != null) {
            return new MutableObject(null);
        }
        return null;
    }

    public <T> Mono<T> lazyGetForeignTableField(Object entity, String fieldName, String joinKey) {
        try {
            CorePublisher<?> foreignLoading = this.foreignTablesLoaded.get(fieldName);
            if (foreignLoading != null) {
                return (Mono)foreignLoading;
            }
            PropertyMetadata property = this.entityType.getRequiredProperty(fieldName);
            MutableObject<T> instance = this.getForeignTableField(entity, property.getStaticMetadata());
            if (instance != null) {
                return instance.getValue() != null ? Mono.just((Object)instance.getValue()) : Mono.empty();
            }
            Field field = property.getStaticMetadata().getField();
            EntityInstance<Object> entityInstance = new EntityInstance<Object>(entity, this);
            Object id = entityInstance.getId();
            LcReactiveDataRelationalClient client = this.getClient();
            PropertyMetadata fkProperty = client.getRequiredEntity(field.getType()).getRequiredProperty(joinKey);
            Mono select = SelectQuery.from(field.getType(), ENTITY_ALIAS).where(Criteria.property(ENTITY_ALIAS, fkProperty.getName()).is(id)).execute(client).next().doOnNext(inst -> {
                ModelUtils.setFieldValue(entity, field, inst);
                this.savePersistedValue(field, inst);
                ModelUtils.setFieldValue(inst, fkProperty.getStaticMetadata().getField(), entity);
            });
            select = select.cache();
            this.foreignTablesLoaded.put(fieldName, (CorePublisher<?>)select);
            return select;
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Flux<T> lazyGetForeignTableCollectionField(Object entity, String fieldName, String joinKey) {
        try {
            CorePublisher<?> foreignLoading = this.foreignTablesLoaded.get(fieldName);
            if (foreignLoading != null) {
                return (Flux)foreignLoading;
            }
            PropertyMetadata property = this.entityType.getRequiredProperty(fieldName);
            MutableObject<T> instance = this.getForeignTableField(entity, property.getStaticMetadata());
            if (instance != null) {
                if (instance.getValue() == null) {
                    return Flux.empty();
                }
                Object collection = instance.getValue();
                if (collection.getClass().isArray()) {
                    return Flux.fromArray((Object[])((Object[])collection));
                }
                return Flux.fromIterable((Iterable)((Iterable)collection));
            }
            Field field = property.getStaticMetadata().getField();
            EntityInstance<Object> entityInstance = new EntityInstance<Object>(entity, this);
            Object id = entityInstance.getId();
            Class<?> elementType = ModelUtils.getCollectionType(field);
            if (elementType == null) {
                throw new MappingException("Property is not a collection: " + fieldName);
            }
            LcReactiveDataRelationalClient client = this.getClient();
            PropertyMetadata fkProperty = client.getRequiredEntity(elementType).getRequiredProperty(joinKey);
            Flux<?> flux = SelectQuery.from(elementType, "element").where(Criteria.property("element", fkProperty.getName()).is(id)).execute(client);
            Field fk = fkProperty.getStaticMetadata().getField();
            flux = field.getType().isArray() ? EntityState.toArray(flux, field, entity, elementType, fk) : this.toCollection(flux, field, entity, elementType, fk);
            flux = flux.cache();
            this.foreignTablesLoaded.put(fieldName, (CorePublisher<?>)flux);
            return flux;
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public <T> Flux<T> lazyGetJoinTableField(Object entity, String joinFieldName, int joinFieldKeyNumber) {
        return this.lazyGetForeignTableCollectionField(entity, joinFieldName + "_join", ENTITY_ALIAS + joinFieldKeyNumber).map(joinEntity -> {
            try {
                Field f = joinEntity.getClass().getDeclaredField(ENTITY_ALIAS + joinFieldKeyNumber);
                f.setAccessible(true);
                return f.get(joinEntity);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to access to join table property", e);
            }
        });
    }

    private static <T> Flux<T> toArray(Flux<T> flux, Field field, Object entity, Class<?> elementType, Field fk) {
        return flux.collectList().flatMapMany(list -> {
            Object[] array = list.toArray((Object[])Array.newInstance(elementType, list.size()));
            try {
                field.set(entity, array);
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
            for (Object element : list) {
                try {
                    fk.set(element, entity);
                }
                catch (Exception e) {
                    throw new ModelAccessException("Unable to set field " + fk.getName(), e);
                }
            }
            return Flux.fromIterable((Iterable)list);
        });
    }

    private <T> Flux<T> toCollection(Flux<T> flux, Field field, Object entity, Class<?> elementType, Field fk) throws IllegalAccessException {
        Collection col = CollectionFactory.createCollection(field.getType(), elementType, (int)10);
        field.set(entity, col);
        flux = flux.doOnNext(element -> {
            ((Collection)col).add(element);
            try {
                fk.set(element, entity);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to set field " + fk.getName(), e);
            }
        });
        flux = flux.doOnComplete(() -> this.savePersistedValue(field, col));
        return flux;
    }

    public void foreignTableLoaded(Field field, Object value) {
        this.foreignTablesLoaded.put(field.getName(), null);
        this.savePersistedValue(field, value);
    }

    public <T, R> Function<T, R> getFieldMapper(String fieldName) {
        try {
            PropertyMetadata property = this.entityType.getRequiredProperty(fieldName);
            return e -> ModelUtils.getFieldValue(e, property.getStaticMetadata().getField());
        }
        catch (Exception e2) {
            throw new ModelAccessException("Unable to access field " + fieldName, e2);
        }
    }
}

