/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.mapping.LcReactiveDataAccessStrategy;
import net.lecousin.reactive.data.relational.model.EntityCache;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.EntityStaticMetadata;
import net.lecousin.reactive.data.relational.query.SelectExecution;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaBuilderFromEntities;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Component
public class LcReactiveDataRelationalClient {
    public static final Log logger = LogFactory.getLog(LcReactiveDataRelationalClient.class);
    private static final String QUERY_ENTITY_NAME = "entity";
    private DatabaseClient client;
    private RelationalDatabaseSchemaDialect schemaDialect;
    private LcReactiveDataAccessStrategy dataAccess;
    private LcMappingR2dbcConverter mapper;
    private Map<Class<?>, EntityMetadata> entities;

    public LcReactiveDataRelationalClient(DatabaseClient client, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext, RelationalDatabaseSchemaDialect schemaDialect, LcReactiveDataAccessStrategy dataAccess, LcMappingR2dbcConverter mapper) {
        this.client = client;
        this.schemaDialect = schemaDialect;
        this.dataAccess = dataAccess;
        this.mapper = mapper;
        this.mapper.setLcClient(this);
        this.entities = new HashMap();
        for (Class<?> type : EntityStaticMetadata.addGeneratedJoinTables(EntityStaticMetadata.getClasses())) {
            RelationalPersistentEntity entity = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(type);
            this.entities.put(entity.getType(), new EntityMetadata(this, entity));
        }
    }

    public DatabaseClient getSpringClient() {
        return this.client;
    }

    public LcMappingR2dbcConverter getMapper() {
        return this.mapper;
    }

    public LcReactiveDataAccessStrategy getDataAccess() {
        return this.dataAccess;
    }

    public RelationalDatabaseSchemaDialect getSchemaDialect() {
        return this.schemaDialect;
    }

    public R2dbcDialect getDialect() {
        return this.dataAccess.getDialect();
    }

    @NonNull
    public EntityMetadata getRequiredEntity(Class<?> type) {
        EntityMetadata entity = this.entities.get(type);
        if (entity == null) {
            throw new ModelAccessException("Unknown entity type: " + type.getName());
        }
        return entity;
    }

    public Collection<EntityMetadata> getEntities() {
        return this.entities.values();
    }

    public Collection<EntityMetadata> getEntities(Collection<Class<?>> types) {
        ArrayList<EntityMetadata> list = new ArrayList<EntityMetadata>(types.size());
        for (Class<?> type : types) {
            list.add(this.getRequiredEntity(type));
        }
        return list;
    }

    public Mono<Void> dropSchemaContent(RelationalDatabaseSchema schema) {
        return this.schemaDialect.dropSchemaContent(schema).execute(this);
    }

    public Mono<Void> createSchemaContent(RelationalDatabaseSchema schema) {
        return this.schemaDialect.createSchemaContent(schema).execute(this);
    }

    public Mono<Void> dropCreateSchemaContent(RelationalDatabaseSchema schema) {
        return this.dropSchemaContent(schema).then(this.createSchemaContent(schema));
    }

    public RelationalDatabaseSchema buildSchemaFromEntities() {
        return this.buildSchemaFromEntities(this.entities.keySet());
    }

    public RelationalDatabaseSchema buildSchemaFromEntities(Collection<Class<?>> classes) {
        return SchemaBuilderFromEntities.build(this.getEntities(EntityStaticMetadata.addGeneratedJoinTables(classes)));
    }

    public <T> Mono<T> save(T entity) {
        try {
            EntityInstance<T> instance = this.getInstance(entity);
            Operation op = new Operation(this);
            op.addToSave(instance);
            return op.execute().thenReturn(entity);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Flux<T> save(Iterable<T> entities) {
        try {
            Iterator<T> it = entities.iterator();
            if (!it.hasNext()) {
                return Flux.empty();
            }
            T entity = it.next();
            EntityInstance<T> instance = this.getInstance(entity);
            Operation op = new Operation(this);
            op.addToSave(instance);
            while (it.hasNext()) {
                op.addToSave(this.getInstance(it.next()));
            }
            return op.execute().thenMany((Publisher)Flux.fromIterable(entities));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public <T> Flux<T> save(Publisher<T> publisher) {
        Operation op = new Operation(this);
        LinkedList list = new LinkedList();
        return Flux.from(publisher).doOnNext(instance -> {
            op.addToSave(this.getInstance(instance));
            list.add(instance);
        }).then(Mono.fromCallable(op::execute)).flatMap(m -> m).thenReturn(list).flatMapMany(Flux::fromIterable);
    }

    public Mono<Void> saveAll(Iterable<Object> entities) {
        Iterator<Object> it = entities.iterator();
        if (!it.hasNext()) {
            return Mono.empty();
        }
        Operation op = new Operation(this);
        do {
            op.addToSave(this.getInstance(it.next()));
        } while (it.hasNext());
        return op.execute();
    }

    public Mono<Void> saveAll(Object ... entities) {
        return this.saveAll(Arrays.asList(entities));
    }

    public <T> EntityInstance<T> getInstance(T entity) {
        return new EntityInstance<T>(entity, EntityState.get(entity, this));
    }

    public <T> Mono<T> lazyLoad(T entity) {
        return this.lazyLoadInstance(this.getInstance(entity)).map(EntityInstance::getEntity);
    }

    public <T> Mono<EntityInstance<T>> lazyLoadInstance(EntityInstance<T> instance) {
        return Mono.fromCallable(() -> instance.getState().loading(instance, () -> this.doLoading(instance))).flatMap(result -> result);
    }

    private <T> Mono<EntityInstance<T>> doLoading(EntityInstance<T> instance) {
        Class<?> type = instance.getEntity().getClass();
        Object id = instance.getId();
        EntityCache cache = new EntityCache();
        cache.setInstanceById(id, instance);
        return SelectQuery.from(type, QUERY_ENTITY_NAME).where(instance.getCriteriaOnId(QUERY_ENTITY_NAME)).limit(0L, 1L).execute(this, new LcEntityReader(cache, this.getMapper())).next().map(read -> instance);
    }

    public <T> Flux<EntityInstance<T>> lazyLoadInstances(Iterable<EntityInstance<T>> entities) {
        LinkedList<Object> alreadyLoading = new LinkedList<Object>();
        LinkedList<EntityInstance<T>> toLoad = new LinkedList<EntityInstance<T>>();
        for (EntityInstance<T> entity : entities) {
            Mono mono = entity.getState().getLoading();
            if (mono != null) {
                alreadyLoading.add(mono.map(e -> entity));
                continue;
            }
            toLoad.add(entity);
        }
        Flux loading = this.doLoading(toLoad).cache();
        for (EntityInstance entityInstance : toLoad) {
            alreadyLoading.add(entityInstance.getState().loading(entityInstance, () -> loading.filter(e -> e.getEntity() == entity.getEntity()).next()));
        }
        return Flux.merge(alreadyLoading);
    }

    private <T> Flux<EntityInstance<T>> doLoading(Iterable<EntityInstance<T>> entities) {
        Iterator<EntityInstance<T>> it = entities.iterator();
        if (!it.hasNext()) {
            return Flux.empty();
        }
        EntityInstance<T> instance = it.next();
        if (!it.hasNext()) {
            return Flux.from(this.doLoading(instance));
        }
        Class<?> type = instance.getEntity().getClass();
        EntityCache cache = new EntityCache();
        Criteria criteria = null;
        while (true) {
            Object id = instance.getId();
            cache.setInstanceById(id, instance);
            Criteria entityCriteria = instance.getCriteriaOnId(QUERY_ENTITY_NAME);
            Criteria criteria2 = criteria = criteria != null ? criteria.or(entityCriteria) : entityCriteria;
            if (!it.hasNext()) break;
            instance = it.next();
        }
        return SelectQuery.from(type, QUERY_ENTITY_NAME).where(criteria).execute(this, new LcEntityReader(cache, this.getMapper())).map(cache::getInstance);
    }

    public <T> Flux<T> execute(SelectQuery<T> query, @Nullable LcEntityReader reader) {
        return new SelectExecution<T>(query, this, reader).execute();
    }

    public Mono<Long> executeCount(SelectQuery<?> query) {
        return new SelectExecution(query, this, null).executeCount();
    }

    public <T> Mono<Void> delete(T entity) {
        try {
            EntityInstance<T> instance = this.getInstance(entity);
            Operation op = new Operation(this);
            op.addToDelete(instance);
            return op.execute();
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Mono<Void> delete(Iterable<T> entities) {
        try {
            Iterator<T> it = entities.iterator();
            if (!it.hasNext()) {
                return Mono.empty();
            }
            T entity = it.next();
            Operation op = new Operation(this);
            op.addToDelete(this.getInstance(entity));
            while (it.hasNext()) {
                op.addToDelete(this.getInstance(it.next()));
            }
            return op.execute();
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Mono<Void> delete(Publisher<T> publisher) {
        return this.delete(publisher, 100, Duration.ofSeconds(1L));
    }

    public <T> Mono<Void> delete(Publisher<T> publisher, int bunchSize, Duration bunchTimeout) {
        return Flux.from(publisher).subscribeOn(Schedulers.parallel()).publishOn(Schedulers.parallel()).bufferTimeout(bunchSize, bunchTimeout).parallel().runOn(Schedulers.parallel(), 1).flatMap(this::delete).then();
    }
}

