/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.simplemodel;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.simplemodel.BooleanTypes;
import net.lecousin.reactive.data.relational.test.simplemodel.BooleanTypesRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.CharacterTypes;
import net.lecousin.reactive.data.relational.test.simplemodel.CharacterTypesRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.CompositeIdEntity;
import net.lecousin.reactive.data.relational.test.simplemodel.DateTypes;
import net.lecousin.reactive.data.relational.test.simplemodel.DateTypesRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.DateTypesWithTimeZone;
import net.lecousin.reactive.data.relational.test.simplemodel.Entity1WithSequence;
import net.lecousin.reactive.data.relational.test.simplemodel.Entity2WithSequence;
import net.lecousin.reactive.data.relational.test.simplemodel.EnumEntity;
import net.lecousin.reactive.data.relational.test.simplemodel.EnumRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.NumericTypes;
import net.lecousin.reactive.data.relational.test.simplemodel.NumericTypesRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.TransactionalService;
import net.lecousin.reactive.data.relational.test.simplemodel.UUIDEntity;
import net.lecousin.reactive.data.relational.test.simplemodel.UUIDEntityRepository;
import net.lecousin.reactive.data.relational.test.simplemodel.UpdatableProperties;
import net.lecousin.reactive.data.relational.test.simplemodel.VersionedEntity;
import net.lecousin.reactive.data.relational.test.simplemodel.VersionedEntityRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
@ComponentScan
public abstract class AbstractTestSimpleModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private BooleanTypesRepository repoBool;
    @Autowired
    private NumericTypesRepository repoNum;
    @Autowired
    private CharacterTypesRepository repoChars;
    @Autowired
    private VersionedEntityRepository repoVersion;
    @Autowired
    private DateTypesRepository repoDate;
    @Autowired
    private UUIDEntityRepository uuidRepo;
    @Autowired
    private EnumRepository enumRepo;
    @Autowired
    private TransactionalService transactionalService;

    @Override
    protected Collection<Class<?>> usedEntities() {
        LinkedList entities = new LinkedList();
        Collections.addAll(entities, BooleanTypes.class, CharacterTypes.class, CompositeIdEntity.class, DateTypes.class, Entity1WithSequence.class, Entity2WithSequence.class, EnumEntity.class, NumericTypes.class, UpdatableProperties.class, UUIDEntity.class, VersionedEntity.class);
        if (this.lcClient.getSchemaDialect().isTimeZoneSupported()) {
            entities.add(DateTypesWithTimeZone.class);
        }
        return entities;
    }

    @Test
    public void testBooleans() {
        BooleanTypes e1 = new BooleanTypes();
        e1.setB1(null);
        e1.setB2(true);
        BooleanTypes e2 = new BooleanTypes();
        e2.setB1(Boolean.TRUE);
        e2.setB2(false);
        this.repoBool.saveAll(Arrays.asList(e1, e2)).collectList().block();
        List list = (List)this.repoBool.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (BooleanTypes e : list) {
            if (e.isB2()) {
                Assertions.assertNull((Object)e.getB1());
                continue;
            }
            Assertions.assertTrue((boolean)e.getB1());
        }
        Assertions.assertNotNull((Object)e1.getId());
        Assertions.assertNotNull((Object)e2.getId());
        list = (List)this.repoBool.page(0, 3).collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        list = (List)this.repoBool.page(1, 3).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        list = (List)this.repoBool.page(2, 3).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repoBool.page(3, 3).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repoBool.page(4, 3).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        e1.setB2(false);
        e2.setB1(null);
        this.repoBool.saveAll(Arrays.asList(e1, e2)).collectList().block();
        list = (List)this.repoBool.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNull((Object)((BooleanTypes)list.get(0)).getB1());
        Assertions.assertFalse((boolean)((BooleanTypes)list.get(0)).isB2());
        Assertions.assertNull((Object)((BooleanTypes)list.get(1)).getB1());
        Assertions.assertFalse((boolean)((BooleanTypes)list.get(1)).isB2());
        e1 = (BooleanTypes)list.get(0);
        e2 = (BooleanTypes)list.get(1);
        e1.setB1(null);
        e1.setB2(true);
        e2.setB1(Boolean.TRUE);
        e2.setB2(false);
        this.repoBool.saveAll(Arrays.asList(e1, e2)).collectList().block();
        list = (List)this.repoBool.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (BooleanTypes e : list) {
            if (e.isB2()) {
                Assertions.assertNull((Object)e.getB1());
                continue;
            }
            Assertions.assertTrue((boolean)e.getB1());
        }
        try {
            this.repoBool.findAllWithoutId().collectList().block();
            throw new AssertionError();
        }
        catch (MappingException mappingException) {
            this.repoBool.delete(e2).block();
            list = (List)this.repoBool.findAll().collectList().block();
            Assertions.assertEquals((int)1, (int)list.size());
            Assertions.assertNull((Object)((BooleanTypes)list.get(0)).getB1());
            Assertions.assertTrue((boolean)((BooleanTypes)list.get(0)).isB2());
            Assertions.assertNotNull((Object)e1.getId());
            Assertions.assertNull((Object)e2.getId());
            this.repoBool.save(e2).block();
            list = (List)this.repoBool.findAll().collectList().block();
            Assertions.assertEquals((int)2, (int)list.size());
            for (BooleanTypes e : list) {
                if (e.isB2()) {
                    Assertions.assertNull((Object)e.getB1());
                    continue;
                }
                Assertions.assertTrue((boolean)e.getB1());
            }
            Long id1 = e1.getId();
            Assertions.assertNotNull((Object)id1);
            Long id2 = e2.getId();
            Assertions.assertNotNull((Object)id2);
            Assertions.assertEquals((int)2, (int)((List)this.repoBool.findAllById(Arrays.asList(id1, id2)).collectList().block()).size());
            Assertions.assertEquals((int)0, (int)((List)this.repoBool.findAllById(new ArrayList(0)).collectList().block()).size());
            Assertions.assertEquals((int)0, (int)((List)this.repoBool.findAllById(Arrays.asList(123456789L)).collectList().block()).size());
            this.repoBool.deleteAll(Arrays.asList(e1, e2)).block();
            list = (List)this.repoBool.findAll().collectList().block();
            Assertions.assertEquals((int)0, (int)list.size());
            Assertions.assertNull((Object)e1.getId());
            Assertions.assertNull((Object)e2.getId());
            Assertions.assertEquals((int)0, (int)((List)this.repoBool.findAllById(Arrays.asList(id1, id2)).collectList().block()).size());
            return;
        }
    }

    @Test
    public void testNumerics() {
        NumericTypes e1 = new NumericTypes();
        e1.setByte1((byte)51);
        e1.setByte2(null);
        e1.setShort1((short)52);
        e1.setShort2(null);
        e1.setInt_1(53);
        e1.setInt_2(null);
        e1.setLong1(54L);
        e1.setLong2(null);
        e1.setFloat1(1.01f);
        e1.setFloat2(null);
        e1.setDouble1(1.02);
        e1.setDouble2(null);
        e1.setBigDec(null);
        NumericTypes e2 = new NumericTypes();
        e2.setByte1((byte)11);
        e2.setByte2((byte)1);
        e2.setShort1((short)12);
        e2.setShort2((short)2);
        e2.setInt_1(13);
        e2.setInt_2(3);
        e2.setLong1(14L);
        e2.setLong2(4L);
        e2.setFloat1(0.01f);
        e2.setFloat2(Float.valueOf(1.1f));
        e2.setDouble1(0.02);
        e2.setDouble2(1.2);
        e2.setBigDec(BigDecimal.ONE);
        this.repoNum.saveAll(Arrays.asList(e1, e2)).collectList().block();
        List list = (List)this.repoNum.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (NumericTypes e : list) {
            if (e.getByte2() == null) {
                Assertions.assertEquals((byte)51, (byte)e.getByte1());
                Assertions.assertEquals((short)52, (short)e.getShort1());
                Assertions.assertNull((Object)e.getShort2());
                Assertions.assertEquals((int)53, (int)e.getInt_1());
                Assertions.assertNull((Object)e.getInt_2());
                Assertions.assertEquals((long)54L, (long)e.getLong1());
                Assertions.assertNull((Object)e.getLong2());
                Assertions.assertEquals((float)1.01f, (float)e.getFloat1());
                Assertions.assertNull((Object)e.getFloat2());
                Assertions.assertEquals((double)1.02, (double)e.getDouble1());
                Assertions.assertNull((Object)e.getDouble2());
                Assertions.assertNull((Object)e.getBigDec());
                continue;
            }
            Assertions.assertEquals((byte)11, (byte)e.getByte1());
            Assertions.assertEquals((byte)1, (Byte)e.getByte2());
            Assertions.assertEquals((short)12, (short)e.getShort1());
            Assertions.assertEquals((short)2, (Short)e.getShort2());
            Assertions.assertEquals((int)13, (int)e.getInt_1());
            Assertions.assertEquals((int)3, (Integer)e.getInt_2());
            Assertions.assertEquals((long)14L, (long)e.getLong1());
            Assertions.assertEquals((long)4L, (Long)e.getLong2());
            Assertions.assertEquals((float)0.01f, (float)e.getFloat1());
            Assertions.assertEquals((float)1.1f, (Float)e.getFloat2());
            Assertions.assertEquals((double)0.02, (double)e.getDouble1());
            Assertions.assertEquals((double)1.2, (Double)e.getDouble2());
            Assertions.assertEquals((double)1.0, (double)e.getBigDec().doubleValue());
        }
        e1.setByte1((byte)-1);
        e1.setByte2((byte)-2);
        e1.setShort1((short)-3);
        e1.setShort2((short)-4);
        e1.setInt_1(-5);
        e1.setInt_2(-6);
        e1.setLong1(-7L);
        e1.setLong2(-8L);
        e1.setFloat1(-9.09f);
        e1.setFloat2(Float.valueOf(-10.1f));
        e1.setDouble1(-11.11);
        e1.setDouble2(-12.12);
        e1.setBigDec(BigDecimal.valueOf(-13.13));
        e2.setByte1((byte)0);
        e2.setByte2(null);
        e2.setShort1((short)0);
        e2.setShort2(null);
        e2.setInt_1(0);
        e2.setInt_2(null);
        e2.setLong1(-1L);
        e2.setLong2(null);
        e2.setFloat1(0.0f);
        e2.setFloat2(null);
        e2.setDouble1(0.0);
        e2.setDouble2(null);
        e2.setBigDec(null);
        this.repoNum.saveAll(Arrays.asList(e1, e2)).collectList().block();
        list = (List)this.repoNum.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (NumericTypes e : list) {
            if (e.getId() == e1.getId()) {
                Assertions.assertEquals((byte)-1, (byte)e.getByte1());
                Assertions.assertEquals((byte)-2, (Byte)e.getByte2());
                Assertions.assertEquals((short)-3, (short)e.getShort1());
                Assertions.assertEquals((short)-4, (Short)e.getShort2());
                Assertions.assertEquals((int)-5, (int)e.getInt_1());
                Assertions.assertEquals((int)-6, (Integer)e.getInt_2());
                Assertions.assertEquals((long)-7L, (long)e.getLong1());
                Assertions.assertEquals((long)-8L, (Long)e.getLong2());
                Assertions.assertEquals((float)-9.09f, (float)e.getFloat1());
                Assertions.assertEquals((float)-10.1f, (Float)e.getFloat2());
                Assertions.assertEquals((double)-11.11, (double)e.getDouble1());
                Assertions.assertEquals((double)-12.12, (Double)e.getDouble2());
                Assertions.assertEquals((double)-13.13, (double)e.getBigDec().doubleValue());
                continue;
            }
            Assertions.assertEquals((Short)e2.getId(), (Short)e.getId());
            Assertions.assertEquals((byte)0, (byte)e.getByte1());
            Assertions.assertNull((Object)e.getByte2());
            Assertions.assertEquals((short)0, (short)e.getShort1());
            Assertions.assertNull((Object)e.getShort2());
            Assertions.assertEquals((int)0, (int)e.getInt_1());
            Assertions.assertNull((Object)e.getInt_2());
            Assertions.assertEquals((long)-1L, (long)e.getLong1());
            Assertions.assertNull((Object)e.getLong2());
            Assertions.assertEquals((float)0.0f, (float)e.getFloat1());
            Assertions.assertNull((Object)e.getFloat2());
            Assertions.assertEquals((double)0.0, (double)e.getDouble1());
            Assertions.assertNull((Object)e.getDouble2());
            Assertions.assertNull((Object)e.getBigDec());
        }
        List rows = (List)this.repoNum.findByLong1(-7L).collectList().block();
        Assertions.assertEquals((int)1, (int)rows.size());
        list = (List)this.repoNum.getAllOnlyWithIdAndLong1().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNull((Object)((NumericTypes)list.get(0)).getBigDec());
        Assertions.assertNull((Object)((NumericTypes)list.get(1)).getBigDec());
        Assertions.assertNotEquals((long)0L, (long)((NumericTypes)list.get(0)).getLong1());
        Assertions.assertNotEquals((long)0L, (long)((NumericTypes)list.get(1)).getLong1());
        List long1List = (List)this.repoNum.getAllLong1().collectList().block();
        Assertions.assertEquals((int)2, (int)long1List.size());
        Assertions.assertTrue((boolean)long1List.contains(-7L));
        Assertions.assertTrue((boolean)long1List.contains(-1L));
        this.repoNum.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repoNum.findAll().collectList().block()).size());
    }

    @Test
    public void testCharacters() {
        StringBuilder longString = new StringBuilder(4600);
        for (int i = 0; i < 4500; ++i) {
            longString.append((char)(97 + i % 20));
        }
        CharacterTypes e1 = new CharacterTypes();
        e1.setC1('p');
        e1.setC2(null);
        e1.setStr(null);
        e1.setChars(null);
        e1.setFixedLengthString("abc");
        e1.setLongString(longString.toString());
        CharacterTypes e2 = new CharacterTypes();
        e2.setC1('\n');
        e2.setC2(Character.valueOf('\u0000'));
        e2.setStr("Hello");
        e2.setChars(new char[]{'W', 'o', 'r', 'l', 'd'});
        e2.setFixedLengthString("abcde");
        e2.setLongString(null);
        this.repoChars.saveAll(Arrays.asList(e1, e2)).collectList().block();
        List list = (List)this.repoChars.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (CharacterTypes e : list) {
            if (e.getC2() == null) {
                Assertions.assertEquals((char)'p', (char)e.getC1());
                Assertions.assertNull((Object)e.getStr());
                Assertions.assertNull((Object)e.getChars());
                Assertions.assertEquals((Object)"abc  ", (Object)e.getFixedLengthString());
                Assertions.assertEquals((Object)longString.toString(), (Object)e.getLongString());
                continue;
            }
            Assertions.assertEquals((char)'\n', (char)e.getC1());
            Assertions.assertEquals((char)'\u0000', (char)e.getC2().charValue());
            Assertions.assertEquals((Object)"Hello", (Object)e.getStr());
            Assertions.assertEquals((Object)"World", (Object)new String(e.getChars()));
            Assertions.assertEquals((Object)"abcde", (Object)e.getFixedLengthString());
            Assertions.assertNull((Object)e.getLongString());
        }
        e1.setC1('\t');
        e1.setC2(Character.valueOf('x'));
        e1.setStr("Test");
        e1.setChars(new char[]{'a', 'b', 'c'});
        e2.setC1('1');
        e2.setC2(null);
        e2.setStr(null);
        e2.setChars(null);
        this.repoChars.saveAll(Arrays.asList(e1, e2)).collectList().block();
        list = (List)this.repoChars.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        for (CharacterTypes e : list) {
            if (e.getId() == e1.getId()) {
                Assertions.assertEquals((char)'\t', (char)e.getC1());
                Assertions.assertEquals((char)'x', (char)e.getC2().charValue());
                Assertions.assertEquals((Object)"Test", (Object)e.getStr());
                Assertions.assertEquals((Object)"abc", (Object)new String(e.getChars()));
                continue;
            }
            Assertions.assertEquals((char)'1', (char)e.getC1());
            Assertions.assertNull((Object)e.getC2());
            Assertions.assertNull((Object)e.getStr());
            Assertions.assertNull((Object)e.getChars());
        }
        this.repoChars.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repoChars.findAll().collectList().block()).size());
    }

    @Test
    public void testStringFunctions() {
        CharacterTypes e1 = new CharacterTypes();
        e1.setStr(null);
        e1.setFixedLengthString("a");
        CharacterTypes e2 = new CharacterTypes();
        e2.setStr("Hello");
        e2.setFixedLengthString("b");
        CharacterTypes e3 = new CharacterTypes();
        e3.setStr("World");
        e3.setFixedLengthString("c");
        this.repoChars.saveAll(Arrays.asList(e1, e2, e3)).collectList().block();
        List list = (List)this.repoChars.findAll().collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        list = (List)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").is((Object)"hello")).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").toLowerCase().is((Object)"hello")).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"Hello", (Object)((CharacterTypes)list.get(0)).getStr());
        list = (List)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").toUpperCase().is((Object)"hello")).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").toUpperCase().is((Object)"HELLO")).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"Hello", (Object)((CharacterTypes)list.get(0)).getStr());
    }

    @Test
    public void testDates() {
        Instant instant = Instant.now();
        instant = instant.truncatedTo(ChronoUnit.MILLIS);
        long epoch = instant.toEpochMilli();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(epoch);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millis = calendar.get(14);
        int nano = millis * 1000000;
        DateTypes entity = new DateTypes();
        entity.setTimeInstant(instant);
        entity.setTimeLocalDate(LocalDate.of(year, month, day));
        entity.setTimeLocalTime(LocalTime.of(hour, minute, second, nano));
        entity.setTimeLocalDateTime(LocalDateTime.of(year, month, day, hour, minute, second, nano));
        entity = (DateTypes)this.repoDate.save(entity).block();
        entity = (DateTypes)this.repoDate.findAll().blockFirst();
        Assertions.assertEquals((long)epoch, (long)entity.getTimeInstant().toEpochMilli());
        Assertions.assertEquals((int)year, (int)entity.getTimeLocalDate().getYear());
        Assertions.assertEquals((int)month, (int)entity.getTimeLocalDate().getMonthValue());
        Assertions.assertEquals((int)day, (int)entity.getTimeLocalDate().getDayOfMonth());
        Assertions.assertEquals((int)hour, (int)entity.getTimeLocalTime().getHour());
        Assertions.assertEquals((int)minute, (int)entity.getTimeLocalTime().getMinute());
        Assertions.assertEquals((int)second, (int)entity.getTimeLocalTime().getSecond());
        Assertions.assertEquals((int)nano, (int)entity.getTimeLocalTime().getNano());
        Assertions.assertEquals((Object)LocalDateTime.of(year, month, day, hour, minute, second, nano), (Object)entity.getTimeLocalDateTime());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToYear().is((Object)year)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToYear().is((Object)(year + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToMonth().is((Object)month)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToMonth().is((Object)(month + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToDayOfMonth().is((Object)calendar.get(5))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToDayOfMonth().is((Object)(calendar.get(5) + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToDayOfYear().is((Object)calendar.get(6))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToDayOfYear().is((Object)(calendar.get(6) + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToHour().is((Object)hour)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToHour().is((Object)(hour + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToMinute().is((Object)minute)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToMinute().is((Object)(minute + 1))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToSecond().is((Object)second)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").timeToSecond().is((Object)(second + 1))).execute(this.lcClient).blockFirst());
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToIsoWeek().is((Object)calendar.get(3))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToIsoWeek().is((Object)(calendar.get(3) + 1))).execute(this.lcClient).blockFirst());
        HashMap<Integer, Integer> isoDow = new HashMap<Integer, Integer>();
        isoDow.put(2, 1);
        isoDow.put(3, 2);
        isoDow.put(4, 3);
        isoDow.put(5, 4);
        isoDow.put(6, 5);
        isoDow.put(7, 6);
        isoDow.put(1, 7);
        Assertions.assertNotNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToIsoDayOfWeek().is(isoDow.get(calendar.get(7)))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(DateTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"timeInstant").dateToIsoDayOfWeek().is((Object)((Integer)isoDow.get(calendar.get(7)) + 1))).execute(this.lcClient).blockFirst());
    }

    @Test
    public void testDatesWithTimzone() {
        Assumptions.assumeTrue((boolean)this.lcClient.getSchemaDialect().isTimeZoneSupported());
        Instant instant = Instant.now();
        instant = instant.truncatedTo(ChronoUnit.MILLIS);
        long epoch = instant.toEpochMilli();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(epoch);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millis = calendar.get(14);
        int nano = millis * 1000000;
        DateTypesWithTimeZone entity = new DateTypesWithTimeZone();
        entity.setTimeOffsetTime(OffsetTime.of(hour, minute, second, nano, ZoneOffset.ofHours(4)));
        entity.setTimeZonedDateTime(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()));
        entity = (DateTypesWithTimeZone)this.lcClient.save((Object)entity).block();
        entity = (DateTypesWithTimeZone)SelectQuery.from(DateTypesWithTimeZone.class, (String)"e").execute(this.lcClient).blockFirst();
        Assertions.assertEquals((Object)OffsetTime.of(hour, minute, second, nano, ZoneOffset.ofHours(4)), (Object)entity.getTimeOffsetTime());
        Assertions.assertEquals((long)ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).toEpochSecond(), (long)entity.getTimeZonedDateTime().toEpochSecond());
    }

    @Test
    public void testVersion() {
        VersionedEntity entity1 = new VersionedEntity();
        entity1.setStr("Hello");
        VersionedEntity entity2 = new VersionedEntity();
        entity2.setStr("World");
        entity2.setVersion(10L);
        long creationDateStart = System.currentTimeMillis();
        List list = (List)this.repoVersion.saveAll(Arrays.asList(entity1, entity2)).collectList().block();
        long creationDateEnd = System.currentTimeMillis();
        Assertions.assertEquals((int)2, (int)list.size());
        entity1 = (VersionedEntity)list.get(0);
        entity2 = (VersionedEntity)list.get(1);
        Assertions.assertNotNull((Object)entity1.getId());
        Assertions.assertEquals((long)1L, (Long)entity1.getVersion());
        Assertions.assertEquals((Object)"Hello", (Object)entity1.getStr());
        Assertions.assertNotNull((Object)entity2.getId());
        Assertions.assertEquals((long)1L, (Long)entity2.getVersion());
        Assertions.assertEquals((Object)"World", (Object)entity2.getStr());
        Assertions.assertTrue((entity1.getCreation() != null && entity1.getCreation() >= creationDateStart && entity1.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity1.getCreation()));
        Assertions.assertTrue((entity2.getCreation() != null && entity2.getCreation() >= creationDateStart && entity2.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity2.getCreation()));
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getModification());
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity2.getCreation()), ZoneId.systemDefault()), (Object)entity2.getModification());
        Assertions.assertEquals((Long)entity1.getCreation(), (long)entity1.getCreationInstant().toEpochMilli());
        Assertions.assertEquals((Object)LocalDate.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getCreationLocalDate());
        Assertions.assertEquals((Object)LocalTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getCreationLocalTime());
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getCreationLocalDateTime());
        Long id1 = entity1.getId();
        Long id2 = entity2.getId();
        list = (List)this.repoVersion.findAll().collectList().block();
        entity1 = list.stream().filter(e -> id1.equals(e.getId())).findFirst().get();
        entity2 = list.stream().filter(e -> id2.equals(e.getId())).findFirst().get();
        Assertions.assertEquals((long)1L, (Long)entity1.getVersion());
        Assertions.assertEquals((Object)"Hello", (Object)entity1.getStr());
        Assertions.assertEquals((long)1L, (Long)entity2.getVersion());
        Assertions.assertEquals((Object)"World", (Object)entity2.getStr());
        Assertions.assertTrue((entity1.getCreation() != null && entity1.getCreation() >= creationDateStart && entity1.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity1.getCreation()));
        Assertions.assertTrue((entity2.getCreation() != null && entity2.getCreation() >= creationDateStart && entity2.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity2.getCreation()));
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getModification());
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity2.getCreation()), ZoneId.systemDefault()), (Object)entity2.getModification());
        entity2.setStr("World !");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        list = (List)this.repoVersion.saveAll(Arrays.asList(entity1, entity2)).collectList().block();
        entity1 = list.stream().filter(e -> id1.equals(e.getId())).findFirst().get();
        entity2 = list.stream().filter(e -> id2.equals(e.getId())).findFirst().get();
        Assertions.assertEquals((long)1L, (Long)entity1.getVersion());
        Assertions.assertEquals((Object)"Hello", (Object)entity1.getStr());
        Assertions.assertEquals((long)2L, (Long)entity2.getVersion());
        Assertions.assertEquals((Object)"World !", (Object)entity2.getStr());
        Assertions.assertTrue((entity1.getCreation() != null && entity1.getCreation() >= creationDateStart && entity1.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity1.getCreation()));
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getModification());
        Assertions.assertTrue((entity2.getCreation() != null && entity2.getCreation() >= creationDateStart && entity2.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity2.getCreation()));
        Assertions.assertTrue((entity2.getCreation() < entity2.getModification().toInstant(ZoneOffset.UTC).toEpochMilli() ? 1 : 0) != 0);
        list = (List)this.repoVersion.findAll().collectList().block();
        entity1 = list.stream().filter(e -> id1.equals(e.getId())).findFirst().get();
        entity2 = list.stream().filter(e -> id2.equals(e.getId())).findFirst().get();
        Assertions.assertEquals((long)1L, (Long)entity1.getVersion());
        Assertions.assertEquals((Object)"Hello", (Object)entity1.getStr());
        Assertions.assertEquals((long)2L, (Long)entity2.getVersion());
        Assertions.assertEquals((Object)"World !", (Object)entity2.getStr());
        Assertions.assertTrue((entity1.getCreation() != null && entity1.getCreation() >= creationDateStart && entity1.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity1.getCreation()));
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(entity1.getCreation()), ZoneId.systemDefault()), (Object)entity1.getModification());
        Assertions.assertTrue((entity2.getCreation() != null && entity2.getCreation() >= creationDateStart && entity2.getCreation() <= creationDateEnd ? 1 : 0) != 0, (String)("Creation date: " + entity2.getCreation()));
        Assertions.assertTrue((entity2.getCreation() < entity2.getModification().toInstant(ZoneOffset.UTC).toEpochMilli() ? 1 : 0) != 0);
        entity2.setVersion(1L);
        entity2.setStr("World");
        try {
            list = (List)this.repoVersion.saveAll(Arrays.asList(entity1, entity2)).collectList().block();
            throw new AssertionError((Object)"Error expected when saving entity with wrong version");
        }
        catch (OptimisticLockingFailureException optimisticLockingFailureException) {
            return;
        }
    }

    @Test
    public void testCriteria() {
        NumericTypes e1 = new NumericTypes();
        e1.setByte1((byte)51);
        e1.setByte2(null);
        e1.setShort1((short)52);
        e1.setShort2(null);
        e1.setInt_1(13);
        e1.setInt_2(null);
        e1.setLong1(54L);
        e1.setLong2(null);
        e1.setFloat1(1.01f);
        e1.setFloat2(null);
        e1.setDouble1(1.02);
        e1.setDouble2(null);
        e1.setBigDec(null);
        NumericTypes e2 = new NumericTypes();
        e2.setByte1((byte)11);
        e2.setByte2((byte)1);
        e2.setShort1((short)12);
        e2.setShort2((short)2);
        e2.setInt_1(13);
        e2.setInt_2(1);
        e2.setLong1(14L);
        e2.setLong2(4L);
        e2.setFloat1(0.01f);
        e2.setFloat2(Float.valueOf(0.01f));
        e2.setDouble1(0.02);
        e2.setDouble2(1.2);
        e2.setBigDec(null);
        this.repoNum.saveAll(Arrays.asList(e1, e2)).collectList().block();
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").is((Object)51)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").is((Object)52)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"float1").is("e", "float2")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte2").is("e", "short1")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").isNot((Object)51)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").isNot((Object)13)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte2").isNot("e", "short2")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte2").isNot("e", "int_2")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").greaterThan((Object)20)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").greaterThan((Object)13)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").greaterThan("e", "int_1")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_2").greaterThan("e", "byte1")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").greaterOrEqualTo((Object)51)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").greaterOrEqualTo((Object)14)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").greaterOrEqualTo("e", "int_1")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_2").greaterOrEqualTo("e", "byte1")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").lessThan((Object)51)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").lessThan((Object)0)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").lessThan("e", "int_1")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"long1").lessThan("e", "byte1")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").lessOrEqualTo((Object)11)).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").lessOrEqualTo((Object)0)).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").lessOrEqualTo("e", "int_1")).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"long1").lessOrEqualTo("e", "byte1")).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte2").isNull()).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte1").isNull()).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"byte2").isNotNull()).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"bigDec").isNotNull()).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_2").in(Arrays.asList(1, 2, 3))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_2").in(Arrays.asList(40, 50, 60))).execute(this.lcClient).blockFirst());
        Assertions.assertNotNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_2").notIn(Arrays.asList(2, 3, 4))).execute(this.lcClient).blockFirst());
        Assertions.assertNull((Object)SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").notIn(Arrays.asList(12, 13, 14))).execute(this.lcClient).blockFirst());
        try {
            SelectQuery.from(NumericTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"int_1").is(Arrays.asList(12, 13, 14))).execute(this.lcClient).blockFirst();
            throw new AssertionError();
        }
        catch (Exception exception) {
            try {
                Criteria.PropertyOperation c = new Criteria.PropertyOperation(Criteria.property((String)"e", (String)"int_1"), Criteria.PropertyOperator.IN, (Object)"wrong");
                SelectQuery.from(NumericTypes.class, (String)"e").where((Criteria)c).execute(this.lcClient).blockFirst();
                throw new AssertionError();
            }
            catch (Exception c) {
                CharacterTypes c2 = new CharacterTypes();
                c2.setStr("Hello World");
                c2.setLongString("Hello World");
                c2.setFixedLengthString("Hello");
                this.repoChars.save(c2).block();
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like((Object)"%lo%")).execute(this.lcClient).blockFirst());
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like((Object)"Hello%")).execute(this.lcClient).blockFirst());
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like((Object)"%World")).execute(this.lcClient).blockFirst());
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like((Object)"%o%")).execute(this.lcClient).blockFirst());
                Assertions.assertNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like((Object)"%la%")).execute(this.lcClient).blockFirst());
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").notLike((Object)"%la%")).execute(this.lcClient).blockFirst());
                Assertions.assertNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").like("e", "fixedLengthString")).execute(this.lcClient).blockFirst());
                Assertions.assertNotNull((Object)SelectQuery.from(CharacterTypes.class, (String)"e").where(Criteria.property((String)"e", (String)"str").notLike("e", "fixedLengthString")).execute(this.lcClient).blockFirst());
                return;
            }
        }
    }

    @Test
    public void testUpdatableProperties() {
        UpdatableProperties entity = new UpdatableProperties();
        entity.setStr1("1.1");
        entity.setStr2("2.1");
        entity.setStr3("3.1");
        entity.setStr4("4.1");
        entity = (UpdatableProperties)this.lcClient.save((Object)entity).block();
        Assertions.assertEquals((Object)"1.1", (Object)entity.getStr1());
        Assertions.assertEquals((Object)"2.1", (Object)entity.getStr2());
        Assertions.assertEquals((Object)"3.1", (Object)entity.getStr3());
        Assertions.assertEquals((Object)"4.1", (Object)entity.getStr4());
        long id = entity.getId();
        entity.setId(10L);
        entity.setStr1("1.2");
        entity.setStr2("2.2");
        entity.setStr3("3.2");
        entity.setStr4("4.2");
        entity = (UpdatableProperties)this.lcClient.save((Object)entity).block();
        Assertions.assertEquals((long)id, (Long)entity.getId());
        Assertions.assertEquals((Object)"1.2", (Object)entity.getStr1());
        Assertions.assertEquals((Object)"2.2", (Object)entity.getStr2());
        Assertions.assertEquals((Object)"3.1", (Object)entity.getStr3());
        Assertions.assertEquals((Object)"4.1", (Object)entity.getStr4());
        entity = (UpdatableProperties)SelectQuery.from(UpdatableProperties.class, (String)"entity").execute(this.lcClient).blockFirst();
        Assertions.assertEquals((long)id, (Long)entity.getId());
        Assertions.assertEquals((Object)"1.2", (Object)entity.getStr1());
        Assertions.assertEquals((Object)"2.2", (Object)entity.getStr2());
        Assertions.assertEquals((Object)"3.1", (Object)entity.getStr3());
        Assertions.assertEquals((Object)"4.1", (Object)entity.getStr4());
    }

    @Test
    public void testSequence() {
        Assumptions.assumeTrue((boolean)this.lcClient.getSchemaDialect().supportsSequence());
        Entity1WithSequence e = new Entity1WithSequence();
        e.setValue("test");
        e = (Entity1WithSequence)this.lcClient.save((Object)e).block();
        Assertions.assertNotNull((Object)e.getId());
    }

    @Test
    public void test2EntitiesWithSameSequence() {
        Assumptions.assumeTrue((boolean)this.lcClient.getSchemaDialect().supportsSequence());
        Entity1WithSequence e1_1 = new Entity1WithSequence();
        e1_1.setValue("1.1");
        Entity1WithSequence e1_2 = new Entity1WithSequence();
        e1_2.setValue("1.2");
        Entity2WithSequence e2_1 = new Entity2WithSequence();
        e2_1.setValue("2.1");
        Entity2WithSequence e2_2 = new Entity2WithSequence();
        e2_2.setValue("2.2");
        List list1 = (List)this.lcClient.save(Arrays.asList(e1_1, e1_2)).collectList().block();
        Assertions.assertEquals((int)2, (int)list1.size());
        e1_1 = list1.stream().filter(e -> "1.1".equals(e.getValue())).findFirst().get();
        e1_2 = list1.stream().filter(e -> "1.2".equals(e.getValue())).findFirst().get();
        Assertions.assertTrue((e1_1.getId() < 3L ? 1 : 0) != 0);
        Assertions.assertTrue((e1_2.getId() < 3L ? 1 : 0) != 0);
        if (e1_1.getId() == 1L) {
            Assertions.assertEquals((long)2L, (Long)e1_2.getId());
        } else if (e1_2.getId() == 1L) {
            Assertions.assertEquals((long)2L, (Long)e1_1.getId());
        } else {
            throw new AssertionError();
        }
        List list2 = (List)this.lcClient.save(Arrays.asList(e2_1, e2_2)).collectList().block();
        Assertions.assertEquals((int)2, (int)list2.size());
        e2_1 = list2.stream().filter(e -> "2.1".equals(e.getValue())).findFirst().get();
        e2_2 = list2.stream().filter(e -> "2.2".equals(e.getValue())).findFirst().get();
        Assertions.assertTrue((e2_1.getId() < 5L ? 1 : 0) != 0);
        Assertions.assertTrue((e2_2.getId() < 5L ? 1 : 0) != 0);
        if (e2_1.getId() == 3L) {
            Assertions.assertEquals((long)4L, (Long)e2_2.getId());
        } else if (e2_2.getId() == 3L) {
            Assertions.assertEquals((long)4L, (Long)e2_1.getId());
        } else {
            throw new AssertionError();
        }
    }

    @Test
    public void testSpringClient() {
        BooleanTypes e = new BooleanTypes();
        e.setB1(Boolean.TRUE);
        e.setB2(false);
        OutboundRow row = this.lcClient.getDataAccess().getOutboundRow((Object)e);
        Assertions.assertEquals((int)3, (int)row.keySet().size());
        UpdatableProperties e2 = new UpdatableProperties();
        e2.setId(1L);
        e2.setStr1("s1");
        e2.setStr2("s2");
        e2.setStr3("s3");
        e2.setStr4("s4");
        row = this.lcClient.getDataAccess().getOutboundRow((Object)e2);
        Assertions.assertEquals((int)4, (int)row.keySet().size());
    }

    @Test
    public void testUUID() {
        HashMap<Integer, UUID> uuids = new HashMap<Integer, UUID>();
        for (int i = 0; i < 10; ++i) {
            uuids.put(i, UUID.randomUUID());
        }
        List entities = (List)this.lcClient.save((Publisher)Flux.fromIterable(uuids.entrySet()).map(entry -> {
            UUIDEntity e = new UUIDEntity();
            e.setUuidNonKey((UUID)entry.getValue());
            e.setI((Integer)entry.getKey());
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        HashMap<Integer, UUID> keys = new HashMap<Integer, UUID>();
        for (UUIDEntity e : entities) {
            Assertions.assertNotNull((Object)e.getUuidKey());
            Assertions.assertFalse((boolean)keys.containsKey(e.getI()));
            Assertions.assertFalse((boolean)keys.containsValue(e.getUuidKey()));
            keys.put(e.getI(), e.getUuidKey());
            Assertions.assertEquals(uuids.get(e.getI()), (Object)e.getUuidNonKey());
        }
        entities = (List)SelectQuery.from(UUIDEntity.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        keys = new HashMap();
        for (UUIDEntity e : entities) {
            Assertions.assertNotNull((Object)e.getUuidKey());
            Assertions.assertFalse((boolean)keys.containsKey(e.getI()));
            Assertions.assertFalse((boolean)keys.containsValue(e.getUuidKey()));
            keys.put(e.getI(), e.getUuidKey());
            Assertions.assertEquals(uuids.get(e.getI()), (Object)e.getUuidNonKey());
            UUID newUuid = UUID.randomUUID();
            e.setUuidNonKey(newUuid);
            uuids.put(e.getI(), newUuid);
        }
        this.lcClient.save((Iterable)entities).collectList().block();
        entities = (List)this.uuidRepo.findAll().collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        keys = new HashMap();
        for (UUIDEntity e : entities) {
            Assertions.assertNotNull((Object)e.getUuidKey());
            Assertions.assertFalse((boolean)keys.containsKey(e.getI()));
            Assertions.assertFalse((boolean)keys.containsValue(e.getUuidKey()));
            keys.put(e.getI(), e.getUuidKey());
            Assertions.assertEquals(uuids.get(e.getI()), (Object)e.getUuidNonKey());
        }
        Assertions.assertTrue((boolean)((Boolean)this.uuidRepo.existsById(((UUIDEntity)entities.get(0)).getUuidKey()).block()));
        Assertions.assertTrue((boolean)((Boolean)this.uuidRepo.existsById((Publisher)Mono.just((Object)((UUIDEntity)entities.get(0)).getUuidKey())).block()));
        Assertions.assertFalse((boolean)((Boolean)this.uuidRepo.existsById(UUID.randomUUID()).block()));
        Assertions.assertFalse((boolean)((Boolean)this.uuidRepo.existsById((Publisher)Mono.just((Object)UUID.randomUUID())).block()));
        Assertions.assertNotNull((Object)this.uuidRepo.findById(((UUIDEntity)entities.get(0)).getUuidKey()).block());
        Assertions.assertNotNull((Object)this.uuidRepo.findById((Publisher)Mono.just((Object)((UUIDEntity)entities.get(0)).getUuidKey())).block());
        Assertions.assertNull((Object)this.uuidRepo.findById(UUID.randomUUID()).block());
        Assertions.assertNull((Object)this.uuidRepo.findById((Publisher)Mono.just((Object)UUID.randomUUID())).block());
        entities = (List)this.uuidRepo.findAllById((Publisher)Flux.fromIterable((Iterable)entities).map(UUIDEntity::getUuidKey)).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        entities = (List)this.uuidRepo.findAllById((Publisher)Flux.fromIterable(entities.subList(2, 5)).map(UUIDEntity::getUuidKey).concatWithValues((Object[])new UUID[]{UUID.randomUUID()})).collectList().block();
        Assertions.assertEquals((int)3, (int)entities.size());
        entities = (List)this.uuidRepo.findAll().collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        entities = (List)this.uuidRepo.findAllById(entities.stream().map(UUIDEntity::getUuidKey).collect(Collectors.toList())).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        ArrayList<UUID> idsList = new ArrayList<UUID>(5);
        idsList.add(UUID.randomUUID());
        idsList.add(((UUIDEntity)entities.get(1)).getUuidKey());
        idsList.add(UUID.randomUUID());
        idsList.add(((UUIDEntity)entities.get(6)).getUuidKey());
        idsList.add(UUID.randomUUID());
        entities = (List)this.uuidRepo.findAllById(idsList).collectList().block();
        Assertions.assertEquals((int)2, (int)entities.size());
        entities = (List)this.uuidRepo.findAll().collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        this.lcClient.delete((Iterable)entities).block();
        entities = (List)SelectQuery.from(UUIDEntity.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = (List)this.lcClient.save((Publisher)Flux.fromIterable(uuids.entrySet()).map(entry -> {
            UUIDEntity e = new UUIDEntity();
            e.setUuidNonKey((UUID)entry.getValue());
            e.setI((Integer)entry.getKey());
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        this.uuidRepo.deleteAll().block();
        entities = (List)SelectQuery.from(UUIDEntity.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = (List)this.lcClient.save((Publisher)Flux.fromIterable(uuids.entrySet()).map(entry -> {
            UUIDEntity e = new UUIDEntity();
            e.setUuidNonKey((UUID)entry.getValue());
            e.setI((Integer)entry.getKey());
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        this.uuidRepo.deleteById((Publisher)Flux.fromIterable((Iterable)entities).map(UUIDEntity::getUuidKey)).block();
        entities = (List)SelectQuery.from(UUIDEntity.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = (List)this.lcClient.save((Publisher)Flux.fromIterable(uuids.entrySet()).map(entry -> {
            UUIDEntity e = new UUIDEntity();
            e.setUuidNonKey((UUID)entry.getValue());
            e.setI((Integer)entry.getKey());
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        this.uuidRepo.deleteAllById(entities.stream().map(UUIDEntity::getUuidKey).collect(Collectors.toList())).block();
        entities = (List)SelectQuery.from(UUIDEntity.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)entities.size());
    }

    @Test
    public void testTransactions() {
        CharacterTypes e = (CharacterTypes)this.transactionalService.createCorrectEntity().block();
        Assertions.assertNotNull((Object)e);
        Assertions.assertNotNull((Object)e.getId());
        e = (CharacterTypes)this.repoChars.findAll().blockFirst();
        Assertions.assertNotNull((Object)e);
        Assertions.assertNotNull((Object)e.getId());
        this.transactionalService.deleteEntity(e).block();
        Assertions.assertEquals((int)0, (int)((List)this.repoChars.findAll().collectList().block()).size());
        try {
            this.transactionalService.createCorrectEntityThenInvalidEntity().collectList().block();
            throw new AssertionError();
        }
        catch (Exception exception) {
            Assertions.assertEquals((int)0, (int)((List)this.repoChars.findAll().collectList().block()).size());
            return;
        }
    }

    @Test
    public void testInsertAndDeleteManyEntities() {
        int nb = this.lcClient.getSchemaDialect().isMultipleInsertSupported() ? 1000000 : 1000;
        this.lcClient.save((Publisher)Flux.range((int)0, (int)nb).map(i -> {
            BooleanTypes entity = new BooleanTypes();
            entity.setB1(null);
            entity.setB2(true);
            return entity;
        })).then().block();
        Assertions.assertEquals((long)nb, (Long)((Long)this.repoBool.count().block()));
        this.repoBool.deleteAll().block();
        Assertions.assertEquals((long)0L, (Long)((Long)this.repoBool.count().block()));
    }

    @Test
    public void testDeleteById() {
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            BooleanTypes entity = new BooleanTypes();
            entity.setB1(null);
            entity.setB2(true);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((long)10L, (Long)((Long)this.repoBool.count().block()));
        int nb = 10;
        for (BooleanTypes entity : entities) {
            this.repoBool.deleteById(entity.getId()).block();
            Assertions.assertEquals((long)(--nb), (Long)((Long)this.repoBool.count().block()));
            Assertions.assertTrue((boolean)this.repoBool.findById(entity.getId()).blockOptional().isEmpty());
        }
        Assertions.assertEquals((long)0L, (Long)((Long)this.repoBool.count().block()));
        entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            BooleanTypes entity = new BooleanTypes();
            entity.setB1(null);
            entity.setB2(true);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((long)10L, (Long)((Long)this.repoBool.count().block()));
        this.repoBool.deleteById((Publisher)Flux.fromIterable((Iterable)entities).map(BooleanTypes::getId)).block();
        Assertions.assertEquals((long)0L, (Long)((Long)this.repoBool.count().block()));
    }

    @Test
    public void testCompositeId() {
        int i2;
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            CompositeIdEntity entity = new CompositeIdEntity();
            entity.setId1(Long.valueOf(i / 2));
            entity.setId2("Test" + i % 2);
            entity.setStr("entity" + i);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)SelectQuery.from(CompositeIdEntity.class, (String)"entity").executeCount(this.lcClient).block()));
        entities = (List)SelectQuery.from(CompositeIdEntity.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        for (CompositeIdEntity entity : entities) {
            Assertions.assertTrue((boolean)entity.getStr().startsWith("entity"));
            i2 = Integer.parseInt(entity.getStr().substring(6));
            Assertions.assertEquals((Long)Long.valueOf(i2 / 2), (Long)entity.getId1());
            Assertions.assertEquals((Object)("Test" + i2 % 2), (Object)entity.getId2());
            entity.setStr("updated" + i2);
        }
        this.lcClient.save((Iterable)entities).collectList().block();
        entities = (List)SelectQuery.from(CompositeIdEntity.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        for (CompositeIdEntity entity : entities) {
            Assertions.assertTrue((boolean)entity.getStr().startsWith("updated"));
            i2 = Integer.parseInt(entity.getStr().substring(7));
            Assertions.assertEquals((Long)Long.valueOf(i2 / 2), (Long)entity.getId1());
            Assertions.assertEquals((Object)("Test" + i2 % 2), (Object)entity.getId2());
        }
        this.lcClient.delete((Iterable)entities).block();
        entities = (List)SelectQuery.from(CompositeIdEntity.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)entities.size());
    }

    @Test
    public void testEnum() {
        EnumEntity entity1 = new EnumEntity();
        entity1.setE1(EnumEntity.Enum1.V1);
        entity1.setI(1);
        this.enumRepo.save(entity1).block();
        entity1 = (EnumEntity)this.enumRepo.findAll().blockFirst();
        Assertions.assertEquals((int)1, (int)entity1.getI());
        Assertions.assertEquals((Object)((Object)EnumEntity.Enum1.V1), (Object)((Object)entity1.getE1()));
        EnumEntity entity2 = new EnumEntity();
        entity2.setE1(EnumEntity.Enum1.V2);
        entity2.setI(2);
        EnumEntity entity3 = new EnumEntity();
        entity3.setE1(EnumEntity.Enum1.V3);
        entity3.setI(3);
        this.enumRepo.saveAll(Arrays.asList(entity2, entity3)).collectList().block();
        List list = (List)this.enumRepo.findAll().collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        HashSet<Integer> done = new HashSet<Integer>();
        for (EnumEntity e : list) {
            switch (e.getI()) {
                case 1: {
                    Assertions.assertEquals((Object)((Object)EnumEntity.Enum1.V1), (Object)((Object)e.getE1()));
                    break;
                }
                case 2: {
                    Assertions.assertEquals((Object)((Object)EnumEntity.Enum1.V2), (Object)((Object)e.getE1()));
                    break;
                }
                case 3: {
                    Assertions.assertEquals((Object)((Object)EnumEntity.Enum1.V3), (Object)((Object)e.getE1()));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + e.getI()));
                }
            }
            Assertions.assertFalse((boolean)done.contains(e.getI()));
            done.add(e.getI());
        }
        list = (List)SelectQuery.from(EnumEntity.class, (String)"e").where(Criteria.property((String)"e", (String)"e1").is((Object)EnumEntity.Enum1.V2)).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity2 = (EnumEntity)list.get(0);
        Assertions.assertEquals((int)2, (int)entity2.getI());
        entity2.setE1(EnumEntity.Enum1.V3);
        this.lcClient.save((Object)entity2).block();
        Assertions.assertEquals((long)0L, (Long)((Long)SelectQuery.from(EnumEntity.class, (String)"e").where(Criteria.property((String)"e", (String)"e1").is((Object)EnumEntity.Enum1.V2)).executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)2L, (Long)((Long)SelectQuery.from(EnumEntity.class, (String)"e").where(Criteria.property((String)"e", (String)"e1").is((Object)EnumEntity.Enum1.V3)).executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)1L, (Long)((Long)SelectQuery.from(EnumEntity.class, (String)"e").where(Criteria.property((String)"e", (String)"e1").is((Object)EnumEntity.Enum1.V1)).executeCount(this.lcClient).block()));
    }

    @Test
    public void testNonSenseOperations() {
        BooleanTypes b = new BooleanTypes();
        this.lcClient.delete((Object)b).block();
    }
}

