/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.lecousin.reactive.data.relational.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.data.annotation.Transient;

/**
 * Indicates a many to many relationship.<br/>
 * A join table will be created, using the specified table name and column name.<br/>
 * If it exists several many to many relationships between the two same entities, the tableName or joinProperty can be used to avoid ambiguity.
 * 
 * @author Guillaume Le Cousin
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
@Transient
public @interface JoinTable {

	/**
	 * Specifies the table name to use for the join.
	 * By default the name is generated by concatenating the name of the two tables. 
	 */
	String tableName() default "";
	
	/**
	 * Specifies the name of the column to use in the join table to store the foreign key to this entity.
	 * By default the name of the entity table is used.
	 */
	String columnName() default "";
	
	/**
	 * Specifies the property on the linked entity to use for the join.
	 */
	String joinProperty() default "";
	
}
