/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.lecousin.reactive.data.relational.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a value being generated by the database system.
 * 
 * @author Guillaume Le Cousin
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
public @interface GeneratedValue {
	
	enum Strategy {
		/** Use auto increment/serial capability from database. */
		AUTO_INCREMENT,
		/** Use a sequence. Sequence name must be specified. */
		SEQUENCE,
		/** Generate a random UUID. Must be used only with a column of type java.util.UUID. */
		RANDOM_UUID;
	}
	
	/** Strategy to generate the value. */
	Strategy strategy() default Strategy.AUTO_INCREMENT;
	
	/** For SEQUENCE strategy, specifies the name of the sequence to use. */
	String sequence() default ""; 

}
