/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.sql;

import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.util.Assert;

public class ColumnIncrement {
    private Column column;
    private LcReactiveDataRelationalClient client;

    public ColumnIncrement(Column column, LcReactiveDataRelationalClient client) {
        this.column = column;
        this.client = client;
    }

    public String toString() {
        RenderContext context = this.client.getDataAccess().getStatementMapper().getRenderContext();
        Assert.notNull((Object)context, (String)"RenderContext must not be null");
        RenderNamingStrategy namingStrategy = context.getNamingStrategy();
        Assert.notNull((Object)namingStrategy, (String)"RenderNamingStrategy must not be null");
        TableLike table = this.column.getTable();
        Assert.notNull((Object)table, (String)"Table in Column must not be null");
        SqlIdentifier columnIdentifier = SqlIdentifier.from((SqlIdentifier[])new SqlIdentifier[]{namingStrategy.getReferenceName(table), namingStrategy.getReferenceName(this.column)});
        return columnIdentifier.toSql(context.getIdentifierProcessing()) + " + 1";
    }
}

