/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema.dialect;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaException;
import net.lecousin.reactive.data.relational.schema.Sequence;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatements;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.SimpleFunction;

public abstract class RelationalDatabaseSchemaDialect {
    public static final int DEFAULT_FLOATING_POINT_PRECISION = 10;
    public static final int DEFAULT_FLOATING_POINT_SCALE = 2;
    public static final int DEFAULT_TIME_PRECISION = 3;

    public static RelationalDatabaseSchemaDialect getDialect(R2dbcDialect r2dbcDialect) {
        return ServiceLoader.load(RelationalDatabaseSchemaDialect.class).stream().map(ServiceLoader.Provider::get).filter(dialect -> dialect.isCompatible(r2dbcDialect)).findFirst().orElseThrow();
    }

    public abstract String getName();

    public abstract boolean isCompatible(R2dbcDialect var1);

    public Object convertToDataBase(Object value, RelationalPersistentProperty property) {
        return value;
    }

    public Object convertFromDataBase(Object value, Class<?> targetType) {
        return value;
    }

    public String getColumnType(Column col, Class<?> type, ColumnDefinition def) {
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return this.getColumnTypeBoolean(col, type, def);
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return this.getColumnTypeByte(col, type, def);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return this.getColumnTypeShort(col, type, def);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return this.getColumnTypeInteger(col, type, def);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return this.getColumnTypeLong(col, type, def);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return this.getColumnTypeFloat(col, type, def);
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return this.getColumnTypeDouble(col, type, def);
        }
        if (BigDecimal.class.equals(type)) {
            return this.getColumnTypeBigDecimal(col, type, def);
        }
        if (String.class.equals(type) || char[].class.equals(type)) {
            return this.getColumnTypeString(col, type, def);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return this.getColumnTypeChar(col, type, def);
        }
        if (LocalDate.class.equals(type)) {
            return this.getColumnTypeDate(col, type, def);
        }
        if (LocalTime.class.equals(type)) {
            return this.getColumnTypeTime(col, type, def);
        }
        if (OffsetTime.class.equals(type)) {
            return this.getColumnTypeTimeWithTimeZone(col, type, def);
        }
        if (LocalDateTime.class.equals(type)) {
            return this.getColumnTypeDateTime(col, type, def);
        }
        if (ZonedDateTime.class.equals(type)) {
            return this.getColumnTypeDateTimeWithTimeZone(col, type, def);
        }
        if (Instant.class.equals(type)) {
            return this.getColumnTypeTimestamp(col, type, def);
        }
        if (UUID.class.equals(type)) {
            return this.getColumnTypeUUID(col, type, def);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.getColumnTypeEnum(col, type, def);
        }
        throw new SchemaException("Column type not supported: " + type.getName() + " on column " + col.getName() + " with " + this.getName());
    }

    public boolean isTimeZoneSupported() {
        return true;
    }

    protected String getColumnTypeBoolean(Column col, Class<?> type, ColumnDefinition def) {
        return "BOOLEAN";
    }

    protected String getColumnTypeByte(Column col, Class<?> type, ColumnDefinition def) {
        return "TINYINT";
    }

    protected String getColumnTypeShort(Column col, Class<?> type, ColumnDefinition def) {
        return "SMALLINT";
    }

    protected String getColumnTypeInteger(Column col, Class<?> type, ColumnDefinition def) {
        return "INT";
    }

    protected String getColumnTypeLong(Column col, Class<?> type, ColumnDefinition def) {
        return "BIGINT";
    }

    protected String getColumnTypeFloat(Column col, Class<?> type, ColumnDefinition def) {
        return "FLOAT";
    }

    protected String getColumnTypeDouble(Column col, Class<?> type, ColumnDefinition def) {
        return "DOUBLE";
    }

    protected String getColumnTypeBigDecimal(Column col, Class<?> type, ColumnDefinition def) {
        int scale;
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 10;
        }
        int n2 = scale = def != null ? def.scale() : -1;
        if (scale < 0) {
            scale = 2;
        }
        return "DECIMAL(" + precision + "," + scale + ")";
    }

    protected String getColumnTypeChar(Column col, Class<?> type, ColumnDefinition def) {
        return this.getColumnTypeShort(col, type, def);
    }

    protected String getColumnTypeString(Column col, Class<?> type, ColumnDefinition def) {
        if (def != null) {
            if (def.max() > Integer.MAX_VALUE) {
                return "CLOB(" + def.max() + ")";
            }
            if (def.max() > 0L) {
                return "VARCHAR(" + def.max() + ")";
            }
        }
        return "VARCHAR";
    }

    protected String getColumnTypeTimestamp(Column col, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIMESTAMP(" + precision + ")";
    }

    protected String getColumnTypeDate(Column col, Class<?> type, ColumnDefinition def) {
        return "DATE";
    }

    protected String getColumnTypeTime(Column col, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIME(" + precision + ")";
    }

    protected String getColumnTypeTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        int precision;
        if (!this.isTimeZoneSupported()) {
            throw new SchemaException("Time with timezone not supported by " + this.getName() + " for column " + col.getName() + " on type " + type.getName());
        }
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIME(" + precision + ") WITH TIME ZONE";
    }

    protected String getColumnTypeDateTime(Column col, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "DATETIME(" + precision + ")";
    }

    protected String getColumnTypeDateTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        int precision;
        if (!this.isTimeZoneSupported()) {
            throw new SchemaException("DateTime with timezone not supported by " + this.getName() + " for column " + col.getName() + " on type " + type.getName());
        }
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "DATETIME(" + precision + ") WITH TIME ZONE";
    }

    protected String getColumnTypeUUID(Column col, Class<?> type, ColumnDefinition def) {
        return "UUID";
    }

    protected String getColumnTypeEnum(Column col, Class<?> type, ColumnDefinition def) {
        int max = 1;
        for (Object enumValue : type.getEnumConstants()) {
            max = Math.max(max, enumValue.toString().length());
        }
        return "VARCHAR(" + max + ")";
    }

    public SchemaStatements dropSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        HashMap<Table, SchemaStatement> dropTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement dropTable = new SchemaStatement(this.dropTable(table));
            toExecute.add(dropTable);
            dropTableMap.put(table, dropTable);
        }
        for (Table table : schema.getTables()) {
            for (Column col : table.getColumns()) {
                if (col.getForeignKeyReferences() == null || col.getForeignKeyReferences().getFirst() == table) continue;
                ((SchemaStatement)dropTableMap.get(col.getForeignKeyReferences().getFirst())).addDependency((SchemaStatement)dropTableMap.get(table));
            }
        }
        if (this.supportsSequence()) {
            for (Sequence s : schema.getSequences()) {
                toExecute.add(new SchemaStatement(this.dropSequence(s)));
            }
        }
        return toExecute;
    }

    public String dropTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP TABLE IF EXISTS ");
        sql.append(table.getName());
        return sql.toString();
    }

    public SchemaStatements createSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        Map<Table, SchemaStatement> createTableMap = this.createTables(schema, toExecute);
        this.addConstraints(schema, toExecute, createTableMap);
        this.createSequences(schema, toExecute);
        return toExecute;
    }

    private Map<Table, SchemaStatement> createTables(RelationalDatabaseSchema schema, SchemaStatements toExecute) {
        HashMap<Table, SchemaStatement> createTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement createTable = new SchemaStatement(this.createTable(table));
            createTableMap.put(table, createTable);
            toExecute.add(createTable);
            for (Index index : table.getIndexes()) {
                if (this.canCreateIndexInTableDefinition(index)) continue;
                SchemaStatement createIndex = new SchemaStatement(this.createIndex(table, index));
                createIndex.addDependency(createTable);
                toExecute.add(createIndex);
            }
        }
        return createTableMap;
    }

    private void createSequences(RelationalDatabaseSchema schema, SchemaStatements toExecute) {
        if (!this.supportsSequence()) {
            return;
        }
        for (Sequence s : schema.getSequences()) {
            toExecute.add(new SchemaStatement(this.createSequence(s)));
        }
    }

    private void addConstraints(RelationalDatabaseSchema schema, SchemaStatements toExecute, Map<Table, SchemaStatement> createTableMap) {
        HashMap<Table, List<SchemaStatement>> alterTableByTable = new HashMap<Table, List<SchemaStatement>>();
        HashMap<SchemaStatement, Table> foreignTable = new HashMap<SchemaStatement, Table>();
        MutableObject latestAlterTable = new MutableObject(null);
        for (Table table : schema.getTables()) {
            this.addTableConstraints(table, toExecute, createTableMap, alterTableByTable, foreignTable, (MutableObject<SchemaStatement>)latestAlterTable);
        }
        for (Map.Entry entry : foreignTable.entrySet()) {
            for (SchemaStatement statement : (List)alterTableByTable.get(entry.getValue())) {
                ((SchemaStatement)entry.getKey()).doNotExecuteTogether(statement);
            }
        }
    }

    private void addTableConstraints(Table table, SchemaStatements toExecute, Map<Table, SchemaStatement> createTableMap, Map<Table, List<SchemaStatement>> alterTableByTable, Map<SchemaStatement, Table> foreignTable, MutableObject<SchemaStatement> latestAlterTable) {
        LinkedList<SchemaStatement> alterTableList = new LinkedList<SchemaStatement>();
        StringBuilder sql = new StringBuilder();
        HashSet<Table> foreignTables = new HashSet<Table>();
        foreignTables.add(table);
        for (Column col : table.getColumns()) {
            if (col.getForeignKeyReferences() == null) continue;
            if (this.canAddMultipleConstraintsInSingleAlterTable()) {
                this.appendForeignKeyConstraint(table, col, sql);
                foreignTables.add((Table)col.getForeignKeyReferences().getFirst());
                continue;
            }
            toExecute.add(this.createAlterTableAddForeignKey(table, col, createTableMap, alterTableList, foreignTable, latestAlterTable));
        }
        if (this.canAddMultipleConstraintsInSingleAlterTable() && sql.length() > 0) {
            SchemaStatement alterTable = new SchemaStatement(sql.toString());
            for (Table foreign : foreignTables) {
                alterTable.addDependency(createTableMap.get(foreign));
            }
            if (!this.canDoConcurrentAlterTable()) {
                RelationalDatabaseSchemaDialect.addAlterTable(latestAlterTable, alterTable);
            }
            toExecute.add(alterTable);
        }
        alterTableByTable.put(table, alterTableList);
    }

    private void appendForeignKeyConstraint(Table table, Column col, StringBuilder sql) {
        if (sql.length() > 0) {
            this.appendForeignKey(table, col, sql);
        } else {
            sql.append(this.alterTableForeignKey(table, col));
        }
    }

    private SchemaStatement createAlterTableAddForeignKey(Table table, Column col, Map<Table, SchemaStatement> createTableMap, LinkedList<SchemaStatement> alterTableList, Map<SchemaStatement, Table> foreignTable, MutableObject<SchemaStatement> latestAlterTable) {
        SchemaStatement alterTable = new SchemaStatement(this.alterTableForeignKey(table, col));
        alterTable.addDependency(createTableMap.get(table));
        Table foreign = (Table)col.getForeignKeyReferences().getFirst();
        if (foreign != table) {
            alterTable.addDependency(createTableMap.get(foreign));
        }
        if (this.canDoConcurrentAlterTable()) {
            if (!alterTableList.isEmpty()) {
                alterTable.addDependency(alterTableList.getLast());
            }
            alterTableList.addLast(alterTable);
            if (foreign != table) {
                foreignTable.put(alterTable, table);
            }
        } else {
            RelationalDatabaseSchemaDialect.addAlterTable(latestAlterTable, alterTable);
        }
        return alterTable;
    }

    private static void addAlterTable(MutableObject<SchemaStatement> latestAlterTable, SchemaStatement alterTable) {
        if (latestAlterTable.getValue() != null) {
            alterTable.addDependency((SchemaStatement)latestAlterTable.getValue());
        }
        latestAlterTable.setValue((Object)alterTable);
    }

    protected boolean canDoConcurrentAlterTable() {
        return true;
    }

    protected boolean canAddMultipleConstraintsInSingleAlterTable() {
        return false;
    }

    protected boolean canCreateIndexInTableDefinition(Index index) {
        return false;
    }

    public String createTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(table.getName());
        sql.append(" (");
        boolean first = true;
        for (Column col : table.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            this.addColumnDefinition(col, sql);
        }
        for (Index index : table.getIndexes()) {
            if (!this.canCreateIndexInTableDefinition(index)) continue;
            sql.append(", ");
            this.addIndexDefinitionInTable(table, index, sql);
        }
        sql.append(')');
        return sql.toString();
    }

    public String createIndex(Table table, Index index) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (index.isUnique()) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(index.getName());
        sql.append(" ON ");
        sql.append(table.getName());
        sql.append('(');
        boolean first = true;
        for (String col : index.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append(col);
        }
        sql.append(')');
        return sql.toString();
    }

    protected void addColumnDefinition(Column col, StringBuilder sql) {
        sql.append(col.getName());
        sql.append(' ');
        sql.append(col.getType());
        if (col.isRandomUuid() && this.supportsUuidGeneration()) {
            this.addDefaultRandomUuid(col, sql);
        }
        if (!col.isNullable()) {
            this.addNotNull(col, sql);
        }
        if (col.isAutoIncrement()) {
            this.addAutoIncrement(col, sql);
        }
        if (col.isPrimaryKey()) {
            this.addPrimaryKey(col, sql);
        }
    }

    protected void addIndexDefinitionInTable(Table table, Index index, StringBuilder sql) {
    }

    protected void addNotNull(Column col, StringBuilder sql) {
        sql.append(" NOT NULL");
    }

    protected void addAutoIncrement(Column col, StringBuilder sql) {
        sql.append(" AUTO_INCREMENT");
    }

    public boolean supportsUuidGeneration() {
        return true;
    }

    protected void addDefaultRandomUuid(Column col, StringBuilder sql) {
        sql.append(" DEFAULT RANDOM_UUID()");
    }

    protected void addPrimaryKey(Column col, StringBuilder sql) {
        sql.append(" PRIMARY KEY");
    }

    protected String alterTableForeignKey(Table table, Column col) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(table.getName());
        this.addForeignKeyStatement(table, col, sql);
        return sql.toString();
    }

    protected void addForeignKeyStatement(Table table, Column col, StringBuilder sql) {
        sql.append(" ADD FOREIGN KEY (");
        sql.append(col.getName());
        sql.append(") REFERENCES ");
        sql.append(((Table)col.getForeignKeyReferences().getFirst()).getName());
        sql.append('(');
        sql.append(((Column)col.getForeignKeyReferences().getSecond()).getName());
        sql.append(')');
    }

    protected void appendForeignKey(Table table, Column col, StringBuilder sql) {
        sql.append(',');
        this.addForeignKeyStatement(table, col, sql);
    }

    public boolean supportsSequence() {
        return true;
    }

    protected String dropSequence(Sequence sequence) {
        return "DROP SEQUENCE IF EXISTS " + sequence.getName();
    }

    protected String createSequence(Sequence sequence) {
        return "CREATE SEQUENCE " + sequence.getName() + " START WITH 1 INCREMENT BY 1";
    }

    public String sequenceNextValueFunctionName() {
        return "NEXTVAL";
    }

    public Expression applyFunctionTo(SqlFunction function, Expression expression) {
        switch (function) {
            case DAY_OF_MONTH: {
                return SimpleFunction.create((String)"DAY_OF_MONTH", Collections.singletonList(expression));
            }
            case DAY_OF_YEAR: {
                return SimpleFunction.create((String)"DAY_OF_YEAR", Collections.singletonList(expression));
            }
            case HOUR: {
                return SimpleFunction.create((String)"HOUR", Collections.singletonList(expression));
            }
            case ISO_DAY_OF_WEEK: {
                return SimpleFunction.create((String)"ISO_DAY_OF_WEEK", Collections.singletonList(expression));
            }
            case ISO_WEEK: {
                return SimpleFunction.create((String)"ISO_WEEK", Collections.singletonList(expression));
            }
            case LOWER: {
                return SimpleFunction.create((String)"LOWER", Collections.singletonList(expression));
            }
            case MINUTE: {
                return SimpleFunction.create((String)"MINUTE", Collections.singletonList(expression));
            }
            case MONTH: {
                return SimpleFunction.create((String)"MONTH", Collections.singletonList(expression));
            }
            case SECOND: {
                return SimpleFunction.create((String)"SECOND", Collections.singletonList(expression));
            }
            case UPPER: {
                return SimpleFunction.create((String)"UPPER", Collections.singletonList(expression));
            }
            case YEAR: {
                return SimpleFunction.create((String)"YEAR", Collections.singletonList(expression));
            }
        }
        throw new SchemaException("Unknown SQL function: " + function);
    }

    public Expression countDistinct(List<Expression> expressions) {
        return Functions.count((Expression[])new Expression[]{SimpleFunction.create((String)"DISTINCT", expressions)});
    }

    public boolean isMultipleInsertSupported() {
        return true;
    }

    public static enum SqlFunction {
        UPPER,
        LOWER,
        ISO_DAY_OF_WEEK,
        DAY_OF_MONTH,
        DAY_OF_YEAR,
        MONTH,
        YEAR,
        ISO_WEEK,
        HOUR,
        MINUTE,
        SECOND;

    }
}

