/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

abstract class AbstractInstanceProcessor<R extends Request>
extends AbstractProcessor<R> {
    private Map<RelationalPersistentEntity<?>, Map<Object, R>> requests = new HashMap();

    AbstractInstanceProcessor() {
    }

    public <T> R addToProcess(Operation op, T instance, @Nullable RelationalPersistentEntity<T> entity, @Nullable EntityState state, @Nullable PersistentPropertyAccessor<T> accessor) {
        return this.addRequest(op, instance, entity, state, accessor);
    }

    public <T> R addToNotProcess(Operation op, T instance, @Nullable RelationalPersistentEntity<T> entity, @Nullable EntityState state, @Nullable PersistentPropertyAccessor<T> accessor) {
        R request = this.addRequest(op, instance, entity, state, accessor);
        ((Request)request).toProcess = false;
        return request;
    }

    List<R> getPendingRequests(RelationalPersistentEntity<?> entity, Predicate<R> predicate) {
        LinkedList<Request> list = new LinkedList<Request>();
        Map<Object, R> map = this.requests.get(entity);
        if (map == null) {
            return list;
        }
        for (Request request : map.values()) {
            if (!request.toProcess || request.executed || !request.state.isPersisted() || !request.state.isLoaded() || !predicate.test(request)) continue;
            list.add(request);
        }
        return list;
    }

    boolean processRequests(Operation op) {
        boolean somethingProcessed = false;
        for (Map<Object, R> map : new ArrayList<Map<Object, R>>(this.requests.values())) {
            for (Request request : new ArrayList<R>(map.values())) {
                somethingProcessed |= this.process(op, request);
            }
        }
        return somethingProcessed;
    }

    private boolean process(Operation op, R request) {
        if (((Request)request).processed || !((Request)request).toProcess) {
            return false;
        }
        ((Request)request).processed = true;
        if (!this.doProcess(op, request)) {
            return false;
        }
        this.processForeignKeys(op, request);
        this.processForeignTables(op, request);
        return true;
    }

    private void processForeignKeys(Operation op, R request) {
        for (RelationalPersistentProperty property : ((Request)request).entityType) {
            ForeignKey fkAnnotation = (ForeignKey)property.findAnnotation(ForeignKey.class);
            if (fkAnnotation == null) continue;
            LcEntityTypeInfo.ForeignTableInfo fti = LcEntityTypeInfo.get(property.getActualType()).getForeignTableWithFieldForJoinKey(property.getName(), ((Request)request).entityType.getType());
            this.processForeignKey(op, request, property, fkAnnotation, fti);
        }
    }

    private void processForeignTables(Operation op, R request) {
        for (LcEntityTypeInfo.ForeignTableInfo fti : LcEntityTypeInfo.get(((Request)request).instance.getClass()).getForeignTables()) {
            MutableObject foreignFieldValue;
            boolean isCollection = fti.isCollection();
            RelationalPersistentEntity foreignEntity = (RelationalPersistentEntity)op.lcClient.getMappingContext().getRequiredPersistentEntity(isCollection ? fti.getCollectionElementType() : fti.getField().getType());
            RelationalPersistentProperty fkProperty = (RelationalPersistentProperty)foreignEntity.getRequiredPersistentProperty(fti.getAnnotation().joinKey());
            ForeignKey fk = (ForeignKey)fkProperty.findAnnotation(ForeignKey.class);
            try {
                foreignFieldValue = ((Request)request).state.getForeignTableField(((Request)request).instance, fti.getField().getName());
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to get foreign table field", e);
            }
            this.processForeignTableField(op, request, fti, foreignFieldValue, foreignEntity, fkProperty, fk);
        }
    }

    protected abstract <T> R createRequest(T var1, EntityState var2, RelationalPersistentEntity<T> var3, PersistentPropertyAccessor<T> var4);

    protected abstract boolean doProcess(Operation var1, R var2);

    protected abstract void processForeignKey(Operation var1, R var2, RelationalPersistentProperty var3, ForeignKey var4, @Nullable LcEntityTypeInfo.ForeignTableInfo var5);

    protected abstract <T> void processForeignTableField(Operation var1, R var2, LcEntityTypeInfo.ForeignTableInfo var3, @Nullable MutableObject<?> var4, RelationalPersistentEntity<T> var5, RelationalPersistentProperty var6, ForeignKey var7);

    private <T> R addRequest(Operation op, T instance, @Nullable RelationalPersistentEntity<T> entity, @Nullable EntityState state, @Nullable PersistentPropertyAccessor<T> accessor) {
        if (entity == null) {
            entity = (RelationalPersistentEntity)op.lcClient.getMappingContext().getRequiredPersistentEntity(instance.getClass());
        }
        if (accessor == null) {
            accessor = entity.getPropertyAccessor(instance);
        }
        if (state == null) {
            state = EntityState.get(instance, op.lcClient, entity);
        }
        instance = op.cache.getOrSet(state, entity, accessor, op.lcClient);
        Map map = this.requests.computeIfAbsent(entity, e -> new HashMap());
        Request r = (Request)map.get(instance);
        if (r == null) {
            r = this.createRequest(instance, state, entity, accessor);
            map.put(instance, r);
        }
        return (R)r;
    }

    @Override
    protected Mono<Void> executeRequests(Operation op) {
        LinkedList<Mono<Void>> executions = new LinkedList<Mono<Void>>();
        for (Map.Entry<RelationalPersistentEntity<?>, Map<Object, R>> entity : this.requests.entrySet()) {
            LinkedList<Request> ready = new LinkedList<Request>();
            for (Request request : entity.getValue().values()) {
                if (!this.canExecuteRequest(request)) continue;
                ready.add(request);
            }
            if (ready.isEmpty()) continue;
            Mono<Void> execution = this.doRequests(op, entity.getKey(), ready);
            if (execution != null) {
                executions.add((Mono<Void>)execution.doOnSuccess(v -> ready.forEach(r -> {
                    r.executed = true;
                })));
                continue;
            }
            ready.forEach(r -> {
                r.executed = true;
            });
        }
        return Operation.executeParallel(executions);
    }

    protected abstract Mono<Void> doRequests(Operation var1, RelationalPersistentEntity<?> var2, List<R> var3);

    static abstract class Request
    extends AbstractProcessor.Request {
        Object instance;
        EntityState state;
        PersistentPropertyAccessor<?> accessor;
        boolean processed = false;
        boolean toProcess = true;

        <T> Request(RelationalPersistentEntity<T> entityType, T instance, EntityState state, PersistentPropertyAccessor<T> accessor) {
            super(entityType);
            this.instance = instance;
            this.state = state;
            this.accessor = accessor;
        }

        @Override
        protected boolean canExecute() {
            return this.processed && super.canExecute();
        }

        @Override
        protected boolean isDone() {
            return !this.toProcess || super.isDone();
        }
    }
}

