/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.model.PropertiesSourceMap;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaSqlBuilder;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;

public class SelectExecution<T> {
    private static final Log logger = LogFactory.getLog(SelectExecution.class);
    private SelectQuery<T> query;
    private LcReactiveDataRelationalClient client;
    private LcEntityReader reader;

    public SelectExecution(SelectQuery<T> query, LcReactiveDataRelationalClient client, @Nullable LcEntityReader reader) {
        this.query = query;
        this.client = client;
        this.reader = reader != null ? reader : new LcEntityReader(null, client.getMapper());
    }

    public Flux<T> execute() {
        return Mono.fromCallable(this::needsPreSelectIds).flatMapMany(needsPreSelect -> needsPreSelect != false ? this.executeWithPreSelect() : this.executeWithoutPreSelect()).checkpoint(this.query.toString());
    }

    public Mono<Long> executeCount() {
        List<Column> idColumns;
        this.query.setJoinsTargetType(this.client.getMapper());
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        SelectMapping mapping = this.buildSelectMapping();
        if (entity.hasIdProperty()) {
            idColumns = Collections.singletonList(Column.create((SqlIdentifier)entity.getIdColumn(), (Table)mapping.tableByAlias.get(this.query.from.alias)));
        } else if (entity.isAnnotationPresent(CompositeId.class)) {
            String[] properties = ((CompositeId)entity.getRequiredAnnotation(CompositeId.class)).properties();
            idColumns = new ArrayList<Column>(properties.length);
            for (String property : properties) {
                idColumns.add(Column.create((SqlIdentifier)((RelationalPersistentProperty)entity.getRequiredPersistentProperty(property)).getColumnName(), (Table)mapping.tableByAlias.get(this.query.from.alias)));
            }
        } else {
            throw new IllegalArgumentException("Cannot count distinct entities without an Id column or a CompoisteId");
        }
        SelectBuilder.SelectFromAndJoin select = Select.builder().select(this.client.getSchemaDialect().countDistinct(idColumns)).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, false)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client);
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q.execute().fetch().one().map(m -> (Long)m.values().iterator().next());
    }

    private boolean needsPreSelectIds() {
        this.query.setJoinsTargetType(this.client.getMapper());
        if (!this.hasJoinMany()) {
            return false;
        }
        if (this.query.limit > 0L) {
            return true;
        }
        return this.hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity() || this.hasConditionOnManyEntity();
    }

    private boolean hasJoinMany() {
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.isMany(join)) continue;
            return true;
        }
        return false;
    }

    private boolean isMany(SelectQuery.TableReference table) {
        if (table.source == null) {
            return false;
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(table.source.targetType);
        try {
            Field field = entity.getType().getDeclaredField(table.propertyName);
            return ModelUtils.isCollection(field);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isManyFromRoot(SelectQuery.TableReference table) {
        while (table.source != null) {
            if (this.isMany(table)) {
                return true;
            }
            table = table.source;
        }
        return false;
    }

    private boolean hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity() {
        if (this.query.orderBy.isEmpty()) {
            return false;
        }
        for (Tuple3<String, String, Boolean> order : this.query.orderBy) {
            SelectQuery.TableReference table = this.query.tableAliases.get(order.getT1());
            if (table == this.query.from) continue;
            return true;
        }
        return this.hasConditionOnSubEntity();
    }

    private boolean hasConditionOnSubEntity() {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (table != SelectExecution.this.query.from) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && (table = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName())) != SelectExecution.this.query.from) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private boolean hasConditionOnManyEntity() {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.this.isManyFromRoot(table)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.this.isManyFromRoot(table = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private static boolean isSourceFor(SelectQuery.TableReference t1, SelectQuery.TableReference t2) {
        while (t2 != null) {
            if (t1 == t2) {
                return true;
            }
            t2 = t2.source;
        }
        return false;
    }

    private boolean needsTableForPreSelect(final SelectQuery.TableReference table, boolean includeOrderBy) {
        if (includeOrderBy) {
            for (Tuple3<String, String, Boolean> order : this.query.orderBy) {
                SelectQuery.TableReference t = this.query.tableAliases.get(order.getT1());
                if (!SelectExecution.isSourceFor(table, t)) continue;
                return true;
            }
        }
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference t = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.isSourceFor(table, t)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.isSourceFor(table, t = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private Flux<T> executeWithPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        return this.buildDistinctRootIdSql(mapping).execute().fetch().all().map(row -> row.values().iterator().next()).buffer(100).flatMap(ids -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pre-selected ids bunch: " + Objects.toString(ids)));
            }
            String idPropertyName = ((RelationalPersistentProperty)mapping.entitiesByAlias.get(this.query.from.alias).getIdProperty()).getName();
            Flux fromDb = this.buildFinalSql(mapping, Criteria.property(this.query.from.alias, idPropertyName).in((Collection<?>)ids), false, true).execute().fetch().all();
            return Flux.create(sink -> {
                RowHandlerSorted handler = new RowHandlerSorted(mapping, sink, (List<Object>)ids);
                fromDb.doOnComplete(handler::handleEnd).subscribe(handler::handleRow, arg_0 -> ((FluxSink)sink).error(arg_0));
            });
        });
    }

    private Flux<T> executeWithoutPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        Flux fromDb = this.buildFinalSql(mapping, this.query.where, true, this.hasJoinMany()).execute().fetch().all();
        return Flux.create(sink -> {
            RowHandler handler = new RowHandler(mapping, sink);
            fromDb.doOnComplete(handler::handleEnd).subscribe(handler::handleRow, arg_0 -> ((FluxSink)sink).error(arg_0));
        });
    }

    private SelectMapping buildSelectMapping() {
        SelectMapping mapping = new SelectMapping();
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        HashMap<String, String> fieldAliases = new HashMap<String, String>();
        mapping.fieldAliasesByTableAlias.put(this.query.from.alias, fieldAliases);
        mapping.entitiesByAlias.put(this.query.from.alias, entity);
        mapping.tableByAlias.put(this.query.from.alias, Table.create((SqlIdentifier)entity.getTableName()).as(this.query.from.alias));
        for (RelationalPersistentProperty property : entity) {
            String alias = mapping.generateAlias();
            mapping.fields.add(new SelectField(this.query.from.alias, property, alias));
            fieldAliases.put(property.getName(), alias);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            RelationalPersistentEntity joinEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.targetType);
            fieldAliases = new HashMap();
            mapping.fieldAliasesByTableAlias.put(join.alias, fieldAliases);
            mapping.entitiesByAlias.put(join.alias, joinEntity);
            mapping.tableByAlias.put(join.alias, Table.create((SqlIdentifier)joinEntity.getTableName()).as(join.alias));
            for (RelationalPersistentProperty property : joinEntity) {
                String alias = mapping.generateAlias();
                mapping.fields.add(new SelectField(join.alias, property, alias));
                fieldAliases.put(property.getName(), alias);
            }
        }
        return mapping;
    }

    private SqlQuery<Select> buildFinalSql(SelectMapping mapping, Criteria criteria, boolean applyLimitAndOrderBy, boolean orderById) {
        ArrayList<Column> selectFields = new ArrayList<Column>(mapping.fields.size());
        for (SelectField selectField : mapping.fields) {
            selectFields.add(selectField.toSql());
        }
        SelectBuilder.SelectFromAndJoin select = Select.builder().select(selectFields).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        if (applyLimitAndOrderBy) {
            select = this.addLimit((SelectBuilder.BuildSelect)select);
            select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> sqlQuery = new SqlQuery<Select>(this.client);
        if (criteria != null) {
            select = ((SelectBuilder.SelectWhere)select).where(criteria.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, sqlQuery)));
        }
        if (orderById) {
            RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
            if (entity.hasIdProperty()) {
                select = ((SelectBuilder.SelectOrdered)select).orderBy(new Column[]{Column.aliased((String)((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName(), (Table)mapping.tableByAlias.get(this.query.from.alias), (String)mapping.fieldAliasesByTableAlias.get(this.query.from.alias).get(((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName()))});
            } else if (entity.isAnnotationPresent(CompositeId.class)) {
                String[] properties = ((CompositeId)entity.getRequiredAnnotation(CompositeId.class)).properties();
                Column[] columns = new Column[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    RelationalPersistentProperty property = (RelationalPersistentProperty)entity.getRequiredPersistentProperty(properties[i]);
                    columns[i] = Column.aliased((String)property.getName(), (Table)mapping.tableByAlias.get(this.query.from.alias), (String)mapping.fieldAliasesByTableAlias.get(this.query.from.alias).get(property.getName()));
                }
                select = ((SelectBuilder.SelectOrdered)select).orderBy(columns);
            }
        }
        sqlQuery.setQuery(select.build());
        return sqlQuery;
    }

    private SelectBuilder.BuildSelect addLimit(SelectBuilder.BuildSelect select) {
        if (this.query.limit > 0L) {
            return ((SelectBuilder.SelectFromAndJoin)select).limitOffset(this.query.limit, this.query.offset);
        }
        return select;
    }

    private SelectBuilder.BuildSelect addOrderBy(SelectBuilder.BuildSelect select) {
        if (!this.query.orderBy.isEmpty()) {
            ArrayList<OrderByField> list = new ArrayList<OrderByField>(this.query.orderBy.size());
            for (Tuple3<String, String, Boolean> orderBy : this.query.orderBy) {
                SelectQuery.TableReference table = this.query.tableAliases.get(orderBy.getT1());
                RelationalPersistentEntity e = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(table.targetType);
                RelationalPersistentProperty p = (RelationalPersistentProperty)e.getRequiredPersistentProperty((String)orderBy.getT2());
                OrderByField o = OrderByField.from((Column)Column.create((SqlIdentifier)p.getColumnName(), (Table)Table.create((SqlIdentifier)e.getTableName()).as(table.alias)), (Sort.Direction)((Boolean)orderBy.getT3() != false ? Sort.Direction.ASC : Sort.Direction.DESC));
                list.add(o);
            }
            return ((SelectBuilder.SelectFromAndOrderBy)select).orderBy(list);
        }
        return select;
    }

    private SqlQuery<Select> buildDistinctRootIdSql(SelectMapping mapping) {
        if (this.query.limit > 0L && !this.query.orderBy.isEmpty() || this.hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity()) {
            return this.buildDistinctRootIdSqlUsingGroupBy(mapping);
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        SelectBuilder.SelectFromAndJoin select = Select.builder().select((Expression)Column.create((SqlIdentifier)entity.getIdColumn(), (Table)mapping.tableByAlias.get(this.query.from.alias))).distinct().from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        select = this.addLimit((SelectBuilder.BuildSelect)select);
        select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, true)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client);
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q;
    }

    private SqlQuery<Select> buildDistinctRootIdSqlUsingGroupBy(final SelectMapping mapping) {
        final RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        SelectBuilder.SelectFromAndJoin select = Select.builder().select((Expression)Column.create((SqlIdentifier)entity.getIdColumn(), (Table)mapping.tableByAlias.get(this.query.from.alias))).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, true)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client){

            @Override
            protected String finalizeQuery(String sql) {
                StringBuilder s = new StringBuilder(sql);
                s.append(" GROUP BY ").append(Column.create((SqlIdentifier)entity.getIdColumn(), (Table)mapping.tableByAlias.get(SelectExecution.this.query.from.alias)));
                s.append(" ORDER BY ");
                for (Tuple3<String, String, Boolean> orderBy : SelectExecution.this.query.orderBy) {
                    SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(orderBy.getT1());
                    RelationalPersistentEntity e = (RelationalPersistentEntity)SelectExecution.this.client.getMappingContext().getRequiredPersistentEntity(table.targetType);
                    RelationalPersistentProperty p = (RelationalPersistentProperty)e.getRequiredPersistentProperty((String)orderBy.getT2());
                    Column col = Column.create((SqlIdentifier)p.getColumnName(), (Table)Table.create((SqlIdentifier)e.getTableName()).as(table.alias));
                    if (((Boolean)orderBy.getT3()).booleanValue()) {
                        s.append("MIN(").append(col).append(") ASC");
                        continue;
                    }
                    s.append("MAX(").append(col).append(") DESC");
                }
                if (SelectExecution.this.query.limit > 0L) {
                    s.append(" LIMIT ").append(SelectExecution.this.query.limit).append(" OFFSET ").append(SelectExecution.this.query.offset);
                }
                return s.toString();
            }
        };
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q;
    }

    private SelectBuilder.BuildSelect join(SelectBuilder.BuildSelect select, SelectQuery.TableReference join, SelectMapping mapping) {
        RelationalPersistentEntity sourceEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.source.targetType);
        RelationalPersistentEntity targetEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.targetType);
        RelationalPersistentProperty property = (RelationalPersistentProperty)sourceEntity.getPersistentProperty(join.propertyName);
        if (property != null) {
            Table joinTargetTable = mapping.tableByAlias.get(join.alias);
            Column joinTarget = Column.create((SqlIdentifier)targetEntity.getIdColumn(), (Table)joinTargetTable);
            Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
            Column joinSource = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinSourceTable);
            return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
        }
        ForeignTable ft = LcEntityTypeInfo.get(join.source.targetType).getRequiredForeignTableForProperty(join.propertyName);
        property = (RelationalPersistentProperty)targetEntity.getRequiredPersistentProperty(ft.joinKey());
        Table joinTargetTable = mapping.tableByAlias.get(join.alias);
        Column joinTarget = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinTargetTable);
        Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
        Column joinSource = Column.create((SqlIdentifier)sourceEntity.getIdColumn(), (Table)joinSourceTable);
        return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
    }

    private class RowHandlerSorted
    extends RowHandler {
        private LinkedList<Object> sortedIds;
        private Map<Object, T> waitingInstances;

        private RowHandlerSorted(SelectMapping mapping, FluxSink<T> sink, List<Object> sortedIds) {
            super(mapping, sink);
            this.waitingInstances = new HashMap();
            this.sortedIds = new LinkedList<Object>(sortedIds);
        }

        @Override
        protected void newRootReady(T root, Object rootId) {
            Object instance;
            Object nextId = this.sortedIds.getFirst();
            if (!rootId.equals(nextId)) {
                this.waitingInstances.put(rootId, root);
                return;
            }
            this.sink.next(root);
            this.sortedIds.removeFirst();
            while (!this.sortedIds.isEmpty() && !this.waitingInstances.isEmpty() && (instance = this.waitingInstances.remove(nextId = this.sortedIds.getFirst())) != null) {
                this.sink.next(instance);
                this.sortedIds.removeFirst();
            }
        }

        @Override
        protected void endOfRoots() {
            while (!this.waitingInstances.isEmpty()) {
                Object nextId = this.sortedIds.removeFirst();
                Object instance = this.waitingInstances.get(nextId);
                if (instance == null) continue;
                this.sink.next(instance);
            }
            this.sink.complete();
        }
    }

    private class RowHandler {
        protected JoinStatus rootStatus;
        protected FluxSink<T> sink;

        protected RowHandler(SelectMapping mapping, FluxSink<T> sink) {
            this.sink = sink;
            try {
                this.rootStatus = new JoinStatus(SelectExecution.this.query.from, null, mapping, SelectExecution.this.query.joins, SelectExecution.this.client.getMappingContext());
            }
            catch (Exception e) {
                throw new MappingException("Error initializing row mapper", (Throwable)e);
            }
        }

        public void handleRow(Map<String, Object> row) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result row = " + row));
            }
            PropertiesSourceMap source = new PropertiesSourceMap(row, this.rootStatus.aliases);
            Object rootId = this.rootStatus.idGetter.apply(source);
            if (this.rootStatus.currentInstance != null) {
                if (rootId != null && !this.rootStatus.currentId.equals(rootId)) {
                    Object instance = this.rootStatus.currentInstance;
                    Object id = this.rootStatus.currentId;
                    this.rootStatus.reset(null, SelectExecution.this.client);
                    this.newRootReady(instance, id);
                    this.rootStatus.readNewInstance(rootId, source, SelectExecution.this.reader, SelectExecution.this.client);
                }
            } else {
                this.rootStatus.readNewInstance(rootId, source, SelectExecution.this.reader, SelectExecution.this.client);
            }
            this.fillLinkedEntities(this.rootStatus, row);
        }

        public void handleEnd() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"End of rows");
            }
            if (this.rootStatus.currentInstance != null) {
                Object instance = this.rootStatus.currentInstance;
                Object id = this.rootStatus.currentId;
                this.rootStatus.reset(null, SelectExecution.this.client);
                this.newRootReady(instance, id);
            }
            this.endOfRoots();
        }

        protected void newRootReady(T root, Object rootId) {
            this.sink.next(root);
        }

        protected void endOfRoots() {
            this.sink.complete();
        }

        private void fillLinkedEntities(JoinStatus parent, Map<String, Object> row) {
            for (JoinStatus join : parent.joins) {
                try {
                    this.fillLinkedEntity(join, parent, row);
                }
                catch (Exception e) {
                    throw new MappingException("Error mapping result for entity " + join.entityType.getType().getName(), (Throwable)e);
                }
            }
        }

        private void fillLinkedEntity(JoinStatus join, JoinStatus parent, Map<String, Object> row) throws ReflectiveOperationException {
            PropertiesSourceMap source;
            Object id;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read join " + join.entityType.getType().getSimpleName() + " from " + parent.entityType.getType().getSimpleName()));
            }
            if ((id = join.idGetter.apply(source = new PropertiesSourceMap(row, join.aliases))) == null) {
                if (join.joinFieldIsCollection && join.joinField.get(parent.currentInstance) == null) {
                    join.joinField.set(parent.currentInstance, CollectionFactory.createCollection(join.joinField.getType(), ModelUtils.getCollectionType(join.joinField), (int)0));
                }
                return;
            }
            if (!id.equals(join.currentId)) {
                join.readNewInstance(id, source, SelectExecution.this.reader, SelectExecution.this.client);
                if (join.joinFieldIsCollection) {
                    ModelUtils.addToCollectionField(join.joinField, parent.currentInstance, join.currentInstance);
                } else if (LcEntityTypeInfo.isForeignTableField(join.joinField)) {
                    parent.currentInstanceState.setForeignTableField(parent.currentInstance, join.joinField, join.currentInstance, true);
                } else {
                    parent.currentInstanceState.setPersistedField(parent.currentInstance, join.joinField, join.currentInstance, true);
                }
            }
            this.fillLinkedEntities(join, row);
        }
    }

    private static class JoinStatus {
        private RelationalPersistentEntity<?> entityType;
        private Function<PropertiesSource, Object> idGetter;
        private Map<String, String> aliases;
        private Field joinField;
        private boolean joinFieldIsCollection;
        private List<JoinStatus> joins;
        private Object currentInstance = null;
        private Object currentId = null;
        private EntityState currentInstanceState;

        private JoinStatus(SelectQuery.TableReference table, SelectQuery.TableReference fromJoin, SelectMapping mapping, List<SelectQuery.TableReference> allJoins, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) throws ReflectiveOperationException {
            this.entityType = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(table.targetType);
            this.idGetter = ModelUtils.idGetter(this.entityType);
            this.aliases = mapping.fieldAliasesByTableAlias.get(table.alias);
            if (fromJoin != null) {
                this.joinField = fromJoin.targetType.getDeclaredField(table.propertyName);
                this.joinField.setAccessible(true);
                this.joinFieldIsCollection = ModelUtils.isCollection(this.joinField);
            }
            this.joins = new LinkedList<JoinStatus>();
            for (SelectQuery.TableReference join : allJoins) {
                if (join.source != table) continue;
                this.joins.add(new JoinStatus(join, table, mapping, allJoins, mappingContext));
            }
        }

        private void reset(Object parentInstance, LcReactiveDataRelationalClient client) {
            if (this.currentInstance == null) {
                return;
            }
            if (parentInstance != null && this.joinField.isAnnotationPresent(ForeignTable.class)) {
                try {
                    EntityState.get(parentInstance, client).foreignTableLoaded(this.joinField, this.joinField.get(parentInstance));
                }
                catch (Exception e) {
                    throw new MappingException("Error accessing to foreign table field " + this.joinField.getName() + " on " + this.joinField.getDeclaringClass().getName(), (Throwable)e);
                }
            }
            for (JoinStatus join : this.joins) {
                join.reset(this.currentInstance, client);
            }
            this.currentInstance = null;
            this.currentId = null;
            this.currentInstanceState = null;
        }

        private void readNewInstance(Object id, PropertiesSource source, LcEntityReader reader, LcReactiveDataRelationalClient client) {
            this.reset(null, client);
            this.currentId = id;
            if (id != null) {
                this.currentInstance = reader.getCache().getById(this.entityType.getType(), id);
                if (this.currentInstance != null) {
                    this.currentInstanceState = EntityState.get(this.currentInstance, client, this.entityType);
                    if (!this.currentInstanceState.isLoaded()) {
                        this.currentInstance = null;
                    }
                }
            }
            if (this.currentInstance == null) {
                this.currentInstance = reader.read(this.entityType, source);
                this.currentInstanceState = EntityState.get(this.currentInstance, client, this.entityType);
            }
        }
    }

    private static class SelectField {
        private String tableAlias;
        private RelationalPersistentProperty property;
        private String fieldAlias;

        public SelectField(String tableAlias, RelationalPersistentProperty property, String fieldAlias) {
            this.tableAlias = tableAlias;
            this.property = property;
            this.fieldAlias = fieldAlias;
        }

        public Column toSql() {
            return Column.create((SqlIdentifier)this.property.getColumnName(), (Table)Table.create((SqlIdentifier)this.property.getOwner().getTableName()).as(this.tableAlias)).as(this.fieldAlias);
        }
    }

    private static class SelectMapping {
        private Map<String, RelationalPersistentEntity<?>> entitiesByAlias = new HashMap();
        private Map<String, Table> tableByAlias = new HashMap<String, Table>();
        private Map<String, Map<String, String>> fieldAliasesByTableAlias = new HashMap<String, Map<String, String>>();
        private List<SelectField> fields = new LinkedList<SelectField>();
        private int aliasCounter = 0;

        private SelectMapping() {
        }

        private String generateAlias() {
            int num = this.aliasCounter++;
            return "f" + StringUtils.leftPad((String)Integer.toString(num), (int)4, (char)'0');
        }
    }
}

