/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.CompositeIdValue;
import net.lecousin.reactive.data.relational.model.InvalidEntityStateException;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;

public class ModelUtils {
    private ModelUtils() {
    }

    public static boolean isNullable(RelationalPersistentProperty property) {
        if (property.getRawType().isPrimitive()) {
            return false;
        }
        if (property.isIdProperty()) {
            return false;
        }
        ForeignKey fk = (ForeignKey)property.findAnnotation(ForeignKey.class);
        if (fk != null) {
            return fk.optional();
        }
        ColumnDefinition def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            return def.nullable();
        }
        return true;
    }

    public static boolean isUpdatable(RelationalPersistentProperty property) {
        if (!property.isWritable()) {
            return false;
        }
        if (property.isIdProperty()) {
            return false;
        }
        ColumnDefinition def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            return def.updatable();
        }
        return true;
    }

    public static void setReverseLink(Object instance, Object linkedInstance, RelationalPersistentProperty linkedProperty) {
        LcEntityTypeInfo.ForeignTableInfo ft = LcEntityTypeInfo.get(instance.getClass()).getForeignTableWithFieldForJoinKey(linkedProperty.getName(), linkedInstance.getClass());
        if (ft != null && !ft.isCollection()) {
            try {
                ft.getField().set(instance, linkedInstance);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to set ForeignTable field " + ft.getField().getName() + " on " + instance.getClass().getSimpleName() + " with value " + linkedInstance, e);
            }
        }
    }

    public static List<Field> getAllFields(Class<?> cl) {
        LinkedList<Field> fields = new LinkedList<Field>();
        ModelUtils.getAllFields(cl, fields);
        return fields;
    }

    private static void getAllFields(Class<?> cl, List<Field> fields) {
        if (cl == null) {
            return;
        }
        Collections.addAll(fields, cl.getDeclaredFields());
        ModelUtils.getAllFields(cl.getSuperclass(), fields);
    }

    public static Object getRequiredId(Object instance, RelationalPersistentEntity<?> entityType, @Nullable PersistentPropertyAccessor<?> accessor) {
        RelationalPersistentProperty idProperty;
        Object id = (accessor != null ? accessor : entityType.getPropertyAccessor(instance)).getProperty((PersistentProperty)(idProperty = (RelationalPersistentProperty)entityType.getRequiredIdProperty()));
        if (id == null) {
            throw new InvalidEntityStateException("Entity is supposed to be persisted to database, but it's Id property is null");
        }
        return id;
    }

    public static boolean isCollection(Field field) {
        return ModelUtils.isCollectionType(field.getType());
    }

    public static boolean isCollectionType(Class<?> type) {
        if (type.isArray()) {
            return !char[].class.equals(type);
        }
        return Collection.class.isAssignableFrom(type);
    }

    @Nullable
    public static <T> Collection<T> getAsCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    @Nullable
    public static Class<?> getCollectionType(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> getRequiredCollectionType(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
        }
        throw new MappingException("Field is not a collection: " + field.getDeclaringClass().getName() + "." + field.getName());
    }

    public static void addToCollectionField(Field field, Object collectionOwnerInstance, Object elementToAdd) throws IllegalAccessException {
        if (field.getType().isArray()) {
            Object[] array = (Object[])field.get(collectionOwnerInstance);
            if (array == null) {
                array = (Object[])Array.newInstance(field.getType().getComponentType(), 1);
                array[0] = elementToAdd;
                field.set(collectionOwnerInstance, array);
                return;
            }
            if (ArrayUtils.contains((Object[])array, (Object)elementToAdd)) {
                return;
            }
            Object[] newArray = (Object[])Array.newInstance(field.getType().getComponentType(), array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = elementToAdd;
            field.set(collectionOwnerInstance, newArray);
            return;
        }
        Collection collectionInstance = (Collection)field.get(collectionOwnerInstance);
        if (collectionInstance == null) {
            collectionInstance = CollectionFactory.createCollection(field.getType(), ModelUtils.getCollectionType(field), (int)10);
            field.set(collectionOwnerInstance, collectionInstance);
        }
        if (!collectionInstance.contains(elementToAdd)) {
            collectionInstance.add(elementToAdd);
        }
    }

    public static void removeFromCollectionField(Field field, Object collectionOwnerInstance, Object elementToRemove) throws IllegalAccessException {
        if (field.getType().isArray()) {
            Object[] array = (Object[])field.get(collectionOwnerInstance);
            if (array == null) {
                return;
            }
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != elementToRemove) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return;
            }
            Object[] newArray = (Object[])Array.newInstance(field.getType().getComponentType(), array.length - 1);
            if (index > 0) {
                System.arraycopy(array, 0, newArray, 0, index);
            }
            if (index < array.length - 1) {
                System.arraycopy(array, index + 1, newArray, index, array.length - index - 1);
            }
            field.set(collectionOwnerInstance, newArray);
            return;
        }
        Collection collectionInstance = (Collection)field.get(collectionOwnerInstance);
        if (collectionInstance == null) {
            return;
        }
        collectionInstance.remove(elementToRemove);
    }

    public static Object getDatabaseValue(Object instance, RelationalPersistentProperty property, LcReactiveDataRelationalClient client) {
        Object value;
        Field f = property.getRequiredField();
        f.setAccessible(true);
        try {
            value = f.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new ModelAccessException("Unable to get field value", e);
        }
        if (value == null) {
            return null;
        }
        if (property.isAnnotationPresent(ForeignKey.class)) {
            RelationalPersistentEntity e = (RelationalPersistentEntity)client.getMappingContext().getRequiredPersistentEntity(value.getClass());
            value = e.getPropertyAccessor(value).getProperty(e.getRequiredIdProperty());
        } else {
            value = client.getSchemaDialect().convertToDataBase(value, property);
        }
        return value;
    }

    public static Object getPersistedDatabaseValue(EntityState state, RelationalPersistentProperty property, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        Object value = state.getPersistedValue(property.getName());
        if (value == null) {
            return null;
        }
        if (property.isAnnotationPresent(ForeignKey.class)) {
            RelationalPersistentEntity e = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(value.getClass());
            value = e.getPropertyAccessor(value).getProperty(e.getRequiredIdProperty());
        }
        return value;
    }

    public static List<RelationalPersistentProperty> getProperties(RelationalPersistentEntity<?> entityType, String ... names) {
        ArrayList<RelationalPersistentProperty> list = new ArrayList<RelationalPersistentProperty>(names.length);
        for (String name : names) {
            list.add((RelationalPersistentProperty)entityType.getRequiredPersistentProperty(name));
        }
        return list;
    }

    public static Object getId(RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getIdPropertyValue(entityType, accessor);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getIdFromProperties(ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), accessor, client);
        }
        return ModelUtils.getIdFromProperties(entityType, accessor, client);
    }

    public static Object getIdPropertyValue(RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor) {
        return accessor.getProperty(entityType.getRequiredIdProperty());
    }

    public static CompositeIdValue getIdFromProperties(Iterable<RelationalPersistentProperty> properties, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        CompositeIdValue id = new CompositeIdValue();
        for (RelationalPersistentProperty property : properties) {
            id.add(property.getName(), ModelUtils.getDatabaseValue(accessor.getBean(), property, client));
        }
        return id;
    }

    public static Object getId(RelationalPersistentEntity<?> entityType, PropertiesSource source) {
        return ModelUtils.idGetter(entityType).apply(source);
    }

    public static Function<PropertiesSource, Object> idGetter(RelationalPersistentEntity<?> entityType) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.idGetterFromIdProperty(entityType);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.idGetterFromProperties(ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()));
        }
        return ModelUtils.idGetterFromProperties(entityType);
    }

    public static Function<PropertiesSource, Object> idGetterFromIdProperty(RelationalPersistentEntity<?> entityType) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entityType.getRequiredIdProperty();
        return source -> source.getPropertyValue(idProperty);
    }

    public static Function<PropertiesSource, Object> idGetterFromProperties(Iterable<RelationalPersistentProperty> properties) {
        return source -> {
            CompositeIdValue id = new CompositeIdValue();
            for (RelationalPersistentProperty property : properties) {
                id.add(property.getName(), source.getPropertyValue(property));
            }
            if (id.isNull()) {
                return null;
            }
            return id;
        };
    }

    public static Condition getConditionOnId(SqlQuery<?> query, RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getConditionOnProperties(query, entityType, Arrays.asList((RelationalPersistentProperty)entityType.getRequiredIdProperty()), accessor, client);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getConditionOnProperties(query, entityType, ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), accessor, client);
        }
        return ModelUtils.getConditionOnProperties(query, entityType, entityType, accessor, client);
    }

    public static Condition getConditionOnProperties(SqlQuery<?> query, RelationalPersistentEntity<?> entityType, Iterable<RelationalPersistentProperty> properties, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        Iterator<RelationalPersistentProperty> it = properties.iterator();
        Comparison condition = null;
        Table table = Table.create((SqlIdentifier)entityType.getTableName());
        do {
            RelationalPersistentProperty property = it.next();
            Object value = ModelUtils.getDatabaseValue(accessor.getBean(), property, client);
            Comparison propertyCondition = Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)(value != null ? query.marker(value) : SQL.nullLiteral()));
            Object object = condition = condition != null ? condition.and((Condition)propertyCondition) : propertyCondition;
        } while (it.hasNext());
        return condition;
    }

    public static Criteria getCriteriaOnId(String entityName, RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getCriteriaOnProperties(entityName, Arrays.asList((RelationalPersistentProperty)entityType.getRequiredIdProperty()), accessor, client);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getCriteriaOnProperties(entityName, ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), accessor, client);
        }
        return ModelUtils.getCriteriaOnProperties(entityName, entityType, accessor, client);
    }

    public static Criteria getCriteriaOnProperties(String entityName, Iterable<RelationalPersistentProperty> properties, PersistentPropertyAccessor<?> accessor, LcReactiveDataRelationalClient client) {
        Iterator<RelationalPersistentProperty> it = properties.iterator();
        Criteria condition = null;
        do {
            RelationalPersistentProperty property = it.next();
            Object value = ModelUtils.getDatabaseValue(accessor.getBean(), property, client);
            Criteria propertyCondition = value != null ? Criteria.property(entityName, property.getName()).is(value) : Criteria.property(entityName, property.getName()).isNull();
            Criteria criteria = condition = condition != null ? condition.and(propertyCondition) : propertyCondition;
        } while (it.hasNext());
        return condition;
    }

    public static boolean hasCascadeDeleteImpacts(Class<?> entityType, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        LcEntityTypeInfo typeInfo = LcEntityTypeInfo.get(entityType);
        if (!typeInfo.getForeignTables().isEmpty() || !typeInfo.getJoinTables().isEmpty()) {
            return true;
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(entityType);
        for (RelationalPersistentProperty property : entity) {
            ForeignKey fkAnnotation = (ForeignKey)property.findAnnotation(ForeignKey.class);
            if (fkAnnotation == null) continue;
            if (fkAnnotation.cascadeDelete()) {
                return true;
            }
            LcEntityTypeInfo foreignInfo = LcEntityTypeInfo.get(property.getActualType());
            LcEntityTypeInfo.ForeignTableInfo ft = foreignInfo.getForeignTableWithFieldForJoinKey(property.getName(), entityType);
            if (ft == null || ft.getAnnotation().optional()) continue;
            return true;
        }
        return false;
    }
}

