/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.lecousin.reactive.data.relational.model.ModelAccessException;

public class JoinTableCollectionToTargetCollection<J, T>
implements Set<T> {
    private Object sourceInstance;
    private Collection<J> sourceCollection;
    private Class<?> joinClass;
    private Field sourceField;
    private Field targetField;

    public JoinTableCollectionToTargetCollection(Object sourceInstance, Collection<J> sourceCollection, String joinClassName, int sourceAttributeLinkNumber) {
        this.sourceInstance = sourceInstance;
        this.sourceCollection = sourceCollection;
        try {
            this.joinClass = this.getClass().getClassLoader().loadClass(joinClassName);
            this.sourceField = this.joinClass.getDeclaredField("entity" + sourceAttributeLinkNumber);
            this.sourceField.setAccessible(true);
            this.targetField = this.joinClass.getDeclaredField("entity" + (sourceAttributeLinkNumber == 1 ? 2 : 1));
            this.targetField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ModelAccessException("Error initializing JoinTableCollectionToTargetCollection on " + joinClassName, e);
        }
    }

    private T getTarget(J join) {
        try {
            return (T)this.targetField.get(join);
        }
        catch (Exception e) {
            throw new ModelAccessException("Error getting field " + this.targetField.getName() + " on join table class " + this.joinClass.getName(), e);
        }
    }

    @Override
    public int size() {
        return this.sourceCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sourceCollection.isEmpty();
    }

    @Override
    public void clear() {
        this.sourceCollection.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (J jt : this.sourceCollection) {
            if (!Objects.equals(o, this.getTarget(jt))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<J> it = this.sourceCollection.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return JoinTableCollectionToTargetCollection.this.getTarget(it.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((R[])new Object[this.sourceCollection.size()]);
    }

    @Override
    public <R> R[] toArray(R[] a) {
        if (a.length < this.sourceCollection.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.sourceCollection.size());
        }
        int i = 0;
        for (T e : this) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        if (this.contains(e)) {
            return false;
        }
        try {
            Object join = this.joinClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sourceField.set(join, this.sourceInstance);
            this.targetField.set(join, e);
            this.sourceCollection.add(join);
            return true;
        }
        catch (Exception err) {
            throw new ModelAccessException("Error instantiating join entity " + this.joinClass.getName(), err);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Iterator<J> it = this.sourceCollection.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(o, this.getTarget(it.next()))) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object e : c) {
            result |= this.remove(e);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator<J> it = this.sourceCollection.iterator();
        while (it.hasNext()) {
            if (c.contains(this.getTarget(it.next()))) continue;
            it.remove();
            result = true;
        }
        return result;
    }
}

