/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;

public class EntityCache {
    private Map<Class<?>, Map<Object, Object>> cache = new HashMap();

    public <T> T getById(Class<T> type, Object id) {
        Map<Object, Object> instances = this.cache.get(type);
        if (instances == null) {
            return null;
        }
        return (T)instances.get(id);
    }

    public <T> void setById(Class<T> type, Object id, T instance) {
        Map instances = this.cache.computeIfAbsent(type, t -> new HashMap());
        instances.put(id, instance);
    }

    public <T> T getOrSet(EntityState state, RelationalPersistentEntity<T> entity, PersistentPropertyAccessor<T> accessor, LcReactiveDataRelationalClient client) {
        Object id;
        if (!state.isPersisted()) {
            return (T)accessor.getBean();
        }
        Map map = this.cache.computeIfAbsent(entity.getType(), e -> new HashMap());
        Object known = map.get(id = ModelUtils.getId(entity, accessor, client));
        if (known == null) {
            map.put(id, accessor.getBean());
            return (T)accessor.getBean();
        }
        if (known == accessor.getBean()) {
            return (T)accessor.getBean();
        }
        return (T)known;
    }
}

