/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.envelopemodel;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.envelopemodel.Document;
import net.lecousin.reactive.data.relational.test.envelopemodel.Envelope;
import net.lecousin.reactive.data.relational.test.envelopemodel.EnvelopeRepository;
import net.lecousin.reactive.data.relational.test.envelopemodel.Note;
import net.lecousin.reactive.data.relational.test.envelopemodel.Page;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public class AbstractTestEnvelopeModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private EnvelopeRepository envRepo;
    private static final Comparator<Page> pageSorter = (p1, p2) -> p1.getPageIndex() - p2.getPageIndex();

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(Envelope.class, Document.class, Page.class, Note.class);
    }

    private static Envelope createEnvelope(LocalDate receiveDate, String ... notes) {
        Envelope env = new Envelope();
        env.setReceiveDate(receiveDate);
        env.setDocuments(new HashSet<Document>());
        env.setNotes(new HashSet<Note>());
        for (String note : notes) {
            Note n = new Note();
            n.setEnvelope(env);
            n.setText(note);
            env.getNotes().add(n);
        }
        return env;
    }

    private static Document createDocument(Envelope env, String type, String ... notes) {
        Document doc = new Document();
        doc.setDocumentType(type);
        doc.setEnvelope(env);
        doc.setNotes(new HashSet<Note>());
        doc.setPages(new HashSet<Page>());
        env.getDocuments().add(doc);
        for (String note : notes) {
            Note n = new Note();
            n.setDocument(doc);
            n.setText(note);
            doc.getNotes().add(n);
        }
        return doc;
    }

    private static void createPage(Document doc, int index, String ... notes) {
        Page page = new Page();
        page.setPageIndex(index);
        page.setDocument(doc);
        page.setNotes(new HashSet<Note>());
        doc.getPages().add(page);
        for (String note : notes) {
            Note n = new Note();
            n.setText(note);
            n.setPage(page);
            page.getNotes().add(n);
        }
    }

    private static Envelope createEnvelope(LocalDate receiveDate, String[] notes, List<Tuple3<String, String[], List<String[]>>> docsAndPages) {
        Envelope env = AbstractTestEnvelopeModel.createEnvelope(receiveDate, notes);
        for (Tuple3<String, String[], List<String[]>> docTuple : docsAndPages) {
            Document doc = AbstractTestEnvelopeModel.createDocument(env, (String)docTuple.getT1(), (String[])docTuple.getT2());
            int index = 1;
            for (String[] pageNotes : (List)docTuple.getT3()) {
                AbstractTestEnvelopeModel.createPage(doc, index++, pageNotes);
            }
        }
        return env;
    }

    @Test
    public void test1() {
        Envelope e1 = AbstractTestEnvelopeModel.createEnvelope(LocalDate.of(2014, 3, 25), new String[]{"hello", "world"}, Arrays.asList(Tuples.of((Object)"DOC1", (Object)new String[]{"note doc 1"}, Arrays.asList({"page 1.1", "page 1.2", "page 1.3"}, {"page 2.1"}, {"page 3.1", "page 3.2"}))));
        Envelope e2 = AbstractTestEnvelopeModel.createEnvelope(LocalDate.of(2016, 2, 13), new String[0], Arrays.asList(Tuples.of((Object)"DOC2.1", (Object)new String[]{"note1 doc 2.1", "note2 doc 2.1"}, Arrays.asList({"doc 2.1 page 1.1", "doc 2.1 page 1.2"}, new String[0], {"doc 2.1 page 3.1"})), Tuples.of((Object)"DOC2.2", (Object)new String[]{"note1 doc 2.2", "note2 doc 2.2"}, Arrays.asList({"doc 2.2 page 1.1"}, {"doc 2.2 page 3.1", "doc 2.2 page 3.2"}))));
        Envelope e3 = AbstractTestEnvelopeModel.createEnvelope(LocalDate.of(2020, 12, 3), new String[]{"env 3 note 1", "env 3 note 2"}, Arrays.asList(Tuples.of((Object)"DOC3.1", (Object)new String[]{"note 1 env 3 doc 1", "note 2 env 3 doc 1"}, Arrays.asList({"env 3 doc 1 page 1.1", "env 3 doc 1 page 1.2"}, {"env 3 doc 1 page 2.1"})), Tuples.of((Object)"DOC3.2", (Object)new String[]{"note1 doc 3.2", "note2 doc 3.2"}, Arrays.asList({"env 3 doc 2 page 1.1"}, {"env 3 doc 2 page 2.1"}, {"env 3 doc 2 page 3.1", "env 3 doc 2 page 3.2"}))));
        this.lcClient.saveAll(new Object[]{e1, e2, e3}).block();
        Assertions.assertEquals((long)3L, (Long)((Long)SelectQuery.from(Envelope.class, (String)"env").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)5L, (Long)((Long)SelectQuery.from(Document.class, (String)"doc").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)13L, (Long)((Long)SelectQuery.from(Page.class, (String)"page").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)32L, (Long)((Long)SelectQuery.from(Note.class, (String)"note").executeCount(this.lcClient).block()));
        List envelopes = (List)SelectQuery.from(Envelope.class, (String)"env").join("env", "documents", "doc").join("doc", "pages", "page").join("env", "notes", "en").join("doc", "notes", "dn").join("page", "notes", "pn").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)envelopes.size());
        e1 = envelopes.stream().filter(e -> e.getReceiveDate().getYear() == 2014).findAny().get();
        e2 = envelopes.stream().filter(e -> e.getReceiveDate().getYear() == 2016).findAny().get();
        e3 = envelopes.stream().filter(e -> e.getReceiveDate().getYear() == 2020).findAny().get();
        Assertions.assertEquals((int)2, (int)e1.getNotes().size());
        Assertions.assertTrue((boolean)e1.getNotes().stream().anyMatch(note -> note.getText().equals("hello")));
        Assertions.assertTrue((boolean)e1.getNotes().stream().anyMatch(note -> note.getText().equals("world")));
        Assertions.assertEquals((int)0, (int)e2.getNotes().size());
        Assertions.assertEquals((int)2, (int)e3.getNotes().size());
        Assertions.assertTrue((boolean)e3.getNotes().stream().anyMatch(note -> note.getText().equals("env 3 note 1")));
        Assertions.assertTrue((boolean)e3.getNotes().stream().anyMatch(note -> note.getText().equals("env 3 note 2")));
        Assertions.assertEquals((int)1, (int)e1.getDocuments().size());
        Document doc1_1 = e1.getDocuments().iterator().next();
        Assertions.assertEquals((Object)"DOC1", (Object)doc1_1.getDocumentType());
        Assertions.assertEquals((int)2, (int)e2.getDocuments().size());
        Document doc2_1 = e2.getDocuments().stream().filter(doc -> "DOC2.1".equals(doc.getDocumentType())).findAny().get();
        Document doc2_2 = e2.getDocuments().stream().filter(doc -> "DOC2.2".equals(doc.getDocumentType())).findAny().get();
        Assertions.assertEquals((int)2, (int)e3.getDocuments().size());
        Document doc3_1 = e3.getDocuments().stream().filter(doc -> "DOC3.1".equals(doc.getDocumentType())).findAny().get();
        Document doc3_2 = e3.getDocuments().stream().filter(doc -> "DOC3.2".equals(doc.getDocumentType())).findAny().get();
        Assertions.assertEquals((int)3, (int)doc1_1.getPages().size());
        ArrayList<Page> pages1_1 = new ArrayList<Page>(doc1_1.getPages());
        pages1_1.sort(pageSorter);
        Assertions.assertEquals((int)1, (int)((Page)pages1_1.get(0)).getPageIndex());
        Assertions.assertEquals((int)2, (int)((Page)pages1_1.get(1)).getPageIndex());
        Assertions.assertEquals((int)3, (int)((Page)pages1_1.get(2)).getPageIndex());
        Assertions.assertEquals((int)3, (int)doc2_1.getPages().size());
        ArrayList<Page> pages2_1 = new ArrayList<Page>(doc2_1.getPages());
        pages2_1.sort(pageSorter);
        Assertions.assertEquals((int)1, (int)((Page)pages2_1.get(0)).getPageIndex());
        Assertions.assertEquals((int)2, (int)((Page)pages2_1.get(1)).getPageIndex());
        Assertions.assertEquals((int)3, (int)((Page)pages2_1.get(2)).getPageIndex());
        Assertions.assertEquals((int)2, (int)doc2_2.getPages().size());
        ArrayList<Page> pages2_2 = new ArrayList<Page>(doc2_2.getPages());
        pages2_2.sort(pageSorter);
        Assertions.assertEquals((int)1, (int)((Page)pages2_2.get(0)).getPageIndex());
        Assertions.assertEquals((int)2, (int)((Page)pages2_2.get(1)).getPageIndex());
        Assertions.assertEquals((int)2, (int)doc3_1.getPages().size());
        ArrayList<Page> pages3_1 = new ArrayList<Page>(doc3_1.getPages());
        pages3_1.sort(pageSorter);
        Assertions.assertEquals((int)1, (int)((Page)pages3_1.get(0)).getPageIndex());
        Assertions.assertEquals((int)2, (int)((Page)pages3_1.get(1)).getPageIndex());
        Assertions.assertEquals((int)3, (int)doc3_2.getPages().size());
        ArrayList<Page> pages3_2 = new ArrayList<Page>(doc3_2.getPages());
        pages3_2.sort(pageSorter);
        Assertions.assertEquals((int)1, (int)((Page)pages3_2.get(0)).getPageIndex());
        Assertions.assertEquals((int)2, (int)((Page)pages3_2.get(1)).getPageIndex());
        Assertions.assertEquals((int)3, (int)((Page)pages3_2.get(2)).getPageIndex());
        Assertions.assertEquals((int)1, (int)doc1_1.getNotes().size());
        Assertions.assertEquals((Object)"note doc 1", (Object)doc1_1.getNotes().iterator().next().getText());
        Assertions.assertEquals((int)2, (int)doc2_1.getNotes().size());
        Assertions.assertTrue((boolean)doc2_1.getNotes().stream().anyMatch(note -> "note1 doc 2.1".equals(note.getText())));
        Assertions.assertTrue((boolean)doc2_1.getNotes().stream().anyMatch(note -> "note2 doc 2.1".equals(note.getText())));
        Assertions.assertEquals((int)2, (int)doc2_2.getNotes().size());
        Assertions.assertTrue((boolean)doc2_2.getNotes().stream().anyMatch(note -> "note1 doc 2.2".equals(note.getText())));
        Assertions.assertTrue((boolean)doc2_2.getNotes().stream().anyMatch(note -> "note2 doc 2.2".equals(note.getText())));
        Assertions.assertEquals((int)2, (int)doc3_1.getNotes().size());
        Assertions.assertTrue((boolean)doc3_1.getNotes().stream().anyMatch(note -> "note 1 env 3 doc 1".equals(note.getText())));
        Assertions.assertTrue((boolean)doc3_1.getNotes().stream().anyMatch(note -> "note 2 env 3 doc 1".equals(note.getText())));
        Assertions.assertEquals((int)2, (int)doc3_2.getNotes().size());
        Assertions.assertTrue((boolean)doc3_2.getNotes().stream().anyMatch(note -> "note1 doc 3.2".equals(note.getText())));
        Assertions.assertTrue((boolean)doc3_2.getNotes().stream().anyMatch(note -> "note2 doc 3.2".equals(note.getText())));
    }
}

