package net.lecousin.reactive.data.relational.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.data.annotation.Transient;

/**
 * Indicates a many to many relationship.<br/>
 * A join table will be created, using the specified table name and column name.<br/>
 * If it exists several many to many relationships between the two same entities, the tableName or joinProperty can be used to avoid ambiguity.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
@Transient
public @interface JoinTable {

	/**
	 * Specifies the table name to use for the join.
	 * By default the name is generated by concatenating the name of the two tables. 
	 */
	String tableName() default "";
	
	/**
	 * Specifies the name of the column to use in the join table to store the foreign key to this entity.
	 * By default the name of the entity table is used.
	 */
	String columnName() default "";
	
	/**
	 * Specifies the property on the linked entity to use for the join.
	 */
	String joinProperty() default "";
	
}
