/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import reactor.core.publisher.Mono;

class EntityLoader {
    private Map<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> toLoad = new HashMap();
    private Map<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> toRetrieve = new HashMap();

    EntityLoader() {
    }

    Mono<Void> doOperations(Operation op) {
        LinkedList<Mono<Void>> loads = new LinkedList<Mono<Void>>();
        this.doLoad(op, loads);
        this.doRetrieve(op, loads);
        return Operation.executeParallel(loads);
    }

    <T> void load(RelationalPersistentEntity<?> entity, T instance, Consumer<T> onLoaded) {
        Map map = this.toLoad.computeIfAbsent(entity, e -> new HashMap());
        List consumers = map.computeIfAbsent(instance, v -> new LinkedList());
        consumers.add(onLoaded);
    }

    private void doLoad(Operation op, List<Mono<Void>> loads) {
        Map<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> map = this.toLoad;
        this.toLoad = new HashMap();
        for (Map.Entry<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> entity : map.entrySet()) {
            loads.add((Mono<Void>)op.lcClient.lazyLoad(entity.getValue().keySet(), entity.getKey()).doOnNext(loaded -> {
                for (Consumer consumer : (List)((Map)entity.getValue()).get(loaded)) {
                    op.toCall(() -> consumer.accept(loaded));
                }
            }).then());
        }
    }

    void retrieve(RelationalPersistentEntity<?> entity, RelationalPersistentProperty property, Object propertyValue, Consumer<Object> consumer) {
        Map map = this.toRetrieve.computeIfAbsent(entity, e -> new HashMap());
        Map byValue = map.computeIfAbsent(property, p -> new HashMap());
        List list = byValue.computeIfAbsent(propertyValue, v -> new LinkedList());
        list.add(consumer);
    }

    private void doRetrieve(Operation op, List<Mono<Void>> loads) {
        Map<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> map = this.toRetrieve;
        this.toRetrieve = new HashMap();
        for (Map.Entry<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> entity : map.entrySet()) {
            for (Map.Entry<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>> property : entity.getValue().entrySet()) {
                loads.add((Mono<Void>)op.lcClient.execute(SelectQuery.from(entity.getKey().getType(), "e").where(Criteria.property("e", property.getKey().getName()).in(property.getValue().keySet())), null).map(e -> EntityLoader.retrieved(e, op, (RelationalPersistentProperty)property.getKey(), (Map)property.getValue())).then());
            }
        }
    }

    private static <T> T retrieved(T entity, Operation op, RelationalPersistentProperty property, Map<Object, List<Consumer<Object>>> consumersMap) {
        try {
            List<Consumer<Object>> consumers = consumersMap.get(ModelUtils.getDatabaseValue(entity, property, op.lcClient));
            if (consumers != null) {
                for (Consumer<Object> c : consumers) {
                    op.toCall(() -> c.accept(entity));
                }
            }
            return entity;
        }
        catch (Exception e) {
            throw new MappingException("Error analyzing data from retrieved entity", (Throwable)e);
        }
    }
}

