/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.NamingStrategies;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.util.StringUtils;

public class InsertMultiple {
    private final Table into;
    private final List<Column> columns;
    private final List<InsertRowValues> values;

    public InsertMultiple(Table into, List<Column> columns, List<List<Expression>> values) {
        this.into = into;
        this.columns = new ArrayList<Column>(columns);
        this.values = new ArrayList<InsertRowValues>(values.size());
        for (List<Expression> list : values) {
            this.values.add(new InsertRowValues(new ArrayList<Expression>(list)));
        }
    }

    public String render(RenderContext renderContext) {
        if (renderContext == null) {
            renderContext = new SimpleRenderContext();
        }
        StringBuilder sql = new StringBuilder(512 + 16 * this.values.size());
        sql.append("INSERT INTO ");
        sql.append(InsertMultiple.render(renderContext.getNamingStrategy().getName((TableLike)this.into), renderContext));
        sql.append(" (");
        boolean first = true;
        for (Column col : this.columns) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append(InsertMultiple.render(renderContext.getNamingStrategy().getName(col), renderContext));
        }
        sql.append(") VALUES ");
        first = true;
        for (InsertRowValues row : this.values) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append('(');
            boolean firstValue = true;
            for (Expression value : row.expressions) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    sql.append(',');
                }
                sql.append(InsertMultiple.render(value, renderContext));
            }
            sql.append(')');
        }
        return sql.toString();
    }

    private static String render(SqlIdentifier identifier, RenderContext renderContext) {
        return identifier.toSql(renderContext.getIdentifierProcessing());
    }

    private static String render(Expression expression, RenderContext renderContext) {
        if (expression instanceof Named) {
            return InsertMultiple.render(((Named)expression).getName(), renderContext);
        }
        return expression.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(this.into);
        if (!this.columns.isEmpty()) {
            builder.append(" (").append(StringUtils.collectionToDelimitedString((Collection)this.columns.stream().map(col -> col.getName().toString()).collect(Collectors.toList()), (String)",")).append(")");
        }
        if (!this.values.isEmpty()) {
            builder.append(" VALUES ");
            builder.append(StringUtils.collectionToDelimitedString(this.values, (String)","));
        }
        return builder.toString();
    }

    public static class InsertRowValues {
        private List<Expression> expressions;

        InsertRowValues(List<Expression> expressions) {
            this.expressions = expressions;
        }

        public String toString() {
            return "(" + StringUtils.collectionToDelimitedString(this.expressions, (String)",") + ")";
        }
    }

    static class SimpleRenderContext
    implements RenderContext {
        private final RenderNamingStrategy namingStrategy = NamingStrategies.asIs();

        SimpleRenderContext() {
        }

        public IdentifierProcessing getIdentifierProcessing() {
            return IdentifierProcessing.NONE;
        }

        public SelectRenderContext getSelect() {
            return DefaultSelectRenderContext.INSTANCE;
        }

        public RenderNamingStrategy getNamingStrategy() {
            return this.namingStrategy;
        }

        static enum DefaultSelectRenderContext implements SelectRenderContext
        {
            INSTANCE;

        }
    }
}

