/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.tests;

import net.lecousin.reactive.data.relational.tests.MyWrongConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
class TestWrongConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    TestWrongConfiguration() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Test
    void testConfigurationClassWithoutConnectionFactory() {
        MyWrongConfiguration cfg = new MyWrongConfiguration();
        Assertions.assertNull((Object)cfg.connectionFactory());
        try {
            cfg.reactiveDataAccessStrategy(null);
            throw new AssertionError((Object)"Application context not initialized expected");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"ApplicationContext is not yet initialized", (Object)e.getMessage());
            cfg.setApplicationContext(this.applicationContext);
            try {
                cfg.reactiveDataAccessStrategy(null);
                throw new AssertionError((Object)"No connection factory error expected");
            }
            catch (Exception e2) {
                Assertions.assertEquals((Object)"No r2dbc connection factory defined", (Object)e2.getMessage());
                Assertions.assertThrows(IllegalArgumentException.class, () -> cfg.r2dbcConverter(null, null));
                return;
            }
        }
    }
}

